/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
        if (state2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(0);
        }
        if (errorHandler == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(1);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state2.beforeCompile();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCodegenFacade.doGenerateFiles(state2.getFiles(), state2, errorHandler);
    }

    public static void doGenerateFiles(@NotNull Collection<KtFile> files2, @NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
        if (files2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(2);
        }
        if (state2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(3);
        }
        if (errorHandler == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(4);
        }
        MultiMap<FqName, KtFile> filesInPackages = new MultiMap<FqName, KtFile>();
        MultiMap<FqName, KtFile> filesInMultifileClasses = new MultiMap<FqName, KtFile>();
        for (KtFile ktFile : files2) {
            if (ktFile == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            JvmFileClassInfo fileClassInfo = state2.getFileClassesProvider().getFileClassInfo(ktFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), ktFile);
                continue;
            }
            filesInPackages.putValue(ktFile.getPackageFqName(), ktFile);
        }
        HashSet<FqName> obsoleteMultifileClasses = new HashSet<FqName>(state2.getObsoleteMultifileClasses());
        for (FqName multifileClassFqName : Sets.union(filesInMultifileClasses.keySet(), obsoleteMultifileClasses)) {
            KotlinCodegenFacade.doCheckCancelled(state2);
            KotlinCodegenFacade.generateMultifileClass(state2, multifileClassFqName, filesInMultifileClasses.get(multifileClassFqName), errorHandler);
        }
        HashSet<FqName> hashSet = new HashSet<FqName>(state2.getPackagesWithObsoleteParts());
        for (FqName packageFqName : Sets.union(hashSet, filesInPackages.keySet())) {
            KotlinCodegenFacade.doCheckCancelled(state2);
            KotlinCodegenFacade.generatePackage(state2, packageFqName, filesInPackages.get(packageFqName), errorHandler);
        }
        KotlinCodegenFacade.doCheckCancelled(state2);
        state2.getFactory().done();
    }

    private static void doCheckCancelled(GenerationState state2) {
        if (state2.getClassBuilderMode().generateBodies) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
    }

    public static void generatePackage(@NotNull GenerationState state2, @NotNull FqName packageFqName, @NotNull Collection<KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(5);
        }
        if (packageFqName == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(6);
        }
        if (jetFiles == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(7);
        }
        if (errorHandler == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(8);
        }
        PackageCodegen codegen = state2.getFactory().forPackage(packageFqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private static void generateMultifileClass(@NotNull GenerationState state2, @NotNull FqName multifileClassFqName, @NotNull Collection<KtFile> files2, @NotNull CompilationErrorHandler handler2) {
        if (state2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(9);
        }
        if (multifileClassFqName == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(10);
        }
        if (files2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(11);
        }
        if (handler2 == null) {
            KotlinCodegenFacade.$$$reportNull$$$0(12);
        }
        MultifileClassCodegen codegen = state2.getFactory().forMultifileClass(multifileClassFqName, files2);
        codegen.generate(handler2);
    }

    private KotlinCodegenFacade() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multifileClassFqName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/KotlinCodegenFacade";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compileCorrectFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerateFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePackage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "generateMultifileClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

