/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.ConsoleReplConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.LineResult;
import org.jetbrains.kotlin.cli.jvm.repl.ReplConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.ReplErrorLogger;
import org.jetbrains.kotlin.cli.jvm.repl.ReplForIdeConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplWriter;
import org.jetbrains.kotlin.cli.jvm.repl.messages.UnescapeUtilsKt;
import org.jetbrains.kotlin.cli.jvm.repl.reader.ReplCommandReader;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0002-.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u001e\u001a\u00020\u001fH\u0096\u0001J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0011\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\tH\u0096\u0001J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020%H\u0003R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal;", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplConfiguration;", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "replConfiguration", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/repl/ReplConfiguration;)V", "allowIncompleteLines", "", "getAllowIncompleteLines", "()Z", "commandReader", "Lorg/jetbrains/kotlin/cli/jvm/repl/reader/ReplCommandReader;", "getCommandReader", "()Lorg/jetbrains/kotlin/cli/jvm/repl/reader/ReplCommandReader;", "errorLogger", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplErrorLogger;", "getErrorLogger", "()Lorg/jetbrains/kotlin/cli/jvm/repl/ReplErrorLogger;", "replInitializer", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter;", "replInterpreter", "getReplInterpreter", "()Lorg/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter;", "writer", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplWriter;", "getWriter", "()Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplWriter;", "createDiagnosticHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "doRun", "", "eval", "Lorg/jetbrains/kotlin/cli/jvm/repl/LineResult;", "line", "", "onUserCodeExecuting", "isExecuting", "one", "Lorg/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal$WhatNextAfterOneLine;", "next", "oneCommand", "command", "Companion", "WhatNextAfterOneLine", "kotlin-compiler"})
public final class ReplFromTerminal
implements ReplConfiguration {
    private final Future<ReplInterpreter> replInitializer;
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ ReplConfiguration $$delegate_0;

    private final ReplInterpreter getReplInterpreter() {
        ReplInterpreter replInterpreter = this.replInitializer.get();
        Intrinsics.checkExpressionValueIsNotNull(replInterpreter, "replInitializer.get()");
        return replInterpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doRun() {
        try {
            this.getWriter().printlnWelcomeMessage("Welcome to Kotlin version 1.1.2-5 " + ("(JRE " + System.getProperty("java.runtime.version") + ")"));
            this.getWriter().printlnWelcomeMessage("Type :help for help, :quit for quit");
            WhatNextAfterOneLine next = WhatNextAfterOneLine.READ_LINE;
            while (!Intrinsics.areEqual((Object)(next = this.one(next)), (Object)WhatNextAfterOneLine.QUIT)) {
            }
        }
        catch (Exception e) {
            try {
                Void void_ = this.getErrorLogger().logException(e);
                throw null;
            }
            catch (Throwable throwable) {
                try {
                    this.getCommandReader().flushHistory();
                    throw throwable;
                }
                catch (Exception e2) {
                    Void void_ = this.getErrorLogger().logException(e2);
                    throw null;
                }
            }
        }
        try {
            this.getCommandReader().flushHistory();
            return;
        }
        catch (Exception e) {
            Void void_ = this.getErrorLogger().logException(e);
            throw null;
        }
    }

    private final WhatNextAfterOneLine one(WhatNextAfterOneLine next) {
        String string = this.getCommandReader().readLine(next);
        if (string == null) {
            return WhatNextAfterOneLine.QUIT;
        }
        String line = string;
        String string2 = UnescapeUtilsKt.unescapeLineBreaks(line);
        Intrinsics.checkExpressionValueIsNotNull(string2, "unescapeLineBreaks(line)");
        line = string2;
        if (StringsKt.startsWith$default(line, ":", false, 2, null) && (line.length() == 1 || line.charAt(1) != ':')) {
            String string3 = line;
            int n = 1;
            ReplFromTerminal replFromTerminal = this;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            boolean notQuit = replFromTerminal.oneCommand(string6);
            return notQuit ? WhatNextAfterOneLine.READ_LINE : WhatNextAfterOneLine.QUIT;
        }
        LineResult lineResult = this.eval(line);
        if (lineResult instanceof LineResult.Incomplete) {
            return WhatNextAfterOneLine.INCOMPLETE;
        }
        return WhatNextAfterOneLine.READ_LINE;
    }

    private final LineResult eval(String line) {
        LineResult lineResult = this.getReplInterpreter().eval(line);
        LineResult lineResult2 = lineResult;
        if (lineResult2 instanceof LineResult.ValueResult || Intrinsics.areEqual(lineResult2, LineResult.UnitResult.INSTANCE)) {
            this.getWriter().notifyCommandSuccess();
            if (lineResult instanceof LineResult.ValueResult) {
                this.getWriter().outputCommandResult(((LineResult.ValueResult)lineResult).getValueAsString());
            }
        } else if (Intrinsics.areEqual(lineResult2, LineResult.Incomplete.INSTANCE)) {
            this.getWriter().notifyIncomplete();
        } else if (lineResult2 instanceof LineResult.Error.CompileTime) {
            this.getWriter().outputCompileError(((LineResult.Error.CompileTime)lineResult).getErrorText());
        } else if (lineResult2 instanceof LineResult.Error.Runtime) {
            this.getWriter().outputRuntimeError(((LineResult.Error.Runtime)lineResult).getErrorText());
        }
        return lineResult;
    }

    private final boolean oneCommand(String command) throws Exception {
        List split = ReplFromTerminal.Companion.splitCommand(command);
        if (split.size() >= 1 && Intrinsics.areEqual(command, "help")) {
            this.getWriter().printlnHelpMessage("Available commands:\n:help                   show this help\n:quit                   exit the interpreter\n:dump bytecode          dump classes to terminal\n:load <file>            load script from specified file");
            return true;
        }
        if (split.size() >= 2 && Intrinsics.areEqual((String)split.get(0), "dump") && Intrinsics.areEqual((String)split.get(1), "bytecode")) {
            this.getReplInterpreter().dumpClasses(new PrintWriter(System.out));
            return true;
        }
        if (split.size() >= 1 && Intrinsics.areEqual((String)split.get(0), "quit")) {
            return false;
        }
        if (split.size() >= 2 && Intrinsics.areEqual((String)split.get(0), "load")) {
            String scriptText;
            String fileName = (String)split.get(1);
            String string = scriptText = FileUtil.loadFile(new File(fileName));
            Intrinsics.checkExpressionValueIsNotNull(string, "scriptText");
            this.eval(string);
            return true;
        }
        this.getWriter().printlnHelpMessage("Unknown command\nType :help for help");
        return true;
    }

    public ReplFromTerminal(@NotNull Disposable disposable, @NotNull CompilerConfiguration compilerConfiguration, @NotNull ReplConfiguration replConfiguration) {
        Intrinsics.checkParameterIsNotNull(disposable, "disposable");
        Intrinsics.checkParameterIsNotNull(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkParameterIsNotNull(replConfiguration, "replConfiguration");
        this.$$delegate_0 = replConfiguration;
        Future future = Executors.newSingleThreadExecutor().submit((Callable)new Callable<ReplInterpreter>(disposable, compilerConfiguration, replConfiguration){
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ CompilerConfiguration $compilerConfiguration;
            final /* synthetic */ ReplConfiguration $replConfiguration;

            @NotNull
            public final ReplInterpreter call() {
                return new ReplInterpreter(this.$disposable, this.$compilerConfiguration, this.$replConfiguration);
            }
            {
                this.$disposable = disposable;
                this.$compilerConfiguration = compilerConfiguration;
                this.$replConfiguration = replConfiguration;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(future, "Executors.newSingleThrea\u2026replConfiguration)\n    })");
        this.replInitializer = future;
    }

    @Override
    public boolean getAllowIncompleteLines() {
        return this.$$delegate_0.getAllowIncompleteLines();
    }

    @Override
    @NotNull
    public ReplCommandReader getCommandReader() {
        return this.$$delegate_0.getCommandReader();
    }

    @Override
    @NotNull
    public ReplErrorLogger getErrorLogger() {
        return this.$$delegate_0.getErrorLogger();
    }

    @Override
    @NotNull
    public ReplWriter getWriter() {
        return this.$$delegate_0.getWriter();
    }

    @Override
    @NotNull
    public DiagnosticMessageHolder createDiagnosticHolder() {
        return this.$$delegate_0.createDiagnosticHolder();
    }

    @Override
    public void onUserCodeExecuting(boolean isExecuting) {
        this.$$delegate_0.onUserCodeExecuting(isExecuting);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal$WhatNextAfterOneLine;", "", "(Ljava/lang/String;I)V", "READ_LINE", "INCOMPLETE", "QUIT", "kotlin-compiler"})
    public static final class WhatNextAfterOneLine
    extends Enum<WhatNextAfterOneLine> {
        public static final /* enum */ WhatNextAfterOneLine READ_LINE;
        public static final /* enum */ WhatNextAfterOneLine INCOMPLETE;
        public static final /* enum */ WhatNextAfterOneLine QUIT;
        private static final /* synthetic */ WhatNextAfterOneLine[] $VALUES;

        static {
            WhatNextAfterOneLine[] whatNextAfterOneLineArray = new WhatNextAfterOneLine[3];
            WhatNextAfterOneLine[] whatNextAfterOneLineArray2 = whatNextAfterOneLineArray;
            whatNextAfterOneLineArray[0] = READ_LINE = new WhatNextAfterOneLine();
            whatNextAfterOneLineArray[1] = INCOMPLETE = new WhatNextAfterOneLine();
            whatNextAfterOneLineArray[2] = QUIT = new WhatNextAfterOneLine();
            $VALUES = whatNextAfterOneLineArray;
        }

        public static WhatNextAfterOneLine[] values() {
            return (WhatNextAfterOneLine[])$VALUES.clone();
        }

        public static WhatNextAfterOneLine valueOf(String string) {
            return Enum.valueOf(WhatNextAfterOneLine.class, string);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/ReplFromTerminal$Companion;", "", "()V", "run", "", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "splitCommand", "", "", "command", "kotlin-compiler"})
    public static final class Companion {
        private final List<String> splitCommand(String command) {
            List list2;
            Collection<String> $receiver$iv;
            CharSequence charSequence = command;
            Object object = " ";
            object = new Regex((String)object);
            int n = 0;
            int n2 = 2;
            Object var6_8 = null;
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if (!($receiver$iv = ((Regex)object).split(charSequence, n)).isEmpty()) {
                ListIterator<String> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p1 = iterator$iv.previous();
                    CharSequence charSequence2 = p1;
                    if (charSequence2.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$receiver$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Collection<String> collection = $receiver$iv = (Collection)list2;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection<String> thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            List<String> list3 = Arrays.asList(Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkExpressionValueIsNotNull(list3, "Arrays.asList(*command.s\u2026:isEmpty).toTypedArray())");
            return list3;
        }

        public final void run(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(disposable, "disposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            boolean replIdeMode = Intrinsics.areEqual(System.getProperty("kotlin.repl.ideMode"), "true");
            ReplConfiguration replConfiguration = replIdeMode ? (ReplConfiguration)new ReplForIdeConfiguration() : (ReplConfiguration)new ConsoleReplConfiguration();
            try {
                new ReplFromTerminal(disposable, configuration, replConfiguration).doRun();
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e) {
                Void void_ = replConfiguration.getErrorLogger().logException(e);
                throw null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

