/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.EnumSet;
import java.util.Set;
import kotlin.text.StringsKt;
import org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.org.fusesource.jansi.Ansi;

public abstract class PlainTextMessageRenderer
implements MessageRenderer {
    public static final boolean COLOR_ENABLED;
    private static final String LINE_SEPARATOR;
    private static final Set<CompilerMessageSeverity> IMPORTANT_MESSAGE_SEVERITIES;

    @Override
    public String renderPreamble() {
        return "";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
        if (severity == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(0);
        }
        if (message == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(1);
        }
        if (location2 == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(2);
        }
        StringBuilder result2 = new StringBuilder();
        int line = location2.getLine();
        int column = location2.getColumn();
        String lineContent = location2.getLineContent();
        String path = this.getPath(location2);
        if (path != null) {
            result2.append(path);
            result2.append(":");
            if (line > 0) {
                result2.append(line).append(":");
                if (column > 0) {
                    result2.append(column).append(":");
                }
            }
            result2.append(" ");
        }
        if (COLOR_ENABLED) {
            String decapitalized;
            int firstNewline;
            Ansi ansi = Ansi.ansi().bold().fg(PlainTextMessageRenderer.severityColor(severity)).a(severity.getPresentableName()).a(": ").reset();
            if (IMPORTANT_MESSAGE_SEVERITIES.contains((Object)severity)) {
                ansi.bold();
            }
            if ((firstNewline = (decapitalized = PlainTextMessageRenderer.decapitalizeIfNeeded(message)).indexOf(LINE_SEPARATOR)) < 0) {
                result2.append(ansi.a(decapitalized).reset());
            } else {
                result2.append(ansi.a(decapitalized.substring(0, firstNewline)).reset().a(decapitalized.substring(firstNewline)));
            }
        } else {
            result2.append(severity.getPresentableName());
            result2.append(": ");
            result2.append(PlainTextMessageRenderer.decapitalizeIfNeeded(message));
        }
        if (lineContent != null && 1 <= column && column <= lineContent.length() + 1) {
            result2.append(LINE_SEPARATOR);
            result2.append(lineContent);
            result2.append(LINE_SEPARATOR);
            result2.append(StringsKt.repeat(" ", column - 1));
            result2.append("^");
        }
        return result2.toString();
    }

    @NotNull
    private static String decapitalizeIfNeeded(@NotNull String message) {
        if (message == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(3);
        }
        if (message.startsWith("Java") || message.startsWith("Kotlin")) {
            String string = message;
            if (string == null) {
                PlainTextMessageRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (message.length() >= 2 && Character.isUpperCase(message.charAt(0)) && Character.isUpperCase(message.charAt(1))) {
            String string = message;
            if (string == null) {
                PlainTextMessageRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = StringsKt.decapitalize(message);
        if (string == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static Ansi.Color severityColor(@NotNull CompilerMessageSeverity severity) {
        if (severity == null) {
            PlainTextMessageRenderer.$$$reportNull$$$0(7);
        }
        switch (severity) {
            case EXCEPTION: {
                Ansi.Color color = Ansi.Color.RED;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(8);
                }
                return color;
            }
            case ERROR: {
                Ansi.Color color = Ansi.Color.RED;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(9);
                }
                return color;
            }
            case STRONG_WARNING: {
                Ansi.Color color = Ansi.Color.YELLOW;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(10);
                }
                return color;
            }
            case WARNING: {
                Ansi.Color color = Ansi.Color.YELLOW;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(11);
                }
                return color;
            }
            case INFO: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(12);
                }
                return color;
            }
            case LOGGING: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(13);
                }
                return color;
            }
            case OUTPUT: {
                Ansi.Color color = Ansi.Color.BLUE;
                if (color == null) {
                    PlainTextMessageRenderer.$$$reportNull$$$0(14);
                }
                return color;
            }
        }
        throw new UnsupportedOperationException("Unknown severity: " + (Object)((Object)severity));
    }

    @Nullable
    protected abstract String getPath(@NotNull CompilerMessageLocation var1);

    @Override
    public String renderConclusion() {
        return "";
    }

    static {
        boolean colorEnabled = false;
        if (!SystemInfo.isWindows && !"false".equals(System.getProperty("kotlin.colors.enabled"))) {
            try {
                colorEnabled = CLibrary.isatty(CLibrary.STDERR_FILENO) != 0;
            }
            catch (UnsatisfiedLinkError e) {
                colorEnabled = false;
            }
        }
        COLOR_ENABLED = colorEnabled;
        LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
        IMPORTANT_MESSAGE_SEVERITIES = EnumSet.of(CompilerMessageSeverity.EXCEPTION, CompilerMessageSeverity.ERROR, CompilerMessageSeverity.STRONG_WARNING, CompilerMessageSeverity.WARNING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/PlainTextMessageRenderer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalizeIfNeeded";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "severityColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "decapitalizeIfNeeded";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "severityColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

