/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.ArrayListMultimap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.KeyWithSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class SlicedMapImpl
implements MutableSlicedMap {
    private final Map<Object, KeyFMap> map = new THashMap<Object, KeyFMap>(0);
    private Multimap<WritableSlice<?, ?>, Object> collectiveSliceKeys = null;

    public static SlicedMapImpl create() {
        return new SlicedMapImpl();
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        Object oldValue;
        if (!slice.check(key, value)) {
            return;
        }
        KeyFMap holder = this.map.get(key);
        if (holder == null) {
            holder = KeyFMap.EMPTY_MAP;
        }
        KeyWithSlice<K, V, WritableSlice<K, V>> sliceKey = slice.getKey();
        RewritePolicy rewritePolicy = slice.getRewritePolicy();
        if (rewritePolicy.rewriteProcessingNeeded(key) && (oldValue = holder.get(sliceKey)) != null && !rewritePolicy.processRewrite(slice, key, oldValue, value)) {
            return;
        }
        if (slice.isCollective()) {
            if (this.collectiveSliceKeys == null) {
                this.collectiveSliceKeys = ArrayListMultimap.create();
            }
            this.collectiveSliceKeys.put(slice, key);
        }
        this.map.put(key, holder.plus(sliceKey, value));
        slice.afterPut(this, key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.collectiveSliceKeys = null;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        KeyFMap holder = this.map.get(key);
        Object value = holder == null ? null : (Object)holder.get(slice.getKey());
        return slice.computeValue(this, key, value, value == null);
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        assert (slice.isCollective()) : "Keys are not collected for slice " + slice;
        if (this.collectiveSliceKeys == null) {
            return Collections.emptyList();
        }
        return this.collectiveSliceKeys.get(slice);
    }

    @Override
    public void forEach(@NotNull Function3<WritableSlice, Object, Object, Void> f) {
        if (f == null) {
            SlicedMapImpl.$$$reportNull$$$0(0);
        }
        for (Map.Entry<Object, KeyFMap> entry : this.map.entrySet()) {
            Object key = entry.getKey();
            KeyFMap holder = entry.getValue();
            if (holder == null) continue;
            for (Key sliceKey : holder.getKeys()) {
                Object value = holder.get(sliceKey);
                f.invoke((WritableSlice)((AbstractWritableSlice)sliceKey).getSlice(), key, value);
            }
        }
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (slice == null) {
            SlicedMapImpl.$$$reportNull$$$0(1);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Object, KeyFMap> entry : this.map.entrySet()) {
            KeyFMap holder = entry.getValue();
            Object value = holder.get(slice.getKey());
            if (value == null) continue;
            builder.put(entry.getKey(), value);
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            SlicedMapImpl.$$$reportNull$$$0(2);
        }
        return immutableMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/util/slicedMap/SlicedMapImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSliceContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSliceContents";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

