/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.util;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;

public final class AstUtil {
    private AstUtil() {
    }

    public static JsBinaryOperation newSequence(JsExpression ... exprs) {
        if (exprs.length < 2) {
            throw new RuntimeException("newSequence expects at least two arguments");
        }
        JsExpression result2 = exprs[exprs.length - 1];
        for (int i = exprs.length - 2; i >= 0; --i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, exprs[i], result2);
        }
        return (JsBinaryOperation)result2;
    }

    @Nullable
    public static <T extends JsNode> T deepCopy(@Nullable T node) {
        if (node == null) {
            return null;
        }
        return (T)node.deepCopy();
    }

    @NotNull
    public static <T extends JsNode> List<T> deepCopy(@Nullable List<T> nodes) {
        if (nodes == null) {
            SmartList smartList = new SmartList();
            if (smartList == null) {
                AstUtil.$$$reportNull$$$0(0);
            }
            return smartList;
        }
        ArrayList<JsNode> nodesCopy = new ArrayList<JsNode>(nodes.size());
        for (JsNode node : nodes) {
            nodesCopy.add(AstUtil.deepCopy(node));
        }
        ArrayList<JsNode> arrayList = nodesCopy;
        if (arrayList == null) {
            AstUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/util/AstUtil", "deepCopy"));
    }
}

