/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.test;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.JetTestFunctionDetector;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.test.JSTester;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class JSTestGenerator {
    private JSTestGenerator() {
    }

    public static void generateTestCalls(@NotNull TranslationContext context, @NotNull Collection<KtFile> files2, @NotNull JSTester tester) {
        if (context == null) {
            JSTestGenerator.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            JSTestGenerator.$$$reportNull$$$0(1);
        }
        if (tester == null) {
            JSTestGenerator.$$$reportNull$$$0(2);
        }
        List<FunctionDescriptor> functionDescriptors2 = JetTestFunctionDetector.getTestFunctionDescriptors(context.bindingContext(), files2);
        JSTestGenerator.doGenerateTestCalls(functionDescriptors2, context, tester);
    }

    private static void doGenerateTestCalls(@NotNull List<FunctionDescriptor> functionDescriptors2, @NotNull TranslationContext context, @NotNull JSTester jsTester) {
        if (functionDescriptors2 == null) {
            JSTestGenerator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JSTestGenerator.$$$reportNull$$$0(4);
        }
        if (jsTester == null) {
            JSTestGenerator.$$$reportNull$$$0(5);
        }
        for (FunctionDescriptor functionDescriptor : functionDescriptors2) {
            ClassDescriptor classDescriptor = DescriptorUtils.getContainingClass(functionDescriptor);
            if (classDescriptor == null) {
                return;
            }
            JSTestGenerator.generateCodeForTestMethod(context, functionDescriptor, classDescriptor, jsTester);
        }
    }

    private static void generateCodeForTestMethod(@NotNull TranslationContext context, @NotNull FunctionDescriptor functionDescriptor, @NotNull ClassDescriptor classDescriptor, @NotNull JSTester tester) {
        if (context == null) {
            JSTestGenerator.$$$reportNull$$$0(6);
        }
        if (functionDescriptor == null) {
            JSTestGenerator.$$$reportNull$$$0(7);
        }
        if (classDescriptor == null) {
            JSTestGenerator.$$$reportNull$$$0(8);
        }
        if (tester == null) {
            JSTestGenerator.$$$reportNull$$$0(9);
        }
        JsExpression expression = ReferenceTranslator.translateAsValueReference(classDescriptor, context);
        JsNew testClass = new JsNew(expression);
        JsExpression functionToTestCall = CallTranslator.INSTANCE.buildCall(context, functionDescriptor, Collections.emptyList(), testClass);
        JsStringLiteral testName = context.program().getStringLiteral(classDescriptor.getName() + "." + functionDescriptor.getName());
        tester.constructTestMethodInvocation(functionToTestCall, testName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tester";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsTester";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/translate/test/JSTestGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTestCalls";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doGenerateTestCalls";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "generateCodeForTestMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

