/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;

public class JetTestFunctionDetector {
    private JetTestFunctionDetector() {
    }

    private static boolean isTest(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(0);
        }
        Annotations annotations2 = functionDescriptor.getAnnotations();
        for (AnnotationDescriptor annotation2 : annotations2) {
            KotlinType type2 = annotation2.getType();
            String name = type2.toString();
            if (!name.equals("Test")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<FunctionDescriptor> getTestFunctionDescriptors(@NotNull BindingContext bindingContext, @NotNull Collection<KtFile> files2) {
        if (bindingContext == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(2);
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (KtFile file2 : files2) {
            answer.addAll(JetTestFunctionDetector.getTestFunctions(bindingContext, file2.getDeclarations()));
        }
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static List<FunctionDescriptor> getTestFunctions(@NotNull BindingContext bindingContext, @NotNull List<KtDeclaration> declarations) {
        if (bindingContext == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(4);
        }
        if (declarations == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(5);
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (KtDeclaration declaration : declarations) {
            KtClass klass2;
            ClassDescriptor classDescriptor;
            MemberScope scope = null;
            if (declaration instanceof KtClass && (classDescriptor = BindingUtils.getClassDescriptor(bindingContext, klass2 = (KtClass)declaration)).getModality() != Modality.ABSTRACT) {
                scope = classDescriptor.getDefaultType().getMemberScope();
            }
            if (scope == null) continue;
            Collection<DeclarationDescriptor> allDescriptors2 = DescriptorUtils.getAllDescriptors(scope);
            List<FunctionDescriptor> testFunctions = ContainerUtil.mapNotNull(allDescriptors2, new Function<DeclarationDescriptor, FunctionDescriptor>(){

                @Override
                public FunctionDescriptor fun(DeclarationDescriptor descriptor2) {
                    FunctionDescriptor functionDescriptor;
                    if (descriptor2 instanceof FunctionDescriptor && JetTestFunctionDetector.isTest(functionDescriptor = (FunctionDescriptor)descriptor2)) {
                        return functionDescriptor;
                    }
                    return null;
                }
            });
            answer.addAll(testFunctions);
        }
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            JetTestFunctionDetector.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFunctionDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunctionDescriptors";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestFunctions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

