/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nJ\f\u0010\u001f\u001a\u00020\u000b*\u00020\nH\u0002R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;", "", "parent", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "(Lorg/jetbrains/kotlin/js/translate/context/UsageTracker;Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;Lorg/jetbrains/kotlin/js/backend/ast/JsScope;)V", "captured", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lkotlin/collections/LinkedHashMap;", "capturedDescriptorToJsName", "", "getCapturedDescriptorToJsName", "()Ljava/util/Map;", "capturedDescriptors", "", "getCapturedDescriptors", "()Ljava/util/Set;", "getContainingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "captureIfNeed", "", "descriptor", "isInLocalDeclaration", "", "isReceiverAncestor", "isSingletonReceiver", "used", "getJsNameForCapturedDescriptor", "kotlin-compiler"})
public final class UsageTracker {
    private final LinkedHashMap<DeclarationDescriptor, JsName> captured;
    private final UsageTracker parent;
    @NotNull
    private final MemberDescriptor containingDescriptor;
    private final JsScope scope;

    @NotNull
    public final Map<DeclarationDescriptor, JsName> getCapturedDescriptorToJsName() {
        return this.captured;
    }

    @NotNull
    public final Set<DeclarationDescriptor> getCapturedDescriptors() {
        Set<DeclarationDescriptor> set = this.captured.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "captured.keys");
        return set;
    }

    public final void used(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (UsageTrackerKt.isCaptured(this, descriptor2)) {
            return;
        }
        if (descriptor2 instanceof FakeCallableDescriptorForObject) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), Visibilities.LOCAL)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor)) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof ReceiverParameterDescriptor) {
            this.captureIfNeed(descriptor2);
        } else if (descriptor2 instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)descriptor2).isReified()) {
            this.captureIfNeed(descriptor2);
        }
    }

    private final void captureIfNeed(DeclarationDescriptor descriptor2) {
        if (descriptor2 == null || UsageTrackerKt.isCaptured(this, descriptor2) || !this.isInLocalDeclaration() || DescriptorUtils.isAncestor(this.containingDescriptor, descriptor2, true) || this.isReceiverAncestor(descriptor2) || this.isSingletonReceiver(descriptor2)) {
            return;
        }
        if (DescriptorUtilsKt.isCoroutineLambda(descriptor2) && Intrinsics.areEqual(descriptor2, this.containingDescriptor)) {
            return;
        }
        UsageTracker usageTracker = this.parent;
        if (usageTracker != null) {
            usageTracker.captureIfNeed(descriptor2);
        }
        Map map2 = this.captured;
        JsName jsName = this.getJsNameForCapturedDescriptor(descriptor2);
        map2.put(descriptor2, jsName);
    }

    private final boolean isInLocalDeclaration() {
        MemberDescriptor memberDescriptor;
        MemberDescriptor container2 = this.containingDescriptor;
        if (container2 instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)container2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classifierDescriptorWithTypeParameters, "container.containingDeclaration");
            memberDescriptor = classifierDescriptorWithTypeParameters;
        } else {
            memberDescriptor = container2;
        }
        return DescriptorUtils.isDescriptorWithLocalVisibility(memberDescriptor);
    }

    private final boolean isReceiverAncestor(DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        if (!(this.containingDescriptor instanceof ClassDescriptor) && !(this.containingDescriptor instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor classDescriptor = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        DeclarationDescriptor declarationDescriptor = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor currentClass = classDescriptor2;
        Iterator<ClassDescriptor> iterator2 = SequencesKt.generateSequence(containingClass, (Function1)isReceiverAncestor.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            ClassDescriptor outerDeclaration = iterator2.next();
            if (!Intrinsics.areEqual(outerDeclaration, currentClass)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSingletonReceiver(DeclarationDescriptor descriptor2) {
        ClassDescriptor containingClass;
        if (!(descriptor2 instanceof ReceiverParameterDescriptor)) {
            return false;
        }
        DeclarationDescriptor container2 = ((ReceiverParameterDescriptor)descriptor2).getContainingDeclaration();
        if (!DescriptorUtils.isObject(container2)) {
            return false;
        }
        return this.containingDescriptor instanceof ClassDescriptor || !Intrinsics.areEqual(containingClass = DescriptorUtils.getParentOfType(this.containingDescriptor, ClassDescriptor.class, false), container2);
    }

    private final JsName getJsNameForCapturedDescriptor(@NotNull DeclarationDescriptor $receiver) {
        String string;
        Object object = $receiver;
        if (object instanceof ReceiverParameterDescriptor) {
            string = UsageTrackerKt.access$getNameForCapturedReceiver((ReceiverParameterDescriptor)$receiver);
        } else if (object instanceof TypeParameterDescriptor) {
            String string2 = Namer.isInstanceSuggestedName((TypeParameterDescriptor)$receiver);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "Namer.isInstanceSuggestedName(this)");
        } else {
            SuggestedName suggestedName = new NameSuggestion().suggest($receiver);
            if (suggestedName == null) {
                Intrinsics.throwNpe();
            }
            String mangled = NameSuggestion.Companion.sanitizeName(CollectionsKt.last(suggestedName.getNames()));
            string = "closure" + "$" + mangled;
        }
        String suggestedName = string;
        Object $receiver2 = object = this.scope.declareTemporaryName(suggestedName);
        MetadataProperties.setDescriptor((JsName)$receiver2, $receiver);
        Object object2 = object;
        Intrinsics.checkExpressionValueIsNotNull(object2, "scope.declareTemporaryNa\u2026meForCapturedDescriptor }");
        return object2;
    }

    @NotNull
    public final MemberDescriptor getContainingDescriptor() {
        return this.containingDescriptor;
    }

    public UsageTracker(@Nullable UsageTracker parent2, @NotNull MemberDescriptor containingDescriptor, @NotNull JsScope scope) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.parent = parent2;
        this.containingDescriptor = containingDescriptor;
        this.scope = scope;
        UsageTracker usageTracker = this;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        usageTracker.captured = linkedHashMap;
    }
}

