/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public class WalkingState<T> {
    private boolean isDown;
    protected boolean startedWalking;
    private final TreeGuide<T> myWalker;
    private boolean stopped;

    public void elementFinished(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "elementFinished"));
        }
    }

    public WalkingState(@NotNull TreeGuide<T> delegate2) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "<init>"));
        }
        this.myWalker = delegate2;
    }

    public void visit(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "visit"));
        }
        this.elementStarted(element);
    }

    public void elementStarted(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "elementStarted"));
        }
        this.isDown = true;
        if (!this.startedWalking) {
            this.stopped = false;
            this.startedWalking = true;
            try {
                this.walkChildren(element);
            }
            finally {
                this.startedWalking = false;
            }
        }
    }

    private void walkChildren(@NotNull T root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "walkChildren"));
        }
        T element = this.next(root, root, this.isDown);
        while (element != null && !this.stopped) {
            this.isDown = false;
            T parent2 = this.myWalker.getParent(element);
            T next = this.myWalker.getNextSibling(element);
            this.visit(element);
            assert (this.myWalker.getNextSibling(element) == next) : "Next sibling of the element '" + element + "' changed. Was: " + next + "; Now:" + this.myWalker.getNextSibling(element) + "; Root:" + root;
            assert (this.myWalker.getParent(element) == parent2) : "Parent of the element '" + element + "' changed. Was: " + parent2 + "; Now:" + this.myWalker.getParent(element) + "; Root:" + root;
            element = this.next(element, root, this.isDown);
        }
    }

    public T next(T element, @NotNull T root, boolean isDown) {
        T child;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "next"));
        }
        if (isDown && (child = this.myWalker.getFirstChild(element)) != null) {
            return child;
        }
        while (element != root && element != null) {
            T next = this.myWalker.getNextSibling(element);
            this.elementFinished(element);
            if (next != null) {
                T nextPrev = this.myWalker.getPrevSibling(next);
                if (nextPrev != element) {
                    T top;
                    String msg = "Element: " + element + "; next: " + next + "; next.prev: " + nextPrev;
                    while ((top = this.myWalker.getParent(element)) != null && top != root) {
                        element = top;
                    }
                    assert (false) : msg + " Top:" + element;
                }
                return next;
            }
            element = this.myWalker.getParent(element);
        }
        if (element != null) {
            this.elementFinished(element);
        }
        return null;
    }

    public void startedWalking() {
        this.startedWalking = true;
    }

    public void stopWalking() {
        this.stopped = true;
    }

    public static <T> boolean processAll(@NotNull T root, @NotNull TreeGuide<T> treeGuide, final @NotNull Processor<T> processor) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "processAll"));
        }
        if (treeGuide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeGuide", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "processAll"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/util/WalkingState", "processAll"));
        }
        final boolean[] result2 = new boolean[]{true};
        new WalkingState<T>(treeGuide){

            @Override
            public void visit(@NotNull T element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/WalkingState$1", "visit"));
                }
                if (!processor.process(element)) {
                    this.stopWalking();
                    result2[0] = false;
                } else {
                    super.visit(element);
                }
            }
        }.visit(root);
        return result2[0];
    }

    public static interface TreeGuide<T> {
        public T getNextSibling(@NotNull T var1);

        public T getPrevSibling(@NotNull T var1);

        public T getFirstChild(@NotNull T var1);

        public T getParent(@NotNull T var1);
    }
}

