/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.icons.AllIcons;
import org.jetbrains.kotlin.com.intellij.ide.IconLayerProvider;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.INativeFileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.UnknownFileType;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Iconable;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.ui.IconDeferrer;
import org.jetbrains.kotlin.com.intellij.ui.LayeredIcon;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.IconUtil;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.util.PsiIconUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.EmptyIcon;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.ElementBase");
    public static final int FLAGS_LOCKED = 2048;
    private static final NullableFunction<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        Iconable.LastComputedIcon.put(element, icon, ((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            EmptyIcon emptyIcon = EmptyIcon.create(PlatformIcons.PUBLIC_ICON);
            if (emptyIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase$1", "compute"));
            }
            return emptyIcon;
        }
    };
    public static final NotNullLazyValue<Icon> ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @Override
        @NotNull
        protected Icon compute() {
            Icon icon = AllIcons.Nodes.NodePlaceholder;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase$2", "compute"));
            }
            return icon;
        }
    };
    private static final List<IconLayer> ourIconLayers = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading")) {
            Icon baseIcon = Iconable.LastComputedIcon.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = this.computeBaseIcon(flags);
            }
            return IconDeferrer.getInstance().defer(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "computeIconNow"));
        }
        Icon providersIcon = PsiIconUtil.getProvidersIcon(element, flags);
        if (providersIcon != null) {
            return providersIcon instanceof RowIcon ? (RowIcon)providersIcon : ElementBase.createLayeredIcon(element, providersIcon, flags);
        }
        return ((ElementBase)((Object)element)).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(int flags) {
        return this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
    }

    protected Icon getBaseIcon() {
        PsiFile file2;
        if (this instanceof PsiElement && (file2 = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file2.getFileType())) {
            return file2.getFileType().getIcon();
        }
        return ICON_PLACEHOLDER.getValue();
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon, int flags) {
        if (BitUtil.isSet(flags, 1)) {
            return new RowIcon(icon, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static Icon overlayIcons(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "overlayIcons"));
        }
        LayeredIcon icon = new LayeredIcon(icons.length);
        int i = 0;
        for (Icon ic : icons) {
            icon.setIcon(ic, i++);
        }
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "overlayIcons"));
        }
        return layeredIcon;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon icon = new RowIcon(2);
        icon.setIcon(baseIcon, 0);
        icon.setIcon(visibilityIcon, 1);
        RowIcon rowIcon = icon;
        if (rowIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "buildRowIcon"));
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(int flags) {
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (!(element instanceof ItemPresentation) || ((ItemPresentation)((Object)element)).getIcon(false) == null) {
            if (element instanceof PsiFile) {
                PsiFile file2 = (PsiFile)element;
                VirtualFile virtualFile = file2.getVirtualFile();
                Icon fileTypeIcon = virtualFile == null ? file2.getFileType().getIcon() : IconUtil.getIcon(virtualFile, flags & 0xFFFFFFFD, file2.getProject());
                return ElementBase.createLayeredIcon(this, fileTypeIcon, elementFlags);
            }
            return null;
        }
        RowIcon baseIcon = ElementBase.createLayeredIcon(this, ((ItemPresentation)((Object)element)).getIcon(false), elementFlags);
        return baseIcon;
    }

    @NotNull
    public static RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon, int flags) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "createLayeredIcon"));
        }
        SmartList<Icon> layersFromProviders = new SmartList<Icon>();
        for (IconLayerProvider provider : Extensions.getExtensions(IconLayerProvider.EP_NAME)) {
            Icon layerIcon = provider.getLayerIcon(instance, BitUtil.isSet(flags, 2048));
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            SmartList<Icon> iconLayers = new SmartList<Icon>();
            for (IconLayer l : ourIconLayers) {
                if (!BitUtil.isSet(flags, l.flagMask)) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon = layeredIcon;
        }
        RowIcon baseIcon = new RowIcon(2);
        baseIcon.setIcon(icon, 0);
        RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "createLayeredIcon"));
        }
        return rowIcon;
    }

    public static int transformFlags(PsiElement element, int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    public static void registerIconLayer(int flagMask, @NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase", "registerIconLayer"));
        }
        for (IconLayer iconLayer : ourIconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        ourIconLayers.add(new IconLayer(flagMask, icon));
    }

    private static class IconLayer {
        private final int flagMask;
        @NotNull
        private final Icon icon;

        private IconLayer(int flagMask, @NotNull Icon icon) {
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase$IconLayer", "<init>"));
            }
            BitUtil.assertOneBitMask(flagMask);
            this.flagMask = flagMask;
            this.icon = icon;
        }
    }

    private static class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, int flags) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase$ElementIconRequest", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase$ElementIconRequest", "<init>"));
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result2 = this.myPointer.hashCode();
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }
    }
}

