/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import java.util.Collection;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Predicate;
import org.jetbrains.kotlin.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

public class FileBasedDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    private final StorageManager storageManager;
    private final NotNullLazyValue<Index> index;

    public FileBasedDeclarationProviderFactory(@NotNull StorageManager storageManager, final @NotNull Collection<KtFile> files2) {
        if (storageManager == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(1);
        }
        super(storageManager);
        this.storageManager = storageManager;
        this.index = storageManager.createLazyValue(new Function0<Index>(){

            @Override
            public Index invoke() {
                return FileBasedDeclarationProviderFactory.computeFilesByPackage(files2);
            }
        });
    }

    @NotNull
    private static Index computeFilesByPackage(@NotNull Collection<KtFile> files2) {
        if (files2 == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(2);
        }
        Index index2 = new Index();
        for (KtFile file2 : files2) {
            FqName packageFqName = file2.getPackageFqName();
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, packageFqName);
            index2.filesByPackage.put(packageFqName, file2);
        }
        Index index3 = index2;
        if (index3 == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(3);
        }
        return index3;
    }

    private static void addMeAndParentPackages(@NotNull Index index2, @NotNull FqName name) {
        if (index2 == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(4);
        }
        if (name == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(5);
        }
        index2.declaredPackages.add(name);
        if (!name.isRoot()) {
            FileBasedDeclarationProviderFactory.addMeAndParentPackages(index2, name.parent());
        }
    }

    boolean isPackageDeclaredExplicitly(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(6);
        }
        return ((Index)this.index.invoke()).declaredPackages.contains(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(final @NotNull FqName parent2) {
        if (parent2 == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(7);
        }
        return Collections2.filter(((Index)this.index.invoke()).declaredPackages, new Predicate<FqName>(){

            @Override
            public boolean apply(FqName fqName2) {
                return !fqName2.isRoot() && fqName2.parent().equals(parent2);
            }
        });
    }

    @Override
    @Nullable
    protected PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(8);
        }
        if (this.isPackageDeclaredExplicitly(packageFqName)) {
            return new FileBasedPackageMemberDeclarationProvider(this.storageManager, packageFqName, this, ((Index)this.index.invoke()).filesByPackage.get(packageFqName));
        }
        return null;
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        if (classLikeInfo == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(9);
        }
        if (!((Index)this.index.invoke()).filesByPackage.containsKey(classLikeInfo.getContainingPackageFqName())) {
            throw new IllegalStateException("This factory doesn't know about this class: " + classLikeInfo);
        }
        PsiBasedClassMemberDeclarationProvider psiBasedClassMemberDeclarationProvider = new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
        if (psiBasedClassMemberDeclarationProvider == null) {
            FileBasedDeclarationProviderFactory.$$$reportNull$$$0(10);
        }
        return psiBasedClassMemberDeclarationProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLikeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFilesByPackage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMemberDeclarationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeFilesByPackage";
                break;
            }
            case 3: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMeAndParentPackages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDeclaredExplicitly";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllDeclaredSubPackagesOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPackageMemberDeclarationProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassMemberDeclarationProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Index {
        private final Multimap<FqName, KtFile> filesByPackage = LinkedHashMultimap.create();
        private final Set<FqName> declaredPackages = Sets.newHashSet();

        private Index() {
        }
    }
}

