/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Predicate;
import org.jetbrains.kotlin.com.google.common.base.Predicates;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public class ResolveSessionUtils {
    private ResolveSessionUtils() {
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        if (module == null) {
            ResolveSessionUtils.$$$reportNull$$$0(0);
        }
        if (fqName2 == null) {
            ResolveSessionUtils.$$$reportNull$$$0(1);
        }
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(module, fqName2, Predicates.alwaysTrue());
        if (collection == null) {
            ResolveSessionUtils.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2, @NotNull Predicate<ClassDescriptor> filter2) {
        if (module == null) {
            ResolveSessionUtils.$$$reportNull$$$0(3);
        }
        if (fqName2 == null) {
            ResolveSessionUtils.$$$reportNull$$$0(4);
        }
        if (filter2 == null) {
            ResolveSessionUtils.$$$reportNull$$$0(5);
        }
        if (fqName2.isRoot()) {
            List<ClassDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                ResolveSessionUtils.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>(1);
        FqName packageFqName = fqName2.parent();
        while (true) {
            PackageViewDescriptor packageDescriptor;
            if (!(packageDescriptor = module.getPackage(packageFqName)).isEmpty()) {
                FqName relativeClassFqName = FqNamesUtilKt.tail(fqName2, packageFqName);
                ClassDescriptor classDescriptor = ResolveSessionUtils.findClassByRelativePath(packageDescriptor.getMemberScope(), relativeClassFqName);
                if (classDescriptor != null && filter2.apply(classDescriptor)) {
                    result2.add(classDescriptor);
                }
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        ArrayList<ClassDescriptor> arrayList = result2;
        if (arrayList == null) {
            ResolveSessionUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static ClassDescriptor findClassByRelativePath(@NotNull MemberScope packageScope, @NotNull FqName path) {
        if (packageScope == null) {
            ResolveSessionUtils.$$$reportNull$$$0(8);
        }
        if (path == null) {
            ResolveSessionUtils.$$$reportNull$$$0(9);
        }
        if (path.isRoot()) {
            return null;
        }
        MemberScope scope = packageScope;
        ClassifierDescriptor classifier2 = null;
        for (Name name : path.pathSegments()) {
            classifier2 = scope.getContributedClassifier(name, NoLookupLocation.WHEN_FIND_BY_FQNAME);
            if (!(classifier2 instanceof ClassDescriptor)) {
                return null;
            }
            scope = ((ClassDescriptor)classifier2).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)classifier2;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@NotNull KtNamedDeclaration declaration) {
        if (declaration == null) {
            ResolveSessionUtils.$$$reportNull$$$0(10);
        }
        Name name = ResolveSessionUtils.safeNameForLazyResolve(declaration.getNameAsName());
        if (name == null) {
            ResolveSessionUtils.$$$reportNull$$$0(11);
        }
        return name;
    }

    @NotNull
    public static Name safeNameForLazyResolve(@Nullable Name name) {
        Name name2 = SpecialNames.safeIdentifier(name);
        if (name2 == null) {
            ResolveSessionUtils.$$$reportNull$$$0(12);
        }
        return name2;
    }

    @Nullable
    public static FqName safeFqNameForLazyResolve(@NotNull KtNamedDeclaration declaration) {
        FqName parentFqName;
        if (declaration == null) {
            ResolveSessionUtils.$$$reportNull$$$0(13);
        }
        return (parentFqName = KtNamedDeclarationUtil.getParentFqName(declaration)) != null ? parentFqName.child(ResolveSessionUtils.safeNameForLazyResolve(declaration)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageScope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/ResolveSessionUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptorsByFqName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassOrObjectDescriptorsByFqName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "safeNameForLazyResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorsByFqName";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassOrObjectDescriptorsByFqName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClassByRelativePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "safeNameForLazyResolve";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "safeFqNameForLazyResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

