/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\u00a8\u0006\u0015"}, d2={"DEFINE_MODULE_FIND_PATTERN", "", "DEFINE_MODULE_PATTERN", "Ljava/util/regex/Pattern;", "JS_IDENTIFIER", "JS_IDENTIFIER_PART", "JS_IDENTIFIER_START", "isWhitespaceOrComma", "", "", "(C)Z", "replaceExternalNames", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "externalReplacements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "markInlineArguments", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlin-compiler"})
public final class FunctionReaderKt {
    private static final String JS_IDENTIFIER_START = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\$_";
    private static final String JS_IDENTIFIER_PART = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\$_\\p{Pc}\\p{Mc}\\p{Mn}\\d";
    private static final String JS_IDENTIFIER = "[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\$_][\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\$_\\p{Pc}\\p{Mc}\\p{Mn}\\d]*";
    private static final Pattern DEFINE_MODULE_PATTERN;
    private static final String DEFINE_MODULE_FIND_PATTERN = ".defineModule(";

    private static final boolean isWhitespaceOrComma(char $receiver) {
        return $receiver == ',' || CharsKt.isWhitespace($receiver);
    }

    private static final void markInlineArguments(@NotNull JsFunction $receiver, CallableDescriptor descriptor2) {
        List<ValueParameterDescriptor> params = descriptor2.getValueParameters();
        List<JsParameter> paramsJs = $receiver.getParameters();
        Set inlineFuns = CollectionUtilsKt.IdentitySet();
        int offset2 = DescriptorUtilsKt.isExtension(descriptor2) ? 1 : 0;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)params)) {
            KotlinType type2;
            int i = indexedValue.component1();
            ValueParameterDescriptor param = (ValueParameterDescriptor)indexedValue.component2();
            if (!CallExpressionTranslator.shouldBeInlined(descriptor2) || !FunctionTypesKt.isFunctionTypeOrSubtype(type2 = param.getType())) continue;
            JsName jsName = paramsJs.get(i + offset2).getName();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramsJs[i + offset].name");
            inlineFuns.add(jsName);
        }
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(inlineFuns){
            final /* synthetic */ Set $inlineFuns;

            public void endVisit(@NotNull JsInvocation x, @NotNull JsContext<?> ctx) {
                block4: {
                    HasMetadata hasMetadata;
                    HasMetadata name;
                    HasMetadata hasMetadata2;
                    JsExpression jsExpression;
                    JsExpression qualifier;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    if (InvocationUtilsKt.isCallInvocation(x)) {
                        JsExpression jsExpression2 = x.getQualifier();
                        if (!(jsExpression2 instanceof JsNameRef)) {
                            jsExpression2 = null;
                        }
                        JsNameRef jsNameRef = (JsNameRef)jsExpression2;
                        qualifier = jsNameRef != null ? jsNameRef.getQualifier() : null;
                    } else {
                        qualifier = x.getQualifier();
                    }
                    if (!((jsExpression = qualifier) instanceof JsNameRef)) {
                        jsExpression = null;
                    }
                    if ((hasMetadata2 = (JsNameRef)jsExpression) == null || (hasMetadata2 = hasMetadata2.getName()) == null || !this.$inlineFuns.contains(name = (hasMetadata = hasMetadata2))) break block4;
                    MetadataProperties.setInlineStrategy(x, InlineStrategy.IN_PLACE);
                }
            }
            {
                this.$inlineFuns = $captured_local_variable$0;
            }
        };
        visitor2.accept((JsNode)$receiver);
    }

    private static final void replaceExternalNames(JsFunction function2, Map<String, ? extends JsExpression> externalReplacements) {
        Map<String, ? extends JsExpression> $receiver$iv = externalReplacements;
        LinkedHashMap<String, JsExpression> result$iv = new LinkedHashMap<String, JsExpression>();
        Map<String, ? extends JsExpression> map2 = $receiver$iv;
        for (Map.Entry<String, ? extends JsExpression> entry$iv : map2.entrySet()) {
            String it = entry$iv.getKey();
            if (!(!function2.getScope().hasOwnName(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map replacements = result$iv;
        if (replacements.isEmpty()) {
            return;
        }
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(replacements){
            final /* synthetic */ Map $replacements;

            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
                block1: {
                    JsExpression jsExpression;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    if (x.getQualifier() != null) {
                        return;
                    }
                    JsExpression jsExpression2 = (JsExpression)this.$replacements.get(x.getIdent());
                    if (jsExpression2 == null) break block1;
                    JsExpression it = jsExpression = jsExpression2;
                    ctx.replaceMe((JsNode)it);
                }
            }
            {
                this.$replacements = $captured_local_variable$0;
            }
        };
        visitor2.accept((JsNode)function2);
    }

    static {
        JS_IDENTIFIER_START = JS_IDENTIFIER_START;
        JS_IDENTIFIER_PART = JS_IDENTIFIER_START + "\\" + "p{Pc}" + "\\" + "p{Mc}" + "\\" + "p{Mn}" + "\\" + "d";
        JS_IDENTIFIER = "[" + JS_IDENTIFIER_START + "][" + JS_IDENTIFIER_PART + "]*";
        String string = "(" + JS_IDENTIFIER + ")" + "\\" + ".defineModule" + "\\" + "(" + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]+)" + "\\" + "2" + "\\" + "s*," + "\\" + "s*(" + "\\" + "w+)" + "\\" + "s*" + "\\" + ")";
        DEFINE_MODULE_PATTERN = new Regex(string).toPattern();
        DEFINE_MODULE_FIND_PATTERN = DEFINE_MODULE_FIND_PATTERN;
    }

    public static final /* synthetic */ boolean access$isWhitespaceOrComma$p(char $receiver) {
        return FunctionReaderKt.isWhitespaceOrComma($receiver);
    }

    public static final /* synthetic */ void access$replaceExternalNames(@NotNull JsFunction function2, @NotNull Map externalReplacements) {
        FunctionReaderKt.replaceExternalNames(function2, externalReplacements);
    }

    public static final /* synthetic */ void access$markInlineArguments(@NotNull JsFunction $receiver, @NotNull CallableDescriptor descriptor2) {
        FunctionReaderKt.markInlineArguments($receiver, descriptor2);
    }

    @NotNull
    public static final /* synthetic */ String access$getDEFINE_MODULE_FIND_PATTERN$p() {
        return DEFINE_MODULE_FIND_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ Pattern access$getDEFINE_MODULE_PATTERN$p() {
        return DEFINE_MODULE_PATTERN;
    }
}

