/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangedJavaFilesProcessor;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.LookupSymbol;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "(Lorg/jetbrains/kotlin/incremental/ICReporter;)V", "allChangedSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "getAllChangedSymbols", "()Ljava/util/Collection;", "allSymbols", "Ljava/util/HashSet;", "javaLang", "Lorg/jetbrains/kotlin/com/intellij/lang/java/JavaLanguage;", "Lorg/jetbrains/annotations/NotNull;", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "getPsiFileFactory", "()Lcom/intellij/psi/PsiFileFactory;", "psiFileFactory$delegate", "Lkotlin/Lazy;", "process", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "filesDiff", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "addLookupSymbols", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "symbols", "", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "Ljava/io/File;", "kotlin-compiler"})
public final class ChangedJavaFilesProcessor {
    private final HashSet<LookupSymbol> allSymbols;
    private final JavaLanguage javaLang;
    private final Lazy psiFileFactory$delegate;
    private final ICReporter reporter;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final PsiFileFactory getPsiFileFactory() {
        Lazy lazy = this.psiFileFactory$delegate;
        ChangedJavaFilesProcessor changedJavaFilesProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (PsiFileFactory)lazy.getValue();
    }

    @NotNull
    public final Collection<LookupSymbol> getAllChangedSymbols() {
        return this.allSymbols;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesEither process(@NotNull ChangedFiles.Known filesDiff) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(filesDiff, "filesDiff");
        Iterable iterable = $receiver$iv = (Iterable)filesDiff.getModified();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            File p1 = (File)element$iv$iv;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modifiedJava = (List)destination$iv$iv;
        Iterable $receiver$iv2 = filesDiff.getRemoved();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            File p1 = (File)element$iv$iv2;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List removedJava = (List)destination$iv$iv2;
        if (CollectionsKt.any(removedJava)) {
            this.reporter.report(new Function0<String>(removedJava){
                final /* synthetic */ List $removedJava;

                @NotNull
                public final String invoke() {
                    return "Some java files are removed: [" + CollectionsKt.joinToString$default(this.$removedJava, null, null, null, 0, null, null, 63, null) + "]";
                }
                {
                    this.$removedJava = list2;
                    super(0);
                }
            });
            return new ChangesEither.Unknown();
        }
        HashSet symbols = new HashSet();
        for (File javaFile : modifiedJava) {
            boolean element$iv$iv = StringsKt.equals(FilesKt.getExtension(javaFile), "java", true);
            if (_Assertions.ENABLED && !element$iv$iv) {
                Object element$iv$iv2;
                element$iv$iv2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(element$iv$iv2));
            }
            PsiFile psiFile = this.psiFile(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                this.reporter.report(new Function0<String>(psiFile){
                    final /* synthetic */ PsiFile $psiFile;

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile = this.$psiFile;
                        return "Expected PsiJavaFile, got " + (psiFile != null ? psiFile.getClass() : null);
                    }
                    {
                        this.$psiFile = psiFile;
                        super(0);
                    }
                });
                return new ChangesEither.Unknown();
            }
            Object[] $receiver$iv3 = ((PsiJavaFile)psiFile).getClasses();
            for (int i = 0; i < $receiver$iv3.length; ++i) {
                Object element$iv = $receiver$iv3[i];
                PsiClass it = (PsiClass)element$iv;
                this.addLookupSymbols(it, symbols);
            }
        }
        this.allSymbols.addAll(symbols);
        return new ChangesEither.Known(symbols, null, 2, null);
    }

    private final void addLookupSymbols(@NotNull PsiClass $receiver, Set<LookupSymbol> symbols) {
        PsiNameIdentifierOwner it;
        Object element$iv;
        int n;
        String string;
        String string2;
        LookupSymbol lookupSymbol;
        String string3 = $receiver.getQualifiedName();
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        String fqn = string4;
        string3 = $receiver.getName();
        LookupSymbol lookupSymbol2 = lookupSymbol;
        LookupSymbol lookupSymbol3 = lookupSymbol;
        Set<LookupSymbol> set = symbols;
        String string5 = string3;
        if (string5 == null) {
            string5 = string2 = "";
        }
        if (Intrinsics.areEqual(fqn, $receiver.getName())) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(".");
            String string6 = $receiver.getName();
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.removeSuffix(fqn, (CharSequence)stringBuilder.append(string6).toString());
        }
        lookupSymbol2(string2, string);
        set.add(lookupSymbol3);
        Object[] $receiver$iv = $receiver.getMethods();
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (PsiMethod)element$iv;
            String string7 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull(string7, "it.name");
            symbols.add(new LookupSymbol(string7, fqn));
        }
        $receiver$iv = $receiver.getFields();
        for (n = 0; n < $receiver$iv.length; ++n) {
            LookupSymbol lookupSymbol4;
            element$iv = $receiver$iv[n];
            it = (PsiField)element$iv;
            String $i$a$1$forEach = it.getName();
            LookupSymbol $i$f$forEach = lookupSymbol4;
            LookupSymbol lookupSymbol5 = lookupSymbol4;
            Set<LookupSymbol> set2 = symbols;
            String string8 = $i$a$1$forEach;
            if (string8 == null) {
                string8 = "";
            }
            String string9 = string8;
            $i$f$forEach(string9, fqn);
            set2.add(lookupSymbol5);
        }
        $receiver$iv = $receiver.getInnerClasses();
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (PsiClass)element$iv;
            this.addLookupSymbols((PsiClass)it, symbols);
        }
    }

    private final PsiFile psiFile(@NotNull File $receiver) {
        return this.getPsiFileFactory().createFileFromText(FilesKt.getNameWithoutExtension($receiver), this.javaLang, (CharSequence)FilesKt.readText$default($receiver, null, 1, null));
    }

    public ChangedJavaFilesProcessor(@NotNull ICReporter reporter) {
        Intrinsics.checkParameterIsNotNull(reporter, "reporter");
        this.reporter = reporter;
        this.allSymbols = new HashSet();
        this.javaLang = JavaLanguage.INSTANCE;
        this.psiFileFactory$delegate = LazyKt.lazy(psiFileFactory.2.INSTANCE);
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(ChangedJavaFilesProcessor.class), "psiFileFactory", "getPsiFileFactory()Lcom/intellij/psi/PsiFileFactory;"))};
    }
}

