/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaLexer;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiSubstitutorImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightClassReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightClassReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightClassTypeReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightKeyword;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightPackageReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightPackageReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiExtensibleClass;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImmediateClassType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;

public class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory {
    private final NotNullLazyValue<PsiClass> myArrayClass = new AtomicNotNullLazyValue<PsiClass>(){

        @Override
        @NotNull
        protected PsiClass compute() {
            PsiClass psiClass = PsiElementFactoryImpl.this.createArrayClass("public class __Array__{\n public final int length;\n public Object clone() {}\n}", LanguageLevel.JDK_1_3);
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl$1", "compute"));
            }
            return psiClass;
        }
    };
    private final NotNullLazyValue<PsiClass> myArrayClass15 = new AtomicNotNullLazyValue<PsiClass>(){

        @Override
        @NotNull
        protected PsiClass compute() {
            PsiClass psiClass = PsiElementFactoryImpl.this.createArrayClass("public class __Array__<T> {\n public final int length;\n public T[] clone() {}\n}", LanguageLevel.JDK_1_5);
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl$2", "compute"));
            }
            return psiClass;
        }
    };
    private final ConcurrentMap<GlobalSearchScope, PsiClassType> myCachedObjectType = ContainerUtil.newConcurrentMap();
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCatchBlock(builder);
        }
    };

    public PsiElementFactoryImpl(PsiManagerEx manager) {
        super(manager);
        manager.registerRunnableToRunOnChange(() -> this.myCachedObjectType.clear());
    }

    @Override
    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClass"));
        }
        PsiClass psiClass = (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) ? this.myArrayClass15 : this.myArrayClass).getValue();
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClass"));
        }
        return psiClass;
    }

    private PsiClass createArrayClass(String text2, LanguageLevel level) {
        PsiClass psiClass = ((PsiExtensibleClass)this.createClassFromText(text2, null)).getOwnInnerClasses().get(0);
        PsiElementFactoryImpl.ensureNonWritable(psiClass);
        PsiFile file2 = psiClass.getContainingFile();
        ((PsiJavaFileBaseImpl)file2).clearCaches();
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set(file2, level);
        return psiClass;
    }

    private static void ensureNonWritable(PsiClass arrayClass) {
        try {
            arrayClass.getContainingFile().getViewProvider().getVirtualFile().setWritable(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClassType"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClassType"));
        }
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters2 = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        if (typeParameters2.length == 1) {
            substitutor2 = substitutor2.put(typeParameters2[0], componentType);
        }
        PsiClassType psiClassType = this.createType(arrayClass, substitutor2);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "getArrayClassType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor2) {
        if (resolve2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve2, substitutor2);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor2, @Nullable LanguageLevel languageLevel) {
        if (resolve2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve2, substitutor2, languageLevel);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve2, @NotNull PsiSubstitutor substitutor2, @Nullable LanguageLevel languageLevel, @NotNull PsiAnnotation[] annotations2) {
        if (resolve2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(resolve2, substitutor2, languageLevel, annotations2);
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createClass"));
        }
        PsiClass psiClass = this.createClassInner("class", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createClass"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createInterface"));
        }
        PsiClass psiClass = this.createClassInner("interface", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createInterface"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createEnum"));
        }
        PsiClass psiClass = this.createClassInner("enum", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createEnum"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationType"));
        }
        PsiClass psiClass = this.createClassInner("@interface", name);
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationType"));
        }
        return psiClass;
    }

    private PsiClass createClassInner(@NonNls String type2, @NonNls String name) {
        PsiUtil.checkIsIdentifier(this.myManager, name);
        PsiJavaFile aFile = this.createDummyJavaFile("public " + type2 + " " + name + " { }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type2 + " name \"" + name + "\".");
        }
        return classes2[0];
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeElement"));
        }
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated(element.getNode(), true);
        LightTypeElement lightTypeElement = element;
        if (lightTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeElement"));
        }
        return lightTypeElement;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByType"));
        }
        if (type2 instanceof PsiClassReferenceType) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiClassReferenceType)type2).getReference();
            if (psiJavaCodeReferenceElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByType"));
            }
            return psiJavaCodeReferenceElement;
        }
        LightClassTypeReference lightClassTypeReference = new LightClassTypeReference(this.myManager, type2);
        if (lightClassTypeReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByType"));
        }
        return lightClassTypeReference;
    }

    @Override
    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList parameterList = this.createMethodFromText("void foo()", null).getTypeParameterList();
        assert (parameterList != null);
        PsiTypeParameterList psiTypeParameterList = parameterList;
        if (psiTypeParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameterList"));
        }
        return psiTypeParameterList;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameter(String name, PsiClassType[] superTypes2) {
        PsiTypeParameter psiTypeParameter;
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name);
        if (superTypes2.length > 1 || superTypes2.length == 1 && !superTypes2[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type2 : superTypes2) {
                if (type2.equalsToText("java.lang.Object")) continue;
                builder.append(type2.getCanonicalText(true)).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder.toString(), null).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder.toString());
        }
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameter"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiField createField(@NotNull String name, @NotNull PsiType type2) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createField"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createField"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(type2)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text2 = "class _Dummy_ { private " + GenericsUtil.getVariableTypeByExpressionType(type2).getCanonicalText(true) + " " + name + "; }";
        PsiJavaFile aFile = this.createDummyJavaFile(text2);
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text2);
        }
        PsiClass psiClass = classes2[0];
        PsiField[] fields2 = psiClass.getFields();
        if (fields2.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text2);
        }
        PsiField field = fields2[0];
        field = (PsiField)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(field);
        PsiField psiField = (PsiField)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(field);
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createField"));
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createMethod"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(returnType)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = GenericsUtil.getVariableTypeByExpressionType(returnType).getCanonicalText(true);
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { public " + canonicalText + " " + name + "() {\n} }");
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod[] methods2 = classes2[0].getMethods();
        if (methods2.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod method = methods2[0];
        method = (PsiMethod)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(method);
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(method);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createMethod"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createMethod(@NotNull @NonNls String name, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createMethod"));
        }
        PsiMethod psiMethod = this.createMethodFromText("public " + GenericsUtil.getVariableTypeByExpressionType(returnType).getCanonicalText(true) + " " + name + "() {}", context);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createMethod"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor() {
        PsiMethod psiMethod = this.createConstructor("_Dummy_");
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile("class " + name + " { public " + name + "() {} }");
        PsiMethod method = aFile.getClasses()[0].getMethods()[0];
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(method);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        return psiMethod;
    }

    @Override
    public PsiMethod createConstructor(@NotNull @NonNls String name, PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createConstructor"));
        }
        return this.createMethodFromText(name + "() {}", context);
    }

    @Override
    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        PsiClassInitializer psiClassInitializer = (PsiClassInitializer)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(classInitializer);
        if (psiClassInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createClassInitializer"));
        }
        return psiClassInitializer;
    }

    @Override
    @NotNull
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type2) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiType.NULL.equals(type2)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text2 = type2.getCanonicalText(true) + " " + name;
        PsiParameter parameter = this.createParameterFromText(text2, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(this.myManager.getProject());
        PsiUtil.setModifierProperty(parameter, "final", JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated(parameter);
        parameter = (PsiParameter)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(parameter);
        PsiParameter psiParameter = (PsiParameter)codeStyleManager.reformat(parameter);
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        return psiParameter;
    }

    @Override
    public PsiParameter createParameter(@NotNull @NonNls String name, PsiType type2, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameter"));
        }
        PsiMethod psiMethod = this.createMethodFromText("void f(" + type2.getCanonicalText(true) + " " + name + ") {}", context);
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        return parameters2[0];
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(block);
        if (psiCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createCodeBlock"));
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiImmediateClassType psiImmediateClassType = new PsiImmediateClassType(aClass2, aClass2 instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor(aClass2));
        if (psiImmediateClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiImmediateClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference) {
        if (classReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(classReference, null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass2, PsiType parameter) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiTypeParameter[] typeParameters2 = aClass2.getTypeParameters();
        assert (typeParameters2.length == 1) : aClass2;
        PsiClassType psiClassType = this.createType(aClass2, PsiSubstitutor.EMPTY.put(typeParameters2[0], parameter));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass2, PsiType ... parameters2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        PsiClassType psiClassType = this.createType(aClass2, PsiSubstitutor.EMPTY.putAll(aClass2, parameters2));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createType"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, @NotNull PsiTypeParameter[] typeParameters2) {
        if (baseSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : typeParameters2) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substitutorMap).putAll(baseSubstitutor);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createRawSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiElement createDummyHolder(@NotNull String text2, @NotNull IElementType type2, @Nullable PsiElement context) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createDummyHolder"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createDummyHolder"));
        }
        DummyHolder result2 = DummyHolderFactory.createHolder(this.myManager, context);
        FileElement holder = result2.getTreeElement();
        Language language = type2.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, holder, lexer, language, (CharSequence)text2);
        ASTNode node = parserDefinition.createParser(project).parse(type2, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text2;
        PsiElement psiElement = psi;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createDummyHolder"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createSubstitutor"));
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(map2);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Override
    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPrimitiveType"));
        }
        return PsiJavaParserFacadeImpl.getPrimitiveType(text2);
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        PsiClassType psiClassType = this.createTypeByFQClassName(qName, GlobalSearchScope.allScope(this.myManager.getProject()));
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        if ("java.lang.Object".equals(qName)) {
            PsiClassType cachedObjectType = (PsiClassType)this.myCachedObjectType.get(resolveScope);
            if (cachedObjectType != null) {
                PsiClassType psiClassType = cachedObjectType;
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
                }
                return psiClassType;
            }
            PsiClass aClass2 = JavaPsiFacade.getInstance(this.myManager.getProject()).findClass("java.lang.Object", resolveScope);
            if (aClass2 != null) {
                cachedObjectType = new PsiImmediateClassType(aClass2, PsiSubstitutor.EMPTY);
                PsiClassType psiClassType = cachedObjectType = ConcurrencyUtil.cacheOrGet(this.myCachedObjectType, resolveScope, cachedObjectType);
                if (psiClassType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
                }
                return psiClassType;
            }
        }
        PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
        if (psiClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeByFQClassName"));
        }
        return psiClassReferenceType;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createClassReferenceElement"));
        }
        String text2 = aClass2 instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass2).getBaseClassType().getPresentableText() : aClass2.getName();
        if (text2 == null) {
            throw new IncorrectOperationException("Invalid class: " + aClass2);
        }
        LightClassReference lightClassReference = new LightClassReference(this.myManager, text2, aClass2);
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createClassReferenceElement"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByFQClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByFQClassName"));
        }
        String shortName = PsiNameHelper.getShortClassName(qName);
        LightClassReference lightClassReference = new LightClassReference(this.myManager, shortName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceElementByFQClassName"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createFQClassNameReferenceElement"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createFQClassNameReferenceElement"));
        }
        LightClassReference lightClassReference = new LightClassReference(this.myManager, qName, qName, resolveScope);
        if (lightClassReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createFQClassNameReferenceElement"));
        }
        return lightClassReference;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, aPackage);
        if (lightPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        return lightPackageReference;
    }

    @Override
    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageStatement"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile("package " + name + ";");
        PsiPackageStatement stmt = aFile.getPackageStatement();
        if (stmt == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name);
        }
        PsiPackageStatement psiPackageStatement = stmt;
        if (psiPackageStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageStatement"));
        }
        return psiPackageStatement;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass2, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStaticStatement"));
        }
        if (memberName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStaticStatement"));
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass2.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + aClass2.getQualifiedName() + "." + memberName + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStaticStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStaticStatement"));
        }
        return psiImportStaticStatement;
    }

    @Override
    @NotNull
    public PsiParameterList createParameterList(@NotNull String[] names2, @NotNull PsiType[] types) throws IncorrectOperationException {
        if (names2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterList"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterList"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method(");
        for (int i = 0; i < names2.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText(true)).append(' ').append(names2[i]);
        }
        builder.append(");");
        PsiParameterList psiParameterList = this.createMethodFromText(builder.toString(), null).getParameterList();
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterList"));
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList createReferenceList(@NotNull PsiJavaCodeReferenceElement[] references) throws IncorrectOperationException {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceList"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        PsiReferenceList psiReferenceList = this.createMethodFromText(builder.toString(), null).getThrowsList();
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceList"));
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReference lightPackageReference = new LightPackageReference(this.myManager, packageName);
        if (lightPackageReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createPackageReferenceElement"));
        }
        return lightPackageReference;
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass2) throws IncorrectOperationException {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        String text2 = aClass2 instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass2).getBaseClassType().getPresentableText() : aClass2.getName();
        LightClassReferenceExpression lightClassReferenceExpression = new LightClassReferenceExpression(this.myManager, text2, aClass2);
        if (lightClassReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        return lightClassReferenceExpression;
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        LightPackageReferenceExpression lightPackageReferenceExpression = new LightPackageReferenceExpression(this.myManager, aPackage);
        if (lightPackageReferenceExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createReferenceExpression"));
        }
        return lightPackageReferenceExpression;
    }

    @Override
    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createIdentifier"));
        }
        PsiUtil.checkIsIdentifier(this.myManager, text2);
        LightIdentifier lightIdentifier2 = new LightIdentifier(this.myManager, text2);
        if (lightIdentifier2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createIdentifier"));
        }
        return lightIdentifier2;
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull String text2) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        if (!PsiNameHelper.getInstance(this.myManager.getProject()).isKeyword(text2)) {
            throw new IncorrectOperationException("\"" + text2 + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, text2);
        if (lightKeyword == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        return lightKeyword;
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull @NonNls String keyword, PsiElement context) throws IncorrectOperationException {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        LanguageLevel level = PsiUtil.getLanguageLevel(context);
        if (!JavaLexer.isKeyword(keyword, level) && !JavaLexer.isSoftKeyword(keyword, level)) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        LightKeyword lightKeyword = new LightKeyword(this.myManager, keyword);
        if (lightKeyword == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createKeyword"));
        }
        return lightKeyword;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass2) throws IncorrectOperationException {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatement"));
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass2.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + aClass2.getQualifiedName() + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatement"));
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatementOnDemand"));
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!PsiNameHelper.getInstance(this.myManager.getProject()).isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + packageName + ".*;");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        PsiImportStatement psiImportStatement = (PsiImportStatement)CodeStyleManager.getInstance(this.myManager.getProject()).reformat(statement);
        if (psiImportStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createImportStatementOnDemand"));
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NonNls @NotNull String name, @NotNull PsiType type2, @Nullable PsiExpression initializer2) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        PsiDeclarationStatement psiDeclarationStatement = this.createVariableDeclarationStatement(name, type2, initializer2, null);
        if (psiDeclarationStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        return psiDeclarationStatement;
    }

    @Override
    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NonNls @NotNull String name, @NotNull PsiType type2, @Nullable PsiExpression initializer2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        if (!this.isIdentifier(name)) {
            throw new IncorrectOperationException("\"" + name + "\" is not an identifier.");
        }
        if (PsiType.NULL.equals(type2)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        String text2 = "X " + name + (initializer2 != null ? " = x" : "") + ";";
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(text2, context);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace(variable.getTypeElement(), this.createTypeElement(GenericsUtil.getVariableTypeByExpressionType(type2)), text2);
        boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalLocals();
        PsiUtil.setModifierProperty(variable, "final", generateFinalLocals);
        if (initializer2 != null) {
            PsiElementFactoryImpl.replace(variable.getInitializer(), initializer2, text2);
        }
        GeneratedMarkerVisitor.markGenerated(statement);
        PsiDeclarationStatement psiDeclarationStatement = statement;
        if (psiDeclarationStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createVariableDeclarationStatement"));
        }
        return psiDeclarationStatement;
    }

    private static void replace(@Nullable PsiElement original, @NotNull PsiElement replacement, @NotNull String message) {
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "replace"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "replace"));
        }
        assert (original != null) : message;
        original.replace(replacement);
    }

    @Override
    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, @NonNls String description) throws IncorrectOperationException {
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParamTag"));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        PsiDocTag psiDocTag = this.createDocTagFromText(builder.toString());
        if (psiDocTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParamTag"));
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationText", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationFromText"));
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated(psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationFromText"));
        }
        return psiAnnotation2;
    }

    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context, boolean markGenerated) throws IncorrectOperationException {
        if (annotationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationText", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createAnnotationFromText"));
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        if (markGenerated) {
            GeneratedMarkerVisitor.markGenerated(psiAnnotation);
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createCodeBlockFromText"));
        }
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(psiCodeBlock);
        PsiCodeBlock psiCodeBlock2 = psiCodeBlock;
        if (psiCodeBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createCodeBlockFromText"));
        }
        return psiCodeBlock2;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createEnumConstantFromText"));
        }
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(enumConstant);
        PsiEnumConstant psiEnumConstant = enumConstant;
        if (psiEnumConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createEnumConstantFromText"));
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createExpressionFromText"));
        }
        PsiExpression expression = super.createExpressionFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(expression);
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createExpressionFromText"));
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createFieldFromText"));
        }
        PsiField psiField = super.createFieldFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(psiField);
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createFieldFromText"));
        }
        return psiField2;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterFromText"));
        }
        PsiParameter parameter = super.createParameterFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(parameter);
        PsiParameter psiParameter = parameter;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createParameterFromText"));
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createStatementFromText"));
        }
        PsiStatement statement = super.createStatementFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(statement);
        PsiStatement psiStatement = statement;
        if (psiStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createStatementFromText"));
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeFromText"));
        }
        PsiType psiType = this.createTypeInner(text2, context, true);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeFromText"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text2, PsiElement context) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameterFromText"));
        }
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text2, context);
        GeneratedMarkerVisitor.markGenerated(typeParameter);
        PsiTypeParameter psiTypeParameter = typeParameter;
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createTypeParameterFromText"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text2, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createMethodFromText"));
        }
        PsiMethod method = super.createMethodFromText(text2, context, level);
        GeneratedMarkerVisitor.markGenerated(method);
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createMethodFromText"));
        }
        return psiMethod;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStatementBase[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        PsiImportStatementBase[] psiImportStatementBaseArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    @Override
    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createCatchSection"));
        }
        if (exceptionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionName", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createCatchSection"));
        }
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text2 = "catch (" + exceptionType.getCanonicalText(true) + " " + exceptionName + ") {}";
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text2, CATCH_SECTION, PsiElementFactoryImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text2 + "'. Parsed element: " + element);
        }
        Project project = this.myManager.getProject();
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(project);
        helper.setupCatchBlock(exceptionName, exceptionType, context, (PsiCatchSection)element);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        PsiCatchSection catchSection = (PsiCatchSection)styleManager.reformat(element);
        GeneratedMarkerVisitor.markGenerated(catchSection);
        PsiCatchSection psiCatchSection = catchSection;
        if (psiCatchSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "createCatchSection"));
        }
        return psiCatchSection;
    }

    @Override
    public boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "isValidClassName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "isValidMethodName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidParameterName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "isValidParameterName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidFieldName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "isValidFieldName"));
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidLocalVariableName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "isValidLocalVariableName"));
        }
        return this.isIdentifier(name);
    }

    private boolean isIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementFactoryImpl", "isIdentifier"));
        }
        return PsiNameHelper.getInstance(this.myManager.getProject()).isIdentifier(name);
    }
}

