/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.AbsentDescriptorHandler;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;

public class LazyDeclarationResolver {
    @NotNull
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    @NotNull
    private final AbsentDescriptorHandler absentDescriptorHandler;
    @NotNull
    private final BindingTrace trace;
    protected DeclarationScopeProvider scopeProvider;

    @Inject
    public void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl scopeProvider) {
        if (scopeProvider == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(0);
        }
        this.scopeProvider = scopeProvider;
    }

    @Deprecated
    public LazyDeclarationResolver(@NotNull GlobalContext globalContext, @NotNull BindingTrace delegationTrace, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @NotNull AbsentDescriptorHandler absentDescriptorHandler) {
        if (globalContext == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(1);
        }
        if (delegationTrace == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(2);
        }
        if (topLevelDescriptorProvider == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(3);
        }
        if (absentDescriptorHandler == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(4);
        }
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        this.absentDescriptorHandler = absentDescriptorHandler;
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
    }

    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        if (classOrObject == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(5);
        }
        if (location2 == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(6);
        }
        ClassDescriptor classDescriptor = this.findClassDescriptor(classOrObject, location2);
        if (classDescriptor == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(7);
        }
        return classDescriptor;
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor(@NotNull KtScript script, @NotNull LookupLocation location2) {
        if (script == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(8);
        }
        if (location2 == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(9);
        }
        ScriptDescriptor scriptDescriptor = (ScriptDescriptor)this.findClassDescriptor(script, location2);
        if (scriptDescriptor == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(10);
        }
        return scriptDescriptor;
    }

    @NotNull
    private ClassDescriptor findClassDescriptor(@NotNull KtNamedDeclaration classObjectOrScript, @NotNull LookupLocation location2) {
        if (classObjectOrScript == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(11);
        }
        if (location2 == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(12);
        }
        MemberScope scope = this.getMemberScopeDeclaredIn(classObjectOrScript, location2);
        ClassifierDescriptor scopeDescriptor = scope.getContributedClassifier(classObjectOrScript.getNameAsSafeName(), location2);
        DeclarationDescriptor descriptor2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classObjectOrScript);
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Could not find a classifier for %s.\nFound descriptor: %s (%s).\n", PsiUtilsKt.getElementTextWithContext(classObjectOrScript), scopeDescriptor != null ? DescriptorRenderer.DEBUG_TEXT.render(scopeDescriptor) : "null", scopeDescriptor != null ? scopeDescriptor.getContainingDeclaration().getClass() : null));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(13);
        }
        return classDescriptor;
    }

    @NotNull
    private BindingContext getBindingContext() {
        BindingContext bindingContext = this.trace.getBindingContext();
        if (bindingContext == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(14);
        }
        return bindingContext;
    }

    @NotNull
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(15);
        }
        DeclarationDescriptor declarationDescriptor = this.resolveToDescriptor(declaration, true);
        if (declarationDescriptor == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(16);
        }
        return declarationDescriptor;
    }

    @NotNull
    private DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration, final boolean track) {
        DeclarationDescriptor result2;
        if (declaration == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(17);
        }
        if ((result2 = declaration.accept(new KtVisitor<DeclarationDescriptor, Void>(){

            @NotNull
            private LookupLocation lookupLocationFor(@NotNull KtDeclaration declaration, boolean isTopLevel) {
                if (declaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                LookupLocation lookupLocation = isTopLevel && track ? new KotlinLookupLocation(declaration) : NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                if (lookupLocation == null) {
                    1.$$$reportNull$$$0(1);
                }
                return lookupLocation;
            }

            @Override
            public DeclarationDescriptor visitClass(@NotNull KtClass klass2, Void data2) {
                if (klass2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return LazyDeclarationResolver.this.getClassDescriptor(klass2, this.lookupLocationFor(klass2, klass2.isTopLevel()));
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, Void data2) {
                if (declaration == null) {
                    1.$$$reportNull$$$0(3);
                }
                return LazyDeclarationResolver.this.getClassDescriptor(declaration, this.lookupLocationFor(declaration, declaration.isTopLevel()));
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(@NotNull KtTypeParameter parameter, Void data2) {
                List<TypeParameterDescriptor> typeParameters2;
                if (parameter == null) {
                    1.$$$reportNull$$$0(4);
                }
                KtTypeParameterListOwner ownerElement = PsiTreeUtil.getParentOfType((PsiElement)parameter, KtTypeParameterListOwner.class);
                assert (ownerElement != null) : "Owner not found for type parameter: " + parameter.getText();
                DeclarationDescriptor ownerDescriptor = LazyDeclarationResolver.this.resolveToDescriptor(ownerElement, false);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters2 = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassifierDescriptorWithTypeParameters) {
                    ClassifierDescriptorWithTypeParameters classifierDescriptor = (ClassifierDescriptorWithTypeParameters)ownerDescriptor;
                    typeParameters2 = classifierDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name = parameter.getNameAsSafeName();
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters2) {
                    if (!typeParameterDescriptor.getName().equals(name)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(@NotNull KtNamedFunction function2, Void data2) {
                if (function2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                LookupLocation location2 = this.lookupLocationFor(function2, function2.isTopLevel());
                MemberScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(function2, location2);
                scopeForDeclaration.getContributedFunctions(function2.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            }

            @Override
            public DeclarationDescriptor visitParameter(@NotNull KtParameter parameter, Void data2) {
                PsiElement grandFather;
                if (parameter == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((grandFather = parameter.getParent().getParent()) instanceof KtPrimaryConstructor) {
                    KtClassOrObject jetClass = ((KtPrimaryConstructor)grandFather).getContainingClassOrObject();
                    ClassDescriptor classDescriptor = LazyDeclarationResolver.this.getClassDescriptor(jetClass, this.lookupLocationFor(jetClass, false));
                    if (parameter.hasValOrVar()) {
                        classDescriptor.getDefaultType().getMemberScope().getContributedVariables(parameter.getNameAsSafeName(), this.lookupLocationFor(parameter, false));
                        return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ClassConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof KtNamedFunction) {
                    FunctionDescriptor function2 = (FunctionDescriptor)this.visitNamedFunction((KtNamedFunction)grandFather, data2);
                    function2.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof KtSecondaryConstructor) {
                    ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)this.visitSecondaryConstructor((KtSecondaryConstructor)grandFather, data2);
                    constructorDescriptor.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data2);
            }

            @Override
            public DeclarationDescriptor visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, Void data2) {
                if (constructor == null) {
                    1.$$$reportNull$$$0(7);
                }
                LazyDeclarationResolver.this.getClassDescriptor((KtClassOrObject)constructor.getParent().getParent(), this.lookupLocationFor(constructor, false)).getConstructors();
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.CONSTRUCTOR, constructor);
            }

            @Override
            public DeclarationDescriptor visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor, Void data2) {
                if (constructor == null) {
                    1.$$$reportNull$$$0(8);
                }
                LazyDeclarationResolver.this.getClassDescriptor(constructor.getContainingClassOrObject(), this.lookupLocationFor(constructor, false)).getConstructors();
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.CONSTRUCTOR, constructor);
            }

            @Override
            public DeclarationDescriptor visitProperty(@NotNull KtProperty property, Void data2) {
                if (property == null) {
                    1.$$$reportNull$$$0(9);
                }
                LookupLocation location2 = this.lookupLocationFor(property, property.isTopLevel());
                MemberScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(property, location2);
                scopeForDeclaration.getContributedVariables(property.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
            }

            @Override
            public DeclarationDescriptor visitTypeAlias(@NotNull KtTypeAlias typeAlias, Void data2) {
                if (typeAlias == null) {
                    1.$$$reportNull$$$0(10);
                }
                LookupLocation location2 = this.lookupLocationFor(typeAlias, typeAlias.isTopLevel());
                MemberScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(typeAlias, location2);
                scopeForDeclaration.getContributedClassifier(typeAlias.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, typeAlias);
            }

            @Override
            public DeclarationDescriptor visitScript(@NotNull KtScript script, Void data2) {
                if (script == null) {
                    1.$$$reportNull$$$0(11);
                }
                return LazyDeclarationResolver.this.getScriptDescriptor(script, this.lookupLocationFor(script, true));
            }

            @Override
            public DeclarationDescriptor visitKtElement(@NotNull KtElement element, Void data2) {
                if (element == null) {
                    1.$$$reportNull$$$0(12);
                }
                throw new IllegalArgumentException("Unsupported declaration type: " + element + " " + PsiUtilsKt.getElementTextWithContext(element));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "klass";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constructor";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeAlias";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "script";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "lookupLocationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "lookupLocationFor";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitObjectDeclaration";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeParameter";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitNamedFunction";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitParameter";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "visitSecondaryConstructor";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPrimaryConstructor";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "visitProperty";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeAlias";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "visitScript";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "visitKtElement";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, null)) == null) {
            DeclarationDescriptor declarationDescriptor = this.absentDescriptorHandler.diagnoseDescriptorNotFound(declaration);
            if (declarationDescriptor == null) {
                LazyDeclarationResolver.$$$reportNull$$$0(18);
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor declarationDescriptor = result2;
        if (declarationDescriptor == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(19);
        }
        return declarationDescriptor;
    }

    @NotNull
    MemberScope getMemberScopeDeclaredIn(@NotNull KtDeclaration declaration, @NotNull LookupLocation location2) {
        KtDeclaration parentDeclaration;
        boolean isTopLevel;
        if (declaration == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(20);
        }
        if (location2 == null) {
            LazyDeclarationResolver.$$$reportNull$$$0(21);
        }
        boolean bl = isTopLevel = (parentDeclaration = KtStubbedPsiUtil.getContainingDeclaration(declaration)) == null;
        if (isTopLevel) {
            KtFile ktFile = (KtFile)declaration.getContainingFile();
            FqName fqName2 = ktFile.getPackageFqName();
            LazyPackageDescriptor packageDescriptor = this.topLevelDescriptorProvider.getPackageFragment(fqName2);
            if (packageDescriptor == null) {
                if (this.topLevelDescriptorProvider instanceof LazyClassContext) {
                    ((LazyClassContext)((Object)this.topLevelDescriptorProvider)).getDeclarationProviderFactory().diagnoseMissingPackageFragment(ktFile);
                } else {
                    throw new IllegalStateException("Cannot find package fragment for file " + ktFile.getName() + " with package " + fqName2);
                }
            }
            MemberScope memberScope2 = packageDescriptor.getMemberScope();
            if (memberScope2 == null) {
                LazyDeclarationResolver.$$$reportNull$$$0(22);
            }
            return memberScope2;
        }
        if (parentDeclaration instanceof KtClassOrObject) {
            MemberScope memberScope3 = this.getClassDescriptor((KtClassOrObject)parentDeclaration, location2).getUnsubstitutedMemberScope();
            if (memberScope3 == null) {
                LazyDeclarationResolver.$$$reportNull$$$0(23);
            }
            return memberScope3;
        }
        if (parentDeclaration instanceof KtScript) {
            MemberScope memberScope4 = this.getScriptDescriptor((KtScript)parentDeclaration, location2).getUnsubstitutedMemberScope();
            if (memberScope4 == null) {
                LazyDeclarationResolver.$$$reportNull$$$0(24);
            }
            return memberScope4;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + declaration + "\n" + PsiUtilsKt.getElementTextWithContext(declaration));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegationTrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelDescriptorProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absentDescriptorHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrObject";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classObjectOrScript";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToDescriptor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberScopeDeclaredIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDeclarationScopeProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScriptDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClassDescriptor";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveToDescriptor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMemberScopeDeclaredIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

