/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/CollectionLiteralResolver;", "", "()V", "ARRAY_OF_FUNCTION", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/annotations/NotNull;", "PRIMITIVE_TYPE_TO_ARRAY", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "checkSupportsArrayLiterals", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getArrayFunctionCallName", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getFunctionDescriptorForCollectionLiteral", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "isInsideAnnotationEntryOrClass", "", "resolveCollectionLiteral", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "collectionLiteralExpression", "callResolver", "Lorg/jetbrains/kotlin/resolve/calls/CallResolver;", "resolveCollectionLiteralSpecialMethod", "kotlin-compiler"})
public final class CollectionLiteralResolver {
    private static final Map<PrimitiveType, Name> PRIMITIVE_TYPE_TO_ARRAY;
    private static final Name ARRAY_OF_FUNCTION;
    public static final CollectionLiteralResolver INSTANCE;

    @NotNull
    public final KotlinTypeInfo resolveCollectionLiteral(@NotNull KtCollectionLiteralExpression collectionLiteralExpression, @NotNull ExpressionTypingContext context, @NotNull CallResolver callResolver, @NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(collectionLiteralExpression, "collectionLiteralExpression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(callResolver, "callResolver");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        if (!this.isInsideAnnotationEntryOrClass(collectionLiteralExpression)) {
            context.trace.report(Errors.UNSUPPORTED.on(collectionLiteralExpression, "Collection literals outside of annotations"));
        }
        this.checkSupportsArrayLiterals(collectionLiteralExpression, context, languageVersionSettings);
        return this.resolveCollectionLiteralSpecialMethod(collectionLiteralExpression, context, callResolver, builtIns);
    }

    private final KotlinTypeInfo resolveCollectionLiteralSpecialMethod(KtCollectionLiteralExpression expression, ExpressionTypingContext context, CallResolver callResolver, KotlinBuiltIns builtIns) {
        SimpleFunctionDescriptor functionDescriptor;
        Call call2 = CallMaker.makeCallForCollectionLiteral(expression);
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = callResolver.resolveCollectionLiteralCallWithGivenDescriptor(context, expression, call2, functionDescriptor = this.getFunctionDescriptorForCollectionLiteral(expression, context, builtIns));
        if (!resolutionResults.isSingleResult()) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        context.trace.record(BindingContext.COLLECTION_LITERAL_CALL, expression, resolutionResults.getResultingCall());
        return TypeInfoFactoryKt.createTypeInfo(resolutionResults.getResultingDescriptor().getReturnType(), context);
    }

    private final SimpleFunctionDescriptor getFunctionDescriptorForCollectionLiteral(KtCollectionLiteralExpression expression, ExpressionTypingContext context, KotlinBuiltIns builtIns) {
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        Name callName = this.getArrayFunctionCallName(kotlinType);
        return (SimpleFunctionDescriptor)CollectionsKt.single((Iterable)builtIns.getBuiltInsPackageScope().getContributedFunctions(callName, new KotlinLookupLocation(expression)));
    }

    private final void checkSupportsArrayLiterals(KtCollectionLiteralExpression expression, ExpressionTypingContext context, LanguageVersionSettings languageVersionSettings) {
        if (this.isInsideAnnotationEntryOrClass(expression) && !languageVersionSettings.supportsFeature(LanguageFeature.ArrayLiteralsInAnnotations)) {
            context.trace.report(Errors.UNSUPPORTED_FEATURE.on(expression, TuplesKt.to(LanguageFeature.ArrayLiteralsInAnnotations, languageVersionSettings)));
        }
    }

    private final boolean isInsideAnnotationEntryOrClass(KtCollectionLiteralExpression expression) {
        KtElementImplStub parent2 = (KtElementImplStub)PsiTreeUtil.getParentOfType((PsiElement)expression, KtAnnotationEntry.class, KtClass.class);
        return parent2 instanceof KtAnnotationEntry || parent2 instanceof KtClass && ((KtClass)parent2).isAnnotation();
    }

    private final Name getArrayFunctionCallName(KotlinType expectedType) {
        Map<PrimitiveType, Name> map2;
        if (TypeUtils.NO_EXPECTED_TYPE == expectedType || !KotlinBuiltIns.isPrimitiveArray(expectedType)) {
            Name name = ARRAY_OF_FUNCTION;
            Intrinsics.checkExpressionValueIsNotNull(name, "ARRAY_OF_FUNCTION");
            return name;
        }
        ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Name name = ARRAY_OF_FUNCTION;
            Intrinsics.checkExpressionValueIsNotNull(name, "ARRAY_OF_FUNCTION");
            return name;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        FqNameUnsafe arrayFqName = DescriptorUtils.getFqName(descriptor2);
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveTypeByArrayClassFqName(arrayFqName);
        Map<PrimitiveType, Name> map3 = map2 = PRIMITIVE_TYPE_TO_ARRAY;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        Name name = map3.get((Object)primitiveType);
        if (name == null) {
            Name name2 = ARRAY_OF_FUNCTION;
            name = name2;
            Intrinsics.checkExpressionValueIsNotNull(name2, "ARRAY_OF_FUNCTION");
        }
        return name;
    }

    private CollectionLiteralResolver() {
        INSTANCE = this;
        PRIMITIVE_TYPE_TO_ARRAY = MapsKt.hashMapOf(TuplesKt.to(PrimitiveType.BOOLEAN, Name.identifier("booleanArrayOf")), TuplesKt.to(PrimitiveType.CHAR, Name.identifier("charArrayOf")), TuplesKt.to(PrimitiveType.INT, Name.identifier("intArrayOf")), TuplesKt.to(PrimitiveType.BYTE, Name.identifier("byteArrayOf")), TuplesKt.to(PrimitiveType.SHORT, Name.identifier("shortArrayOf")), TuplesKt.to(PrimitiveType.FLOAT, Name.identifier("floatArrayOf")), TuplesKt.to(PrimitiveType.LONG, Name.identifier("longArrayOf")), TuplesKt.to(PrimitiveType.DOUBLE, Name.identifier("doubleArrayOf")));
        ARRAY_OF_FUNCTION = Name.identifier("arrayOf");
    }

    static {
        new CollectionLiteralResolver();
    }
}

