/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptorImpl;
import org.jetbrains.kotlin.load.java.descriptors.SamTypeAliasConstructorDescriptorImpl;
import org.jetbrains.kotlin.load.java.sam.SamAdapterClassConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterFunctionDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JavaResolverUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;

public class SingleAbstractMethodUtils {
    private SingleAbstractMethodUtils() {
    }

    @NotNull
    public static List<CallableMemberDescriptor> getAbstractMembers(@NotNull KotlinType type2) {
        if (type2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(0);
        }
        ArrayList<CallableMemberDescriptor> abstractMembers = new ArrayList<CallableMemberDescriptor>();
        for (DeclarationDescriptor member : DescriptorUtils.getAllDescriptors(type2.getMemberScope())) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            abstractMembers.add((CallableMemberDescriptor)member);
        }
        ArrayList<CallableMemberDescriptor> arrayList = abstractMembers;
        if (arrayList == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public static KotlinType getFunctionTypeForSamType(@NotNull KotlinType samType) {
        UnwrappedType unwrappedType;
        if (samType == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(2);
        }
        if ((unwrappedType = samType.unwrap()) instanceof FlexibleType) {
            SimpleType lower2 = SingleAbstractMethodUtils.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getLowerBound());
            SimpleType upper = SingleAbstractMethodUtils.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getUpperBound());
            assert (lower2 == null == (upper == null)) : "Illegal flexible type: " + unwrappedType;
            if (upper == null) {
                return null;
            }
            return KotlinTypeFactory.flexibleType(lower2, upper);
        }
        return SingleAbstractMethodUtils.getFunctionTypeForSamType((SimpleType)unwrappedType);
    }

    @Nullable
    private static SimpleType getFunctionTypeForSamType(@NotNull SimpleType samType) {
        SimpleType functionTypeDefault;
        ClassifierDescriptor classifier2;
        if (samType == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(3);
        }
        if ((classifier2 = samType.getConstructor().getDeclarationDescriptor()) instanceof JavaClassDescriptor && (functionTypeDefault = ((JavaClassDescriptor)classifier2).getFunctionTypeForSamInterface()) != null) {
            SimpleType noProjectionsSamType = SingleAbstractMethodUtilsKt.nonProjectionParametrization(samType);
            if (noProjectionsSamType == null) {
                return null;
            }
            KotlinType type2 = TypeSubstitutor.create(noProjectionsSamType).substitute(functionTypeDefault, Variance.IN_VARIANCE);
            assert (type2 != null) : "Substitution based on type with no projections '" + noProjectionsSamType + "' should not end with conflict";
            SimpleType simpleType2 = TypeSubstitutionKt.asSimpleType(type2);
            return simpleType2.makeNullableAsSpecified(samType.isMarkedNullable());
        }
        return null;
    }

    @NotNull
    public static SimpleType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function2, boolean shouldConvertFirstParameterToDescriptor) {
        if (function2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(4);
        }
        KotlinType returnType = function2.getReturnType();
        assert (returnType != null) : "function is not initialized: " + function2;
        List<ValueParameterDescriptor> valueParameters = function2.getValueParameters();
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters.size());
        int startIndex = 0;
        KotlinType receiverType = null;
        if (shouldConvertFirstParameterToDescriptor && !function2.getValueParameters().isEmpty()) {
            receiverType = valueParameters.get(0).getType();
            startIndex = 1;
        }
        for (int i = startIndex; i < valueParameters.size(); ++i) {
            ValueParameterDescriptor parameter = valueParameters.get(i);
            parameterTypes.add(parameter.getType());
            parameterNames.add(function2.hasSynthesizedParameterNames() ? SpecialNames.NO_NAME_PROVIDED : parameter.getName());
        }
        SimpleType simpleType2 = FunctionTypesKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(function2), Annotations.Companion.getEMPTY(), receiverType, parameterTypes, parameterNames, returnType);
        if (simpleType2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(5);
        }
        return simpleType2;
    }

    @Nullable
    public static FunctionDescriptor getSingleAbstractMethodOrNull(@NotNull ClassDescriptor klass2) {
        CallableMemberDescriptor member;
        if (klass2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(6);
        }
        if (klass2.getKind() != ClassKind.INTERFACE) {
            return null;
        }
        if (DescriptorUtilsKt.getFqNameSafe(klass2).asString().equals("android.databinding.DataBindingComponent")) {
            return null;
        }
        List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(klass2.getDefaultType());
        if (abstractMembers.size() == 1 && (member = abstractMembers.get(0)) instanceof SimpleFunctionDescriptor) {
            return member.getTypeParameters().isEmpty() ? (FunctionDescriptor)member : null;
        }
        return null;
    }

    @NotNull
    public static SamConstructorDescriptor createSamConstructorFunction(@NotNull DeclarationDescriptor owner, @NotNull JavaClassDescriptor samInterface) {
        if (owner == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(7);
        }
        if (samInterface == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(8);
        }
        assert (SingleAbstractMethodUtils.getSingleAbstractMethodOrNull(samInterface) != null) : samInterface;
        SamConstructorDescriptorImpl result2 = new SamConstructorDescriptorImpl(owner, samInterface);
        List<TypeParameterDescriptor> samTypeParameters = samInterface.getTypeConstructor().getParameters();
        SimpleType unsubstitutedSamType = samInterface.getDefaultType();
        SingleAbstractMethodUtils.initializeSamConstructorDescriptor(samInterface, result2, samTypeParameters, unsubstitutedSamType);
        SamConstructorDescriptorImpl samConstructorDescriptorImpl = result2;
        if (samConstructorDescriptorImpl == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(9);
        }
        return samConstructorDescriptorImpl;
    }

    private static void initializeSamConstructorDescriptor(@NotNull JavaClassDescriptor samInterface, @NotNull SimpleFunctionDescriptorImpl samConstructor, @NotNull List<TypeParameterDescriptor> samTypeParameters, @NotNull KotlinType unsubstitutedSamType) {
        if (samInterface == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(10);
        }
        if (samConstructor == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(11);
        }
        if (samTypeParameters == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(12);
        }
        if (unsubstitutedSamType == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(13);
        }
        TypeParameters typeParameters2 = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(samTypeParameters, samConstructor);
        KotlinType parameterTypeUnsubstituted = SingleAbstractMethodUtils.getFunctionTypeForSamType(unsubstitutedSamType);
        assert (parameterTypeUnsubstituted != null) : "couldn't get function type for SAM type " + unsubstitutedSamType;
        KotlinType parameterType = typeParameters2.substitutor.substitute(parameterTypeUnsubstituted, Variance.IN_VARIANCE);
        assert (parameterType != null) : "couldn't substitute type: " + parameterTypeUnsubstituted + ", substitutor = " + typeParameters2.substitutor;
        ValueParameterDescriptorImpl parameter = new ValueParameterDescriptorImpl(samConstructor, null, 0, Annotations.Companion.getEMPTY(), Name.identifier("function"), parameterType, false, false, false, null, SourceElement.NO_SOURCE);
        KotlinType returnType = typeParameters2.substitutor.substitute(unsubstitutedSamType, Variance.OUT_VARIANCE);
        assert (returnType != null) : "couldn't substitute type: " + unsubstitutedSamType + ", substitutor = " + typeParameters2.substitutor;
        samConstructor.initialize((KotlinType)null, (ReceiverParameterDescriptor)null, typeParameters2.descriptors, Collections.singletonList(parameter), returnType, Modality.FINAL, samInterface.getVisibility());
    }

    public static SamConstructorDescriptor createTypeAliasSamConstructorFunction(@NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull SamConstructorDescriptor underlyingSamConstructor) {
        if (typeAliasDescriptor == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(14);
        }
        if (underlyingSamConstructor == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(15);
        }
        SamTypeAliasConstructorDescriptorImpl result2 = new SamTypeAliasConstructorDescriptorImpl(typeAliasDescriptor, underlyingSamConstructor);
        JavaClassDescriptor samInterface = (JavaClassDescriptor)underlyingSamConstructor.getBaseDescriptorForSynthetic();
        List<TypeParameterDescriptor> samTypeParameters = typeAliasDescriptor.getTypeConstructor().getParameters();
        SimpleType unsubstitutedSamType = typeAliasDescriptor.getExpandedType();
        SingleAbstractMethodUtils.initializeSamConstructorDescriptor(samInterface, result2, samTypeParameters, unsubstitutedSamType);
        return result2;
    }

    public static boolean isSamType(@NotNull KotlinType type2) {
        if (type2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(16);
        }
        return SingleAbstractMethodUtils.getFunctionTypeForSamType(type2) != null;
    }

    public static boolean isSamAdapterNecessary(@NotNull FunctionDescriptor fun) {
        if (fun == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(17);
        }
        for (ValueParameterDescriptor param : fun.getValueParameters()) {
            if (!SingleAbstractMethodUtils.isSamType(param.getType())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaMethodDescriptor> createSamAdapterFunction(final @NotNull JavaMethodDescriptor original) {
        if (original == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(18);
        }
        final SamAdapterFunctionDescriptor result2 = new SamAdapterFunctionDescriptor(original);
        SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters2, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull KotlinType returnType) {
                if (typeParameters2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (valueParameters == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (returnType == null) {
                    1.$$$reportNull$$$0(2);
                }
                result2.initialize((KotlinType)null, original.getDispatchReceiverParameter(), typeParameters2, (List)valueParameters, returnType, Modality.FINAL, original.getVisibility());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeParameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "valueParameters";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "returnType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1";
                objectArray[2] = "initialize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (samAdapterDescriptor == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(19);
        }
        return samAdapterDescriptor;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaClassConstructorDescriptor> createSamAdapterConstructor(final @NotNull JavaClassConstructorDescriptor original) {
        if (original == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(20);
        }
        final SamAdapterClassConstructorDescriptor result2 = new SamAdapterClassConstructorDescriptor(original);
        SamAdapterDescriptor<JavaClassConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters2, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull KotlinType returnType) {
                if (typeParameters2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (valueParameters == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (returnType == null) {
                    2.$$$reportNull$$$0(2);
                }
                result2.initialize(valueParameters, original.getVisibility());
                result2.setReturnType(returnType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeParameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "valueParameters";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "returnType";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2";
                objectArray[2] = "initialize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (samAdapterDescriptor == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(21);
        }
        return samAdapterDescriptor;
    }

    @NotNull
    private static <F extends FunctionDescriptor> SamAdapterDescriptor<F> initSamAdapter(@NotNull F original, @NotNull SamAdapterDescriptor<F> adapter, @NotNull FunctionInitializer initializer2) {
        if (original == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(22);
        }
        if (adapter == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(23);
        }
        if (initializer2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(24);
        }
        TypeParameters typeParameters2 = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(original.getTypeParameters(), adapter);
        KotlinType returnTypeUnsubstituted = original.getReturnType();
        assert (returnTypeUnsubstituted != null) : "Creating SAM adapter for not initialized original: " + original;
        TypeSubstitutor substitutor2 = typeParameters2.substitutor;
        KotlinType returnType = substitutor2.substitute(returnTypeUnsubstituted, Variance.INVARIANT);
        assert (returnType != null) : "couldn't substitute type: " + returnTypeUnsubstituted + ", substitutor = " + substitutor2;
        List<ValueParameterDescriptor> valueParameters = SingleAbstractMethodUtils.createValueParametersForSamAdapter(original, adapter, substitutor2);
        initializer2.initialize(typeParameters2.descriptors, valueParameters, returnType);
        SamAdapterDescriptor<F> samAdapterDescriptor = adapter;
        if (samAdapterDescriptor == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(25);
        }
        return samAdapterDescriptor;
    }

    public static List<ValueParameterDescriptor> createValueParametersForSamAdapter(@NotNull FunctionDescriptor original, @NotNull FunctionDescriptor samAdapter, @NotNull TypeSubstitutor substitutor2) {
        if (original == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(26);
        }
        if (samAdapter == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(27);
        }
        if (substitutor2 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(28);
        }
        List<ValueParameterDescriptor> originalValueParameters = original.getValueParameters();
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(originalValueParameters.size());
        for (ValueParameterDescriptor originalParam : originalValueParameters) {
            KotlinType originalType = originalParam.getType();
            KotlinType functionType = SingleAbstractMethodUtils.getFunctionTypeForSamType(originalType);
            KotlinType newTypeUnsubstituted = functionType != null ? functionType : originalType;
            KotlinType newType = substitutor2.substitute(newTypeUnsubstituted, Variance.IN_VARIANCE);
            assert (newType != null) : "couldn't substitute type: " + newTypeUnsubstituted + ", substitutor = " + substitutor2;
            ValueParameterDescriptorImpl newParam = new ValueParameterDescriptorImpl(samAdapter, null, originalParam.getIndex(), originalParam.getAnnotations(), originalParam.getName(), newType, false, false, false, null, SourceElement.NO_SOURCE);
            valueParameters.add(newParam);
        }
        return valueParameters;
    }

    @NotNull
    private static TypeParameters recreateAndInitializeTypeParameters(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(29);
        }
        if (newOwner instanceof SamAdapterClassConstructorDescriptor) {
            TypeParameters typeParameters2 = new TypeParameters(originalParameters, TypeSubstitutor.EMPTY);
            if (typeParameters2 == null) {
                SingleAbstractMethodUtils.$$$reportNull$$$0(30);
            }
            return typeParameters2;
        }
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> traitToFunTypeParameters = JavaResolverUtils.recreateTypeParametersAndReturnMapping(originalParameters, newOwner);
        TypeSubstitutor typeParametersSubstitutor = JavaResolverUtils.createSubstitutorForTypeParameters(traitToFunTypeParameters);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> mapEntry : traitToFunTypeParameters.entrySet()) {
            TypeParameterDescriptor traitTypeParameter = mapEntry.getKey();
            TypeParameterDescriptorImpl funTypeParameter = mapEntry.getValue();
            for (KotlinType upperBound : traitTypeParameter.getUpperBounds()) {
                KotlinType upperBoundSubstituted = typeParametersSubstitutor.substitute(upperBound, Variance.INVARIANT);
                assert (upperBoundSubstituted != null) : "couldn't substitute type: " + upperBound + ", substitutor = " + typeParametersSubstitutor;
                funTypeParameter.addUpperBound(upperBoundSubstituted);
            }
            funTypeParameter.setInitialized();
        }
        ArrayList<TypeParameterDescriptorImpl> typeParameters3 = new ArrayList<TypeParameterDescriptorImpl>(traitToFunTypeParameters.values());
        TypeParameters typeParameters4 = new TypeParameters(typeParameters3, typeParametersSubstitutor);
        if (typeParameters4 == null) {
            SingleAbstractMethodUtils.$$$reportNull$$$0(31);
        }
        return typeParameters4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samInterface";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samConstructor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samTypeParameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsubstitutedSamType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasDescriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingSamConstructor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samAdapter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbstractMembers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypeForAbstractMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSamConstructorFunction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSamAdapterFunction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSamAdapterConstructor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "initSamAdapter";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "recreateAndInitializeTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractMembers";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 31: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeForSamType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypeForAbstractMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSingleAbstractMethodOrNull";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSamConstructorFunction";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "initializeSamConstructorDescriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTypeAliasSamConstructorFunction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSamType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSamAdapterNecessary";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSamAdapterFunction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSamAdapterConstructor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initSamAdapter";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createValueParametersForSamAdapter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "recreateAndInitializeTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class FunctionInitializer {
        private FunctionInitializer() {
        }

        public abstract void initialize(@NotNull List<TypeParameterDescriptor> var1, @NotNull List<ValueParameterDescriptor> var2, @NotNull KotlinType var3);
    }

    private static class TypeParameters {
        public final List<TypeParameterDescriptor> descriptors;
        public final TypeSubstitutor substitutor;

        private TypeParameters(List<TypeParameterDescriptor> descriptors, TypeSubstitutor substitutor2) {
            this.descriptors = descriptors;
            this.substitutor = substitutor2;
        }
    }
}

