/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsDescriptorUtils {
    private static final Set<String> FAKE_CLASSES = ContainerUtil.immutableSet(KotlinBuiltIns.FQ_NAMES.any.asString());

    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(0);
        }
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(1);
        }
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isCompareTo(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(2);
        }
        return descriptor2.getName().equals(OperatorNameConventions.COMPARE_TO);
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        if (superclassDescriptors == null) {
            JsDescriptorUtils.$$$reportNull$$$0(3);
        }
        for (ClassDescriptor descriptor2 : superclassDescriptors) {
            if (descriptor2.getKind() != ClassKind.CLASS && descriptor2.getKind() != ClassKind.ENUM_CLASS) continue;
            return descriptor2;
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(4);
        }
        return JsDescriptorUtils.findAncestorClass(DescriptorUtils.getSuperclassDescriptors(classDescriptor));
    }

    @NotNull
    public static List<KotlinType> getSupertypesWithoutFakes(ClassDescriptor descriptor2) {
        Collection<KotlinType> supertypes2 = descriptor2.getTypeConstructor().getSupertypes();
        List<KotlinType> list2 = ContainerUtil.filter(supertypes2, new Condition<KotlinType>(){

            @Override
            public boolean value(KotlinType type2) {
                ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(type2);
                return !FAKE_CLASSES.contains(DescriptorUtils.getFqNameSafe(classDescriptor).asString()) && (classDescriptor.getKind() != ClassKind.INTERFACE || !AnnotationsUtils.isNativeObject(classDescriptor));
            }
        });
        if (list2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(6);
        }
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        DeclarationDescriptor declarationDescriptor = containing;
        if (declarationDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(7);
        }
        return declarationDescriptor;
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            JsDescriptorUtils.$$$reportNull$$$0(8);
        }
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter);
        ReceiverParameterDescriptor receiverParameterDescriptor = JsDescriptorUtils.getReceiverParameterForDeclaration(declarationDescriptor);
        if (receiverParameterDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(9);
        }
        return receiverParameterDescriptor;
    }

    @NotNull
    private static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            JsDescriptorUtils.$$$reportNull$$$0(10);
        }
        if (receiverParameter instanceof ImplicitReceiver) {
            DeclarationDescriptor declarationDescriptor = ((ImplicitReceiver)receiverParameter).getDeclarationDescriptor();
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getOriginal();
            if (declarationDescriptor2 == null) {
                JsDescriptorUtils.$$$reportNull$$$0(11);
            }
            return declarationDescriptor2;
        }
        throw new UnsupportedOperationException("Unsupported receiver type: " + receiverParameter.getClass() + ", receiverParameter = " + receiverParameter);
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForDeclaration(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            if (receiverParameterDescriptor == null) {
                JsDescriptorUtils.$$$reportNull$$$0(12);
            }
            return receiverParameterDescriptor;
        }
        if (declarationDescriptor instanceof CallableMemberDescriptor) {
            ReceiverParameterDescriptor receiverDescriptor = ((CallableMemberDescriptor)declarationDescriptor).getExtensionReceiverParameter();
            assert (receiverDescriptor != null);
            ReceiverParameterDescriptor receiverParameterDescriptor = receiverDescriptor;
            if (receiverParameterDescriptor == null) {
                JsDescriptorUtils.$$$reportNull$$$0(13);
            }
            return receiverParameterDescriptor;
        }
        throw new UnsupportedOperationException("Unsupported declaration type: " + declarationDescriptor.getClass() + ", declarationDescriptor = " + declarationDescriptor);
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault();
    }

    public static boolean sideEffectsPossibleOnRead(@NotNull PropertyDescriptor property) {
        if (property == null) {
            JsDescriptorUtils.$$$reportNull$$$0(14);
        }
        return DynamicCallsKt.isDynamic(property) || !JsDescriptorUtils.isDefaultAccessor(property.getGetter()) || ModalityKt.isOverridableOrOverrides(property) || JsDescriptorUtils.isStaticInitializationPossible(property);
    }

    private static boolean isStaticInitializationPossible(PropertyDescriptor property) {
        DeclarationDescriptor container2 = property.getContainingDeclaration();
        return container2 instanceof PackageFragmentDescriptor || DescriptorUtils.isObject(container2);
    }

    public static boolean isSimpleFinalProperty(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(15);
        }
        return !DescriptorUtils.isExtension(propertyDescriptor) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter()) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)propertyDescriptor) && !ModalityKt.isOverridableOrOverrides(propertyDescriptor);
    }

    @NotNull
    public static String getModuleName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(16);
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(JsDescriptorUtils.findRealInlineDeclaration(descriptor2));
        String moduleName = moduleDescriptor.getName().asString();
        String string = moduleName.substring(1, moduleName.length() - 1);
        if (string == null) {
            JsDescriptorUtils.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static DeclarationDescriptor findRealInlineDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(18);
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor d = (FunctionDescriptor)descriptor2;
            if (d.getKind().isReal() || !d.isInline()) {
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor == null) {
                    JsDescriptorUtils.$$$reportNull$$$0(19);
                }
                return declarationDescriptor;
            }
            FunctionDescriptor real = JsDescriptorUtils.findRealDeclaration(d);
            assert (real != null) : "Couldn't find definition of a fake inline descriptor " + descriptor2;
            FunctionDescriptor functionDescriptor = real;
            if (functionDescriptor == null) {
                JsDescriptorUtils.$$$reportNull$$$0(20);
            }
            return functionDescriptor;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(21);
        }
        return declarationDescriptor;
    }

    @Nullable
    private static FunctionDescriptor findRealDeclaration(FunctionDescriptor descriptor2) {
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        if (descriptor2.getKind().isReal()) {
            return descriptor2;
        }
        for (FunctionDescriptor functionDescriptor : descriptor2.getOverriddenDescriptors()) {
            FunctionDescriptor child = JsDescriptorUtils.findRealDeclaration(functionDescriptor);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static boolean isImmediateSubtypeOfError(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(22);
        }
        if (!JsDescriptorUtils.isExceptionClass(descriptor2)) {
            return false;
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(descriptor2);
        return TypeUtilsKt.isThrowable(superClass.getDefaultType()) || AnnotationsUtils.isNativeObject(superClass);
    }

    public static boolean isExceptionClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(23);
        }
        ModuleDescriptor module = DescriptorUtils.getContainingModule(descriptor2);
        return TypeUtilsKt.isSubtypeOf(descriptor2.getDefaultType(), module.getBuiltIns().getThrowable().getDefaultType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 2: 
            case 6: 
            case 16: 
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclassDescriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverParameter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupertypesWithoutFakes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverParameterForReceiver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationDescriptorForReceiver";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverParameterForDeclaration";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findRealInlineDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "valueParametersCount";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCompareTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclass";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContainingDeclaration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverParameterForReceiver";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationDescriptorForReceiver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sideEffectsPossibleOnRead";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleFinalProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findRealInlineDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isImmediateSubtypeOfError";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

