/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class CompareToTranslator
extends AbstractTranslator {
    @NotNull
    private final KtBinaryExpression expression;

    public static boolean isCompareToCall(@NotNull KtToken operationToken, @Nullable CallableDescriptor operationDescriptor) {
        if (operationToken == null) {
            CompareToTranslator.$$$reportNull$$$0(0);
        }
        if (!OperatorConventions.COMPARISON_OPERATIONS.contains(operationToken) || operationDescriptor == null) {
            return false;
        }
        return JsDescriptorUtils.isCompareTo(operationDescriptor);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            CompareToTranslator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CompareToTranslator.$$$reportNull$$$0(2);
        }
        JsExpression jsExpression = new CompareToTranslator(expression, context).translate();
        if (jsExpression == null) {
            CompareToTranslator.$$$reportNull$$$0(3);
        }
        return jsExpression;
    }

    private CompareToTranslator(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            CompareToTranslator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            CompareToTranslator.$$$reportNull$$$0(5);
        }
        super(context);
        this.expression = expression;
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (descriptor2 != null) : "CompareTo should always have a descriptor";
        assert (OperatorConventions.COMPARISON_OPERATIONS.contains(PsiUtils.getOperationToken(expression))) : ErrorReportingUtils.message(expression, "CompareToTranslator supported only expressions with operation token from COMPARISON_OPERATIONS, expression: " + expression.getText());
    }

    @NotNull
    private JsExpression translate() {
        JsBinaryOperator correspondingOperator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression methodCall = BinaryOperationTranslator.translateAsOverloadedCall(this.expression, this.context());
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(correspondingOperator, methodCall, this.context().program().getNumberLiteral(0));
        if (jsBinaryOperation == null) {
            CompareToTranslator.$$$reportNull$$$0(6);
        }
        return jsBinaryOperation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationToken";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCompareToCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

