/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jline.console;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.jline.console.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyMap {
    private static final Object NULL_FUNCTION = new Object();
    private Object[] mapping = new Object[256];
    private Object anotherKey = null;
    private String name;
    private boolean isViKeyMap;

    public KeyMap(String name, boolean isViKeyMap) {
        this(name, new Object[256], isViKeyMap);
    }

    protected KeyMap(String name, Object[] mapping2, boolean isViKeyMap) {
        this.mapping = mapping2;
        this.name = name;
        this.isViKeyMap = isViKeyMap;
    }

    public boolean isViKeyMap() {
        return this.isViKeyMap;
    }

    public Object getAnotherKey() {
        return this.anotherKey;
    }

    public Object getBound(CharSequence keySeq) {
        if (keySeq != null && keySeq.length() > 0) {
            KeyMap map2 = this;
            for (int i = 0; i < keySeq.length(); ++i) {
                char c = keySeq.charAt(i);
                if (c > '\u00ff') {
                    return Operation.SELF_INSERT;
                }
                if (map2.mapping[c] instanceof KeyMap) {
                    if (i == keySeq.length() - 1) {
                        return map2.mapping[c];
                    }
                } else {
                    return map2.mapping[c];
                }
                map2 = (KeyMap)map2.mapping[c];
            }
        }
        return null;
    }

    public void bind(CharSequence keySeq, Object function2) {
        KeyMap.bind(this, keySeq, function2, false);
    }

    private static void bind(KeyMap map2, CharSequence keySeq, Object function2) {
        KeyMap.bind(map2, keySeq, function2, false);
    }

    private static void bind(KeyMap map2, CharSequence keySeq, Object function2, boolean onlyIfNotBound) {
        if (keySeq != null && keySeq.length() > 0) {
            for (int i = 0; i < keySeq.length(); ++i) {
                char c = keySeq.charAt(i);
                if (c >= map2.mapping.length) {
                    return;
                }
                if (i < keySeq.length() - 1) {
                    if (!(map2.mapping[c] instanceof KeyMap)) {
                        KeyMap m = new KeyMap("anonymous", false);
                        if (map2.mapping[c] != Operation.DO_LOWERCASE_VERSION) {
                            m.anotherKey = map2.mapping[c];
                        }
                        map2.mapping[c] = m;
                    }
                    map2 = (KeyMap)map2.mapping[c];
                    continue;
                }
                if (function2 == null) {
                    function2 = NULL_FUNCTION;
                }
                if (map2.mapping[c] instanceof KeyMap) {
                    map2.anotherKey = function2;
                    continue;
                }
                Object op = map2.mapping[c];
                if (!onlyIfNotBound || op == null || op == Operation.DO_LOWERCASE_VERSION || op == Operation.VI_MOVEMENT_MODE) {
                    // empty if block
                }
                map2.mapping[c] = function2;
            }
        }
    }

    public void setBlinkMatchingParen(boolean on) {
        if (on) {
            this.bind("}", (Object)Operation.INSERT_CLOSE_CURLY);
            this.bind(")", (Object)Operation.INSERT_CLOSE_PAREN);
            this.bind("]", (Object)Operation.INSERT_CLOSE_SQUARE);
        }
    }

    private static void bindArrowKeys(KeyMap map2) {
        KeyMap.bind(map2, "\u001b[0A", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u001b[0B", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map2, "\u001b[0C", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map2, "\u001b[0D", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map2, "\u00e0\u0000", (Object)Operation.KILL_WHOLE_LINE);
        KeyMap.bind(map2, "\u00e0G", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map2, "\u00e0H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u00e0I", (Object)Operation.BEGINNING_OF_HISTORY);
        KeyMap.bind(map2, "\u00e0K", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map2, "\u00e0M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map2, "\u00e0O", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map2, "\u00e0P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map2, "\u00e0Q", (Object)Operation.END_OF_HISTORY);
        KeyMap.bind(map2, "\u00e0R", (Object)Operation.OVERWRITE_MODE);
        KeyMap.bind(map2, "\u00e0S", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(map2, "\u0000G", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map2, "\u0000H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u0000I", (Object)Operation.BEGINNING_OF_HISTORY);
        KeyMap.bind(map2, "\u0000H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u0000K", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map2, "\u0000M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map2, "\u0000O", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map2, "\u0000P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map2, "\u0000Q", (Object)Operation.END_OF_HISTORY);
        KeyMap.bind(map2, "\u0000R", (Object)Operation.OVERWRITE_MODE);
        KeyMap.bind(map2, "\u0000S", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(map2, "\u001b[A", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u001b[B", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map2, "\u001b[C", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map2, "\u001b[D", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map2, "\u001b[H", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map2, "\u001b[F", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map2, "\u001bOA", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u001bOB", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map2, "\u001bOC", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map2, "\u001bOD", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map2, "\u001bOH", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map2, "\u001bOF", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map2, "\u001b[1~", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map2, "\u001b[4~", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map2, "\u001b[3~", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(map2, "\u001c0H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map2, "\u001c0P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map2, "\u001c0M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map2, "\u001c0K", (Object)Operation.BACKWARD_CHAR);
    }

    public static Map<String, KeyMap> keyMaps() {
        HashMap<String, KeyMap> keyMaps = new HashMap<String, KeyMap>();
        KeyMap emacs = KeyMap.emacs();
        KeyMap.bindArrowKeys(emacs);
        keyMaps.put("emacs", emacs);
        keyMaps.put("emacs-standard", emacs);
        keyMaps.put("emacs-ctlx", (KeyMap)emacs.getBound("\u0018"));
        keyMaps.put("emacs-meta", (KeyMap)emacs.getBound("\u001b"));
        KeyMap viMov = KeyMap.viMovement();
        KeyMap.bindArrowKeys(viMov);
        keyMaps.put("vi-move", viMov);
        keyMaps.put("vi-command", viMov);
        KeyMap viIns = KeyMap.viInsertion();
        KeyMap.bindArrowKeys(viIns);
        keyMaps.put("vi-insert", viIns);
        keyMaps.put("vi", viIns);
        return keyMaps;
    }

    public static KeyMap emacs() {
        Object[] map2 = new Object[256];
        Object[] ctrl = new Object[]{Operation.SET_MARK, Operation.BEGINNING_OF_LINE, Operation.BACKWARD_CHAR, Operation.INTERRUPT, Operation.EXIT_OR_DELETE_CHAR, Operation.END_OF_LINE, Operation.FORWARD_CHAR, Operation.ABORT, Operation.BACKWARD_DELETE_CHAR, Operation.COMPLETE, Operation.ACCEPT_LINE, Operation.KILL_LINE, Operation.CLEAR_SCREEN, Operation.ACCEPT_LINE, Operation.NEXT_HISTORY, null, Operation.PREVIOUS_HISTORY, Operation.QUOTED_INSERT, Operation.REVERSE_SEARCH_HISTORY, Operation.FORWARD_SEARCH_HISTORY, Operation.TRANSPOSE_CHARS, Operation.UNIX_LINE_DISCARD, Operation.QUOTED_INSERT, Operation.UNIX_WORD_RUBOUT, KeyMap.emacsCtrlX(), Operation.YANK, null, KeyMap.emacsMeta(), null, Operation.CHARACTER_SEARCH, null, Operation.UNDO};
        System.arraycopy(ctrl, 0, map2, 0, ctrl.length);
        for (int i = 32; i < 256; ++i) {
            map2[i] = Operation.SELF_INSERT;
        }
        map2[127] = Operation.BACKWARD_DELETE_CHAR;
        return new KeyMap("emacs", map2, false);
    }

    public static KeyMap emacsCtrlX() {
        Object[] map2 = new Object[256];
        map2[7] = Operation.ABORT;
        map2[18] = Operation.RE_READ_INIT_FILE;
        map2[21] = Operation.UNDO;
        map2[24] = Operation.EXCHANGE_POINT_AND_MARK;
        map2[40] = Operation.START_KBD_MACRO;
        map2[41] = Operation.END_KBD_MACRO;
        for (int i = 65; i <= 90; ++i) {
            map2[i] = Operation.DO_LOWERCASE_VERSION;
        }
        map2[101] = Operation.CALL_LAST_KBD_MACRO;
        map2[127] = Operation.KILL_LINE;
        return new KeyMap("emacs-ctlx", map2, false);
    }

    public static KeyMap emacsMeta() {
        Object[] map2 = new Object[256];
        map2[7] = Operation.ABORT;
        map2[8] = Operation.BACKWARD_KILL_WORD;
        map2[9] = Operation.TAB_INSERT;
        map2[10] = Operation.VI_EDITING_MODE;
        map2[13] = Operation.VI_EDITING_MODE;
        map2[18] = Operation.REVERT_LINE;
        map2[25] = Operation.YANK_NTH_ARG;
        map2[27] = Operation.COMPLETE;
        map2[29] = Operation.CHARACTER_SEARCH_BACKWARD;
        map2[32] = Operation.SET_MARK;
        map2[35] = Operation.INSERT_COMMENT;
        map2[38] = Operation.TILDE_EXPAND;
        map2[42] = Operation.INSERT_COMPLETIONS;
        map2[45] = Operation.DIGIT_ARGUMENT;
        map2[46] = Operation.YANK_LAST_ARG;
        map2[60] = Operation.BEGINNING_OF_HISTORY;
        map2[61] = Operation.POSSIBLE_COMPLETIONS;
        map2[62] = Operation.END_OF_HISTORY;
        map2[63] = Operation.POSSIBLE_COMPLETIONS;
        for (int i = 65; i <= 90; ++i) {
            map2[i] = Operation.DO_LOWERCASE_VERSION;
        }
        map2[92] = Operation.DELETE_HORIZONTAL_SPACE;
        map2[95] = Operation.YANK_LAST_ARG;
        map2[98] = Operation.BACKWARD_WORD;
        map2[99] = Operation.CAPITALIZE_WORD;
        map2[100] = Operation.KILL_WORD;
        map2[102] = Operation.FORWARD_WORD;
        map2[108] = Operation.DOWNCASE_WORD;
        map2[112] = Operation.NON_INCREMENTAL_REVERSE_SEARCH_HISTORY;
        map2[114] = Operation.REVERT_LINE;
        map2[116] = Operation.TRANSPOSE_WORDS;
        map2[117] = Operation.UPCASE_WORD;
        map2[121] = Operation.YANK_POP;
        map2[126] = Operation.TILDE_EXPAND;
        map2[127] = Operation.BACKWARD_KILL_WORD;
        return new KeyMap("emacs-meta", map2, false);
    }

    public static KeyMap viInsertion() {
        Object[] map2 = new Object[256];
        Object[] ctrl = new Object[]{null, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.VI_EOF_MAYBE, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.BACKWARD_DELETE_CHAR, Operation.COMPLETE, Operation.ACCEPT_LINE, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.ACCEPT_LINE, Operation.MENU_COMPLETE, Operation.SELF_INSERT, Operation.MENU_COMPLETE_BACKWARD, Operation.SELF_INSERT, Operation.REVERSE_SEARCH_HISTORY, Operation.FORWARD_SEARCH_HISTORY, Operation.TRANSPOSE_CHARS, Operation.UNIX_LINE_DISCARD, Operation.QUOTED_INSERT, Operation.UNIX_WORD_RUBOUT, Operation.SELF_INSERT, Operation.YANK, Operation.SELF_INSERT, Operation.VI_MOVEMENT_MODE, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.UNDO};
        System.arraycopy(ctrl, 0, map2, 0, ctrl.length);
        for (int i = 32; i < 256; ++i) {
            map2[i] = Operation.SELF_INSERT;
        }
        map2[127] = Operation.BACKWARD_DELETE_CHAR;
        return new KeyMap("vi-insert", map2, false);
    }

    public static KeyMap viMovement() {
        Object[] map2 = new Object[256];
        Object[] low = new Object[]{null, null, null, Operation.INTERRUPT, Operation.VI_EOF_MAYBE, Operation.EMACS_EDITING_MODE, null, Operation.ABORT, Operation.BACKWARD_CHAR, null, Operation.VI_MOVE_ACCEPT_LINE, Operation.KILL_LINE, Operation.CLEAR_SCREEN, Operation.VI_MOVE_ACCEPT_LINE, Operation.VI_NEXT_HISTORY, null, Operation.VI_PREVIOUS_HISTORY, Operation.QUOTED_INSERT, Operation.REVERSE_SEARCH_HISTORY, Operation.FORWARD_SEARCH_HISTORY, Operation.TRANSPOSE_CHARS, Operation.UNIX_LINE_DISCARD, Operation.QUOTED_INSERT, Operation.UNIX_WORD_RUBOUT, null, Operation.YANK, null, KeyMap.emacsMeta(), null, Operation.CHARACTER_SEARCH, null, Operation.UNDO, Operation.FORWARD_CHAR, null, null, Operation.VI_INSERT_COMMENT, Operation.END_OF_LINE, Operation.VI_MATCH, Operation.VI_TILDE_EXPAND, null, null, null, Operation.VI_COMPLETE, Operation.VI_NEXT_HISTORY, Operation.VI_CHAR_SEARCH, Operation.VI_PREVIOUS_HISTORY, Operation.VI_REDO, Operation.VI_SEARCH, Operation.VI_BEGNNING_OF_LINE_OR_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, null, Operation.VI_CHAR_SEARCH, null, Operation.VI_COMPLETE, null, Operation.VI_SEARCH, null, Operation.VI_APPEND_EOL, Operation.VI_PREV_WORD, Operation.VI_CHANGE_TO_EOL, Operation.VI_DELETE_TO_EOL, Operation.VI_END_WORD, Operation.VI_CHAR_SEARCH, Operation.VI_FETCH_HISTORY, null, Operation.VI_INSERT_BEG, null, null, null, null, Operation.VI_SEARCH_AGAIN, null, Operation.VI_PUT, null, Operation.VI_REPLACE, Operation.VI_KILL_WHOLE_LINE, Operation.VI_CHAR_SEARCH, Operation.REVERT_LINE, null, Operation.VI_NEXT_WORD, Operation.VI_RUBOUT, Operation.VI_YANK_TO, null, null, Operation.VI_COMPLETE, null, Operation.VI_FIRST_PRINT, Operation.VI_YANK_ARG, Operation.VI_GOTO_MARK, Operation.VI_APPEND_MODE, Operation.VI_PREV_WORD, Operation.VI_CHANGE_TO, Operation.VI_DELETE_TO, Operation.VI_END_WORD, Operation.VI_CHAR_SEARCH, null, Operation.BACKWARD_CHAR, Operation.VI_INSERTION_MODE, Operation.NEXT_HISTORY, Operation.PREVIOUS_HISTORY, Operation.FORWARD_CHAR, Operation.VI_SET_MARK, Operation.VI_SEARCH_AGAIN, null, Operation.VI_PUT, null, Operation.VI_CHANGE_CHAR, Operation.VI_SUBST, Operation.VI_CHAR_SEARCH, Operation.UNDO, null, Operation.VI_NEXT_WORD, Operation.VI_DELETE, Operation.VI_YANK_TO, null, null, Operation.VI_COLUMN, null, Operation.VI_CHANGE_CASE, Operation.VI_DELETE};
        System.arraycopy(low, 0, map2, 0, low.length);
        for (int i = 128; i < 256; ++i) {
            map2[i] = null;
        }
        return new KeyMap("vi-move", map2, false);
    }
}

