/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.icons.AllIcons;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.AnalysisCanceledException;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlow;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowFactory;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowPolicy;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class PsiLambdaExpressionImpl
extends JavaStubPsiElement<FunctionalExpressionStub<PsiLambdaExpression>>
implements PsiLambdaExpression {
    private static final ControlFlowPolicy ourPolicy = new ControlFlowPolicy(){

        @Override
        @Nullable
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl$1", "getUsedVariable"));
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            if (psiParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl$1", "isParameterAccepted"));
            }
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            if (psiVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl$1", "isLocalVariableAccepted"));
            }
            return true;
        }
    };

    public PsiLambdaExpressionImpl(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "<init>"));
        }
        super(stub, JavaStubElementTypes.LAMBDA_EXPRESSION);
    }

    public PsiLambdaExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = PsiTreeUtil.getRequiredChildOfType(this, PsiParameterList.class);
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "getParameterList"));
        }
        return psiParameterList;
    }

    @Override
    public PsiElement getBody() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiExpression || element instanceof PsiCodeBlock ? element : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true), this);
    }

    @Override
    public boolean isVoidCompatible() {
        PsiElement body = this.getBody();
        if (body instanceof PsiCodeBlock) {
            for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiCodeBlock)body)) {
                if (statement.getReturnValue() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValueCompatible() {
        Boolean result2 = MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(this, false, () -> this.isValueCompatibleNoCache());
        return result2 != null && result2 != false;
    }

    private boolean isValueCompatibleNoCache() {
        PsiElement body = this.getBody();
        if (body instanceof PsiCodeBlock) {
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow(body, ourPolicy, false, false);
                int startOffset = controlFlow.getStartOffset(body);
                int endOffset = controlFlow.getEndOffset(body);
                if (startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset)) {
                    return false;
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
            for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiCodeBlock)body)) {
                if (statement.getReturnValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PsiType getType() {
        return new PsiLambdaExpressionType(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLambdaExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        return PsiImplUtil.processDeclarationsInLambda(this, processor, state2, lastParent, place);
    }

    @Override
    public String toString() {
        return "PsiLambdaExpression";
    }

    @Override
    public boolean hasFormalParameterTypes() {
        PsiParameter[] parameters2;
        for (PsiParameter parameter : parameters2 = this.getParameterList().getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAcceptable(PsiType leftType) {
        PsiType methodReturnType;
        MethodCandidateInfo.CurrentCandidateProperties candidateProperties;
        if (leftType instanceof PsiIntersectionType) {
            for (PsiType conjunctType : ((PsiIntersectionType)leftType).getConjuncts()) {
                if (!this.isAcceptable(conjunctType)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && (candidateProperties = MethodCandidateInfo.getCurrentMethod(argsList)) != null) {
            PsiMethod method = candidateProperties.getMethod();
            if (this.hasFormalParameterTypes() && !InferenceSession.isPertinentToApplicability(this, method)) {
                return true;
            }
            if (LambdaUtil.isPotentiallyCompatibleWithTypeParameter(this, argsList, method)) {
                return true;
            }
        }
        if (!this.isPotentiallyCompatible(leftType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(leftType, this))) {
            return false;
        }
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList) && !this.hasFormalParameterTypes()) {
            return true;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(leftType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        if (interfaceMethod.hasTypeParameters()) {
            return false;
        }
        PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        if (this.hasFormalParameterTypes()) {
            PsiParameter[] lambdaParameters = this.getParameterList().getParameters();
            PsiType[] parameterTypes = interfaceMethod.getSignature(substitutor2).getParameterTypes();
            int length = lambdaParameters.length;
            for (int lambdaParamIdx = 0; lambdaParamIdx < length; ++lambdaParamIdx) {
                PsiType methodParameterType;
                PsiType lambdaFormalType;
                PsiParameter parameter = lambdaParameters[lambdaParamIdx];
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null || (lambdaFormalType = PsiLambdaExpressionImpl.toArray(parameter.getType())).equals(methodParameterType = PsiLambdaExpressionImpl.toArray(parameterTypes[lambdaParamIdx]))) continue;
                return false;
            }
        }
        if ((methodReturnType = interfaceMethod.getReturnType()) != null && !PsiType.VOID.equals(methodReturnType)) {
            Map<PsiElement, PsiType> map2 = LambdaUtil.getFunctionalTypeMap();
            try {
                boolean bl;
                if (map2.put(this, leftType) != null) {
                    bl = false;
                    return bl;
                }
                bl = LambdaUtil.checkReturnTypeCompatible(this, substitutor2.substitute(methodReturnType)) == null;
                return bl;
            }
            finally {
                map2.remove(this);
            }
        }
        return true;
    }

    @Override
    public boolean isPotentiallyCompatible(PsiType left) {
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(left);
        if (interfaceMethod == null) {
            return false;
        }
        if (this.getParameterList().getParametersCount() != interfaceMethod.getParameterList().getParametersCount()) {
            return false;
        }
        PsiType methodReturnType = interfaceMethod.getReturnType();
        PsiElement body = this.getBody();
        if (PsiType.VOID.equals(methodReturnType)) {
            if (body instanceof PsiCodeBlock) {
                return this.isVoidCompatible();
            }
            return LambdaUtil.isExpressionStatementExpression(body);
        }
        return body instanceof PsiCodeBlock && this.isValueCompatible() || body instanceof PsiExpression;
    }

    private static PsiType toArray(PsiType paramType) {
        if (paramType instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)paramType).toArrayType();
        }
        return paramType;
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Function;
    }
}

