/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public abstract class ClassBodyCodegen
extends MemberCodegen<KtPureClassOrObject> {
    public final KtPureClassOrObject myClass;
    public final OwnerKind kind;
    public final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull KtPureClassOrObject myClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        if (myClass == null) {
            ClassBodyCodegen.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ClassBodyCodegen.$$$reportNull$$$0(1);
        }
        if (v == null) {
            ClassBodyCodegen.$$$reportNull$$$0(2);
        }
        if (state2 == null) {
            ClassBodyCodegen.$$$reportNull$$$0(3);
        }
        super(state2, parentCodegen, context, myClass, v);
        this.myClass = myClass;
        this.kind = context.getContextKind();
        this.descriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(myClass, this.bindingContext);
    }

    @Override
    protected void generateBody() {
        ArrayList<KtObjectDeclaration> companions = new ArrayList<KtObjectDeclaration>();
        if (this.kind != OwnerKind.DEFAULT_IMPLS) {
            for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
                if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                    companions.add((KtObjectDeclaration)ktDeclaration);
                    CodegenUtilKt.populateCompanionBackingFieldNamesToOuterContextIfNeeded((KtObjectDeclaration)ktDeclaration, this.context, this.state);
                    continue;
                }
                this.generateDeclaration(ktDeclaration);
            }
        }
        for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
            this.generateDeclaration(ktDeclaration);
        }
        boolean generateNonClassMembers = this.shouldGenerateNonClassMembers();
        if (generateNonClassMembers) {
            this.generatePrimaryConstructorProperties();
            this.generateConstructors();
            this.generateDefaultImplsIfNeeded();
        }
        for (KtObjectDeclaration companion : companions) {
            this.genClassOrObject(companion);
        }
        ClassDescriptor classDescriptor = this.descriptor.getCompanionObjectDescriptor();
        if (classDescriptor instanceof SyntheticClassOrObjectDescriptor) {
            this.genSyntheticClassOrObject((SyntheticClassOrObjectDescriptor)classDescriptor);
        }
        if (generateNonClassMembers) {
            this.generateBridges();
        }
    }

    private void generateBridges() {
        if (DescriptorUtils.isInterface(this.descriptor)) {
            return;
        }
        for (DeclarationDescriptor memberDescriptor : DescriptorUtils.getAllDescriptors(this.descriptor.getDefaultType().getMemberScope())) {
            PropertySetterDescriptor setter2;
            CallableMemberDescriptor member;
            if (!(memberDescriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)memberDescriptor).getKind().isReal() || ImplKt.findInterfaceImplementation(member) != null) continue;
            if (member instanceof FunctionDescriptor) {
                this.functionCodegen.generateBridges((FunctionDescriptor)member);
                continue;
            }
            if (!(member instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)member).getGetter();
            if (getter2 != null) {
                this.functionCodegen.generateBridges(getter2);
            }
            if ((setter2 = ((PropertyDescriptor)member).getSetter()) == null) continue;
            this.functionCodegen.generateBridges(setter2);
        }
    }

    private boolean shouldGenerateNonClassMembers() {
        return !(this.myClass instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.myClass);
    }

    protected void generateConstructors() {
    }

    protected void generateDefaultImplsIfNeeded() {
    }

    private static boolean shouldProcessFirst(KtDeclaration declaration) {
        return !(declaration instanceof KtProperty) && !(declaration instanceof KtNamedFunction);
    }

    protected void generateDeclaration(KtDeclaration declaration) {
        if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction || declaration instanceof KtTypeAlias) {
            if (this.shouldGenerateNonClassMembers()) {
                this.genSimpleMember(declaration);
            }
        } else if (declaration instanceof KtClassOrObject) {
            if (declaration instanceof KtEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject((KtClassOrObject)declaration);
        }
    }

    private void generatePrimaryConstructorProperties() {
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        for (KtParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                this.propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
                continue;
            }
            this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor);
        }
    }

    @NotNull
    protected List<KtParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof KtClass) {
            List<KtParameter> list2 = this.myClass.getPrimaryConstructorParameters();
            if (list2 == null) {
                ClassBodyCodegen.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<KtParameter> list3 = Collections.emptyList();
        if (list3 == null) {
            ClassBodyCodegen.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return DescriptorUtils.isTopLevelDeclaration(this.descriptor) ? null : this.descriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ClassBodyCodegen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClassBodyCodegen";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryConstructorParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

