/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.DefaultValues;
import org.jetbrains.kotlin.cli.common.arguments.GradleOption;
import org.jetbrains.kotlin.cli.common.arguments.ValueDescription;
import org.jetbrains.kotlin.cli.common.parser.com.sampullara.cli.Argument;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public abstract class CommonCompilerArguments
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final String PLUGIN_OPTION_FORMAT = "plugin:<pluginId>:<optionName>=<value>";
    @GradleOption(value=DefaultValues.LanguageVersions.class)
    @Argument(value="language-version", description="Provide source compatibility with specified language version")
    @ValueDescription(value="<version>")
    public String languageVersion;
    @GradleOption(value=DefaultValues.LanguageVersions.class)
    @Argument(value="api-version", description="Allow to use declarations only from the specified version of bundled libraries")
    @ValueDescription(value="<version>")
    public String apiVersion;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="nowarn", description="Generate no warnings")
    public boolean suppressWarnings;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="verbose", description="Enable verbose logging output")
    public boolean verbose;
    @Argument(value="version", description="Display compiler version")
    public boolean version;
    @Argument(value="help", alias="h", description="Print a synopsis of standard options")
    public boolean help;
    @Argument(value="X", description="Print a synopsis of advanced options")
    public boolean extraHelp;
    @Argument(value="Xno-inline", description="Disable method inlining")
    public boolean noInline;
    @Argument(value="Xrepeat", description="Repeat compilation (for performance analysis)")
    @ValueDescription(value="<count>")
    public String repeat;
    @Argument(value="Xskip-metadata-version-check", description="Load classes with bad metadata version anyway (incl. pre-release classes)")
    public boolean skipMetadataVersionCheck;
    @Argument(value="Xallow-kotlin-package", description="Allow compiling code in package 'kotlin'")
    public boolean allowKotlinPackage;
    @Argument(value="Xplugin", description="Load plugins from the given classpath")
    @ValueDescription(value="<path>")
    public String[] pluginClasspaths;
    @Argument(value="Xmulti-platform", description="Enable experimental language support for multi-platform projects")
    public boolean multiPlatform;
    @Argument(value="Xno-check-impl", description="Do not check presence of 'impl' modifier in multi-platform projects")
    public boolean noCheckImpl;
    @Argument(value="Xskip-java-check", description="Do not warn when running the compiler under Java 6 or 7")
    public boolean noJavaVersionWarning;
    @Argument(value="Xcoroutines=warn")
    public boolean coroutinesWarn;
    @Argument(value="Xcoroutines=error")
    public boolean coroutinesError;
    @Argument(value="Xcoroutines=enable")
    public boolean coroutinesEnable;
    @Argument(value="P", description="Pass an option to a plugin")
    @ValueDescription(value="plugin:<pluginId>:<optionName>=<value>")
    public String[] pluginOptions;
    public List<String> freeArgs = new SmartList<String>();
    public List<String> unknownExtraFlags = new SmartList<String>();

    @NotNull
    public static CommonCompilerArguments createDefaultInstance() {
        DummyImpl arguments2 = new DummyImpl();
        arguments2.coroutinesEnable = false;
        arguments2.coroutinesWarn = true;
        arguments2.coroutinesError = false;
        DummyImpl dummyImpl = arguments2;
        if (dummyImpl == null) {
            CommonCompilerArguments.$$$reportNull$$$0(0);
        }
        return dummyImpl;
    }

    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc" == null) {
            CommonCompilerArguments.$$$reportNull$$$0(1);
        }
        return "kotlinc";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "executableScriptFileName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class DummyImpl
    extends CommonCompilerArguments {
    }
}

