/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.jvm;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.JvmNameResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.ClassMapperLite;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J)\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020!2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0007\u00a2\u0006\u0002\u0010\"J#\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0007\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil;", "", "()V", "EXTENSION_REGISTRY", "Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "getEXTENSION_REGISTRY", "()Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "getJvmConstructorSignature", "", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Constructor;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "getJvmFieldSignature", "Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil$PropertySignature;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Property;", "getJvmMethodSignature", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "mapTypeDefault", "type", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Type;", "readClassDataFrom", "Lorg/jetbrains/kotlin/serialization/ClassData;", "data", "", "strings", "([Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/ClassData;", "bytes", "", "([B[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/ClassData;", "readPackageDataFrom", "Lorg/jetbrains/kotlin/serialization/PackageData;", "([Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/PackageData;", "([B[Ljava/lang/String;)Lorg/jetbrains/kotlin/serialization/PackageData;", "PropertySignature", "kotlin-compiler"})
public final class JvmProtoBufUtil {
    @NotNull
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;
    public static final JvmProtoBufUtil INSTANCE;

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final ClassData readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(stringTableTypes, "JvmProtoBuf.StringTableT\u2026nput, EXTENSION_REGISTRY)");
        JvmNameResolver nameResolver = new JvmNameResolver(stringTableTypes, strings);
        ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.Class clazz = classProto;
        Intrinsics.checkExpressionValueIsNotNull(clazz, "classProto");
        return new ClassData(nameResolver2, clazz);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull String[] data2, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data2);
        Intrinsics.checkExpressionValueIsNotNull(byArray, "BitEncoding.decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
    }

    @JvmStatic
    @NotNull
    public static final PackageData readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        Intrinsics.checkParameterIsNotNull(strings, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom(input, EXTENSION_REGISTRY);
        Intrinsics.checkExpressionValueIsNotNull(stringTableTypes, "JvmProtoBuf.StringTableT\u2026nput, EXTENSION_REGISTRY)");
        JvmNameResolver nameResolver = new JvmNameResolver(stringTableTypes, strings);
        ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY);
        NameResolver nameResolver2 = nameResolver;
        ProtoBuf.Package package_ = packageProto;
        Intrinsics.checkExpressionValueIsNotNull(package_, "packageProto");
        return new PackageData(nameResolver2, package_);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name2;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        JvmProtoBuf.JvmMethodSignature signature2 = proto.hasExtension(JvmProtoBuf.methodSignature) ? proto.getExtension(JvmProtoBuf.methodSignature) : null;
        int n = name2 = signature2 != null && signature2.hasName() ? signature2.getName() : proto.getName();
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $receiver$iv$iv;
            Object object;
            void $receiver$iv$iv2;
            void $receiver$iv;
            Iterable iterable = proto.getValueParameterList();
            Collection collection = CollectionsKt.singletonOrEmptyList(ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            void var8_8 = $receiver$iv;
            Iterable destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                object = destination$iv$iv;
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable);
                object.add(type2);
            }
            object = (List)destination$iv$iv;
            List parameterTypes = kotlin.collections.CollectionsKt.plus(collection, (Iterable)object);
            Iterable $receiver$iv2 = parameterTypes;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ProtoBuf.Type $i$a$1$map = (ProtoBuf.Type)item$iv$iv;
                collection = destination$iv$iv2;
                if (INSTANCE.mapTypeDefault((ProtoBuf.Type)it, nameResolver) == null) {
                    return null;
                }
                collection.add(object);
            }
            List parametersDesc = (List)destination$iv$iv2;
            String string2 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string2 == null) {
                return null;
            }
            String returnTypeDesc = string2;
            string = kotlin.collections.CollectionsKt.joinToString$default(parametersDesc, "", "(", ")", 0, null, null, 56, null) + returnTypeDesc;
        }
        String desc = string;
        return nameResolver.getString(name2) + desc;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        JvmProtoBuf.JvmMethodSignature signature2;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = signature2 = proto.hasExtension(JvmProtoBuf.constructorSignature) ? proto.getExtension(JvmProtoBuf.constructorSignature) : null;
        if (signature2 != null && signature2.hasDesc()) {
            string = nameResolver.getString(signature2.getDesc());
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)proto.getValueParameterList();
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string2;
                void it;
                ProtoBuf.ValueParameter valueParameter = (ProtoBuf.ValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                if (INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable), nameResolver) == null) {
                    return null;
                }
                collection.add(string2);
            }
            string = kotlin.collections.CollectionsKt.joinToString$default((List)destination$iv$iv, "", "(", ")V", 0, null, null, 56, null);
        }
        String desc = string;
        return "<init>" + desc;
    }

    @Nullable
    public final PropertySignature getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name2;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
        if (!proto.hasExtension(JvmProtoBuf.propertySignature)) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature2 = proto.getExtension(JvmProtoBuf.propertySignature);
        JvmProtoBuf.JvmFieldSignature field = signature2.hasField() ? signature2.getField() : null;
        int n = name2 = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String desc = string;
        String string2 = nameResolver.getString(name2);
        Intrinsics.checkExpressionValueIsNotNull(string2, "nameResolver.getString(name)");
        String string3 = desc;
        Intrinsics.checkExpressionValueIsNotNull(string3, "desc");
        return new PropertySignature(string2, string3);
    }

    private final String mapTypeDefault(ProtoBuf.Type type2, NameResolver nameResolver) {
        String string;
        if (type2.hasClassName()) {
            ClassId classId = nameResolver.getClassId(type2.getClassName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(type.className)");
            string = ClassMapperLite.mapClass(classId);
        } else {
            string = null;
        }
        return string;
    }

    private JvmProtoBufUtil() {
        JvmProtoBufUtil jvmProtoBufUtil;
        INSTANCE = this;
        JvmProtoBufUtil $receiver = jvmProtoBufUtil = this;
        ExtensionRegistryLite registry = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(registry);
        ExtensionRegistryLite extensionRegistryLite = registry;
        Intrinsics.checkExpressionValueIsNotNull(extensionRegistryLite, "registry");
        Intrinsics.checkExpressionValueIsNotNull(extensionRegistryLite, "run {\n        val regist\u2026y)\n        registry\n    }");
        EXTENSION_REGISTRY = extensionRegistryLite;
    }

    static {
        new JvmProtoBufUtil();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/serialization/jvm/JvmProtoBufUtil$PropertySignature;", "", "name", "", "desc", "(Ljava/lang/String;Ljava/lang/String;)V", "getDesc", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-compiler"})
    public static final class PropertySignature {
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDesc() {
            return this.desc;
        }

        public PropertySignature(@NotNull String name2, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull(name2, "name");
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            this.name = name2;
            this.desc = desc;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.desc;
        }

        @NotNull
        public final PropertySignature copy(@NotNull String name2, @NotNull String desc) {
            Intrinsics.checkParameterIsNotNull(name2, "name");
            Intrinsics.checkParameterIsNotNull(desc, "desc");
            return new PropertySignature(name2, desc);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ PropertySignature copy$default(PropertySignature propertySignature, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = propertySignature.name;
            }
            if ((n & 2) != 0) {
                string2 = propertySignature.desc;
            }
            return propertySignature.copy(string, string2);
        }

        public String toString() {
            return "PropertySignature(name=" + this.name + ", desc=" + this.desc + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.desc;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertySignature)) break block3;
                    PropertySignature propertySignature = (PropertySignature)object;
                    if (!Intrinsics.areEqual(this.name, propertySignature.name) || !Intrinsics.areEqual(this.desc, propertySignature.desc)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

