/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.SuperCallReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "kotlin-compiler"})
public interface ExpressionReceiver
extends ReceiverValue {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtExpression getExpression();

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "ExpressionReceiverImpl", "SuperExpressionReceiver", "ThisExpressionClassReceiver", "kotlin-compiler"})
    public static final class Companion {
        @NotNull
        public final ExpressionReceiver create(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            KtReferenceExpression referenceExpression = null;
            if (expression instanceof KtThisExpression) {
                referenceExpression = ((KtThisExpression)expression).getInstanceReference();
            } else if (expression instanceof KtConstructorDelegationReferenceExpression) {
                referenceExpression = (KtReferenceExpression)expression;
            }
            if (referenceExpression != null) {
                DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
                if (descriptor2 instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.original");
                    return new ThisExpressionClassReceiver(classDescriptor, expression, type2);
                }
            } else if (expression instanceof KtSuperExpression) {
                KotlinType kotlinType = (KotlinType)bindingContext.get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression);
                if (kotlinType != null) {
                    KotlinType kotlinType2;
                    KotlinType thisType;
                    KotlinType kotlinType3 = thisType = (kotlinType2 = kotlinType);
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "thisType");
                    return new SuperExpressionReceiver(kotlinType3, expression, type2);
                }
            }
            return new ExpressionReceiverImpl(expression, type2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "toString", "", "kotlin-compiler"})
        private static class ExpressionReceiverImpl
        extends AbstractReceiverValue
        implements ExpressionReceiver {
            @NotNull
            private final KtExpression expression;

            @NotNull
            public String toString() {
                return this.getType() + " {" + this.getExpression() + ": " + this.getExpression().getText() + "}";
            }

            @Override
            @NotNull
            public KtExpression getExpression() {
                return this.expression;
            }

            public ExpressionReceiverImpl(@NotNull KtExpression expression, @NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(type2);
                this.expression = expression;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ThisExpressionClassReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ThisClassReceiver;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-compiler"})
        private static final class ThisExpressionClassReceiver
        extends ExpressionReceiverImpl
        implements ThisClassReceiver {
            @NotNull
            private final ClassDescriptor classDescriptor;

            @Override
            @NotNull
            public ClassDescriptor getClassDescriptor() {
                return this.classDescriptor;
            }

            public ThisExpressionClassReceiver(@NotNull ClassDescriptor classDescriptor, @NotNull KtExpression expression, @NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(expression, type2);
                this.classDescriptor = classDescriptor;
            }
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$SuperExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/SuperCallReceiverValue;", "thisType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getThisType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
        private static final class SuperExpressionReceiver
        extends ExpressionReceiverImpl
        implements SuperCallReceiverValue {
            @NotNull
            private final KotlinType thisType;

            @Override
            @NotNull
            public KotlinType getThisType() {
                return this.thisType;
            }

            public SuperExpressionReceiver(@NotNull KotlinType thisType, @NotNull KtExpression expression, @NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(thisType, "thisType");
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(expression, type2);
                this.thisType = thisType;
            }
        }
    }
}

