/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        JsExpression functionExpression = function2;
        if (InlineUtil.isInline(descriptor2)) {
            InlineMetadata metadata2 = InlineMetadata.compose(function2, descriptor2);
            functionExpression = metadata2.getFunctionWithMetadata();
        }
        if (DescriptorUtils.isExtension(descriptor2) || descriptor2 instanceof PropertyAccessorDescriptor && TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty())) {
            JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(functionExpression, descriptor2, context);
            if (jsPropertyInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
            }
            return jsPropertyInitializer;
        }
        JsStringLiteral getOrSet = context.program().getStringLiteral(TranslationUtils.getAccessorFunctionName(descriptor2));
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(getOrSet, functionExpression);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateFunctionAsEcma5PropertyDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static String getAccessorFunctionName(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getAccessorFunctionName"));
        }
        boolean isGetter = descriptor2 instanceof PropertyGetterDescriptor || descriptor2 instanceof LocalVariableAccessorDescriptor.Getter;
        String string = isGetter ? "get" : "set";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getAccessorFunctionName"));
        }
        return string;
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        JsFunction jsFunction = new JsFunction(functionScope, new JsBlock((JsStatement)new JsReturn(returnExpression)), "<simpleReturnFunction>");
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "simpleReturnFunction"));
        }
        return jsFunction;
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsExpression functionExpression, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(functionExpression, ModalityKt.isOverridable(descriptor2), false);
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(context.getNameForDescriptor(descriptor2).makeRef(), meta);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExtensionFunctionAsEcma5DataDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        if (baseBinaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBinaryExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        JsBinaryOperator negatedOperator = TranslationUtils.notOperator(baseBinaryExpression.getOperator());
        assert (negatedOperator != null) : "Can't negate operator: " + baseBinaryExpression.getOperator();
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(negatedOperator, baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateExclForBinaryEqualLikeExpr"));
        }
        return jsBinaryOperation;
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isEqualLikeOperator"));
        }
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notOperator"));
        }
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, false);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    private static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, true);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isNotNullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        if (expressionToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToCheck", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "nullCheck"));
        }
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, expressionToCheck, JsLiteral.NULL);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "nullCheck"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression, @NotNull JsExpression elseExpression, @NotNull TranslationContext context) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (elseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseExpression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        if (TranslationUtils.isCacheNeeded(expression)) {
            TemporaryConstVariable tempVar = context.getOrDeclareTemporaryConstVariable(expression);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression);
            thenExpression = expression;
        }
        JsConditional jsConditional = new JsConditional(testExpression, thenExpression, elseExpression);
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "notNullConditional"));
        }
        return jsConditional;
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2) {
        JsName backingFieldName;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
        JsName jsName = backingFieldName = containingDescriptor instanceof PackageFragmentDescriptor ? context.getInnerNameForDescriptor(descriptor2) : context.getNameForDescriptor(descriptor2);
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2) && !(containingDescriptor instanceof PackageFragmentDescriptor)) {
            backingFieldName = context.getNameForBackingField(descriptor2);
        }
        JsExpression receiver = containingDescriptor instanceof PackageFragmentDescriptor ? null : context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(containingDescriptor));
        JsNameRef jsNameRef = new JsNameRef(backingFieldName, receiver);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "backingFieldReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression assignTo) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        if (assignTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignTo", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor2);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(backingFieldReference, assignTo);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "assignmentToBackingField"));
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull KtProperty declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateInitializerForProperty"));
        }
        JsExpression jsInitExpression = null;
        KtExpression initializer2 = declaration.getInitializer();
        if (initializer2 != null) {
            jsInitExpression = Translation.translateAsExpression(initializer2, context);
            KotlinType propertyType = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, declaration).getType();
            KotlinType initType = context.bindingContext().getType(initializer2);
            if (initType != null && KotlinBuiltIns.isCharOrNullableChar(initType) && !KotlinBuiltIns.isCharOrNullableChar(propertyType)) {
                jsInitExpression = JsAstUtils.charToBoxedChar(jsInitExpression);
            }
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull KtUnaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression);
        JsExpression jsExpression = Translation.translateAsExpression(baseExpression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateBaseExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateLeftExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression, @NotNull JsBlock block) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        KtExpression left = expression.getLeft();
        assert (left != null) : "Binary expression should have a left expression: " + expression.getText();
        JsExpression jsExpression = Translation.translateAsExpression(left, context, block);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateLeftExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        JsExpression jsExpression = TranslationUtils.translateRightExpression(context, expression, context.dynamicContext().jsBlock());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression, @NotNull JsBlock block) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        KtExpression rightExpression = expression.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        JsExpression jsExpression = Translation.translateAsExpression(rightExpression, context, block);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateRightExpression"));
        }
        return jsExpression;
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context, @NotNull KtOperationExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "hasCorrespondingFunctionIntrinsic"));
        }
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null || !(operationDescriptor instanceof FunctionDescriptor)) {
            return true;
        }
        KotlinType returnType = operationDescriptor.getReturnType();
        if (returnType != null && (KotlinBuiltIns.isChar(returnType) || KotlinBuiltIns.isLong(returnType) || KotlinBuiltIns.isInt(returnType))) {
            return false;
        }
        return context.intrinsics().getFunctionIntrinsic((FunctionDescriptor)operationDescriptor).exists();
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<? extends JsExpression> arguments2) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        ArrayList<JsExpression> argumentList2 = new ArrayList<JsExpression>(1 + arguments2.size());
        argumentList2.add(receiver);
        argumentList2.addAll(arguments2);
        ArrayList<JsExpression> arrayList = argumentList2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "generateInvocationArguments"));
        }
        return arrayList;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isCacheNeeded"));
        }
        if (expression instanceof JsLiteral.JsValueLiteral) {
            return false;
        }
        if (expression instanceof JsNameRef && ((JsNameRef)expression).getQualifier() == null) {
            return false;
        }
        if (expression instanceof JsBinaryOperation) {
            JsBinaryOperation operation = (JsBinaryOperation)expression;
            JsBinaryOperator operator = operation.getOperator();
            if (operator.isAssignment() || operator == JsBinaryOperator.COMMA) {
                return true;
            }
            return TranslationUtils.isCacheNeeded(operation.getArg1()) || TranslationUtils.isCacheNeeded(operation.getArg2());
        }
        if (expression instanceof JsUnaryOperation) {
            JsUnaryOperation operation = (JsUnaryOperation)expression;
            JsUnaryOperator operator = operation.getOperator();
            switch (operator) {
                case BIT_NOT: 
                case NEG: 
                case POS: 
                case NOT: 
                case TYPEOF: 
                case VOID: {
                    return TranslationUtils.isCacheNeeded(operation.getArg());
                }
            }
            return true;
        }
        return true;
    }

    @NotNull
    public static JsConditional sure(@NotNull JsExpression expression, @NotNull TranslationContext context) {
        JsName name2;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "sure"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "sure"));
        }
        JsInvocation throwNPE = new JsInvocation(Namer.throwNPEFunctionRef(), new JsExpression[0]);
        JsConditional ensureNotNull = TranslationUtils.notNullConditional(expression, throwNPE, context);
        JsExpression thenExpression = ensureNotNull.getThenExpression();
        if (thenExpression instanceof JsNameRef && (name2 = ((JsNameRef)thenExpression).getName()) != null) {
            context.associateExpressionToLazyValue(ensureNotNull, new TemporaryConstVariable(name2, ensureNotNull));
        }
        JsConditional jsConditional = ensureNotNull;
        if (jsConditional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "sure"));
        }
        return jsConditional;
    }

    public static boolean isSimpleNameExpressionNotDelegatedLocalVar(@Nullable KtExpression expression, @NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isSimpleNameExpressionNotDelegatedLocalVar"));
        }
        if (!(expression instanceof KtSimpleNameExpression)) {
            return false;
        }
        DeclarationDescriptor descriptor2 = context.bindingContext().get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)expression);
        return !(descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated() || descriptor2 instanceof PropertyDescriptor && TranslationUtils.propertyAccessedByFunctionsInternally((PropertyDescriptor)descriptor2, context));
    }

    private static boolean propertyAccessedByFunctionsInternally(@NotNull PropertyDescriptor p, @NotNull TranslationContext context) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "propertyAccessedByFunctionsInternally"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "propertyAccessedByFunctionsInternally"));
        }
        return !JsDescriptorUtils.isSimpleFinalProperty(p) && context.isFromCurrentModule(p) || TranslationUtils.shouldAccessViaFunctions(p);
    }

    public static boolean shouldAccessViaFunctions(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "shouldAccessViaFunctions"));
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions((PropertyDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        return false;
    }

    private static boolean shouldAccessViaFunctions(@NotNull PropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "shouldAccessViaFunctions"));
        }
        if (AnnotationsUtils.hasJsNameInAccessors(property)) {
            return true;
        }
        for (PropertyDescriptor propertyDescriptor : property.getOverriddenDescriptors()) {
            if (!TranslationUtils.shouldAccessViaFunctions(propertyDescriptor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JsExpression translateContinuationArgument(@NotNull TranslationContext context, @NotNull ResolvedCall<?> resolvedCall2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateContinuationArgument"));
        }
        if (resolvedCall2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateContinuationArgument"));
        }
        CallableDescriptor continuationDescriptor = context.bindingContext().get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        if (continuationDescriptor == null) {
            continuationDescriptor = TranslationUtils.getEnclosingContinuationParameter(context);
        }
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(continuationDescriptor, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "translateContinuationArgument"));
        }
        return jsExpression;
    }

    @NotNull
    public static VariableDescriptor getEnclosingContinuationParameter(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getEnclosingContinuationParameter"));
        }
        VariableDescriptor result2 = context.getContinuationParameterDescriptor();
        if (result2 == null) {
            assert (context.getParent() != null);
            result2 = TranslationUtils.getEnclosingContinuationParameter(context.getParent());
        }
        VariableDescriptor variableDescriptor = result2;
        if (variableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getEnclosingContinuationParameter"));
        }
        return variableDescriptor;
    }

    @NotNull
    public static ClassDescriptor getCoroutineBaseClass(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineBaseClass"));
        }
        FqName className2 = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("CoroutineImpl"));
        ClassDescriptor descriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(context.getCurrentModule(), ClassId.topLevel(className2));
        assert (descriptor2 != null);
        ClassDescriptor classDescriptor = descriptor2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineBaseClass"));
        }
        return classDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getCoroutineProperty(@NotNull TranslationContext context, @NotNull String name2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineProperty"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineProperty"));
        }
        PropertyDescriptor propertyDescriptor = TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedVariables(Name.identifier(name2), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (propertyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineProperty"));
        }
        return propertyDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getCoroutineDoResumeFunction(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineDoResumeFunction"));
        }
        FunctionDescriptor functionDescriptor = TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("doResume"), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineDoResumeFunction"));
        }
        return functionDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getCoroutineResumeFunction(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineResumeFunction"));
        }
        FunctionDescriptor functionDescriptor = TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("resume"), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "getCoroutineResumeFunction"));
        }
        return functionDescriptor;
    }

    public static boolean isOverridableFunctionWithDefaultParameters(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/TranslationUtils", "isOverridableFunctionWithDefaultParameters"));
        }
        return DescriptorUtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor2) && !(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getContainingDeclaration() instanceof ClassDescriptor && ModalityKt.isOverridable(descriptor2);
    }

    private static boolean overridesReturnAny(CallableDescriptor c) {
        KotlinType returnType = c.getOriginal().getReturnType();
        assert (returnType != null);
        if (KotlinBuiltIns.isAnyOrNullableAny(returnType) || TypeUtils.isTypeParameter(returnType)) {
            return true;
        }
        for (CallableDescriptor callableDescriptor : c.getOverriddenDescriptors()) {
            if (!TranslationUtils.overridesReturnAny(callableDescriptor)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldBoxReturnValue(CallableDescriptor c) {
        return TranslationUtils.overridesReturnAny(c) || c instanceof CallableMemberDescriptor && ModalityKt.isOverridable((CallableMemberDescriptor)c);
    }
}

