/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.FileIconPatcher;
import org.jetbrains.kotlin.com.intellij.ide.FileIconProvider;
import org.jetbrains.kotlin.com.intellij.ide.presentation.VirtualFilePresentation;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.IconLoader;
import org.jetbrains.kotlin.com.intellij.openapi.util.Iconable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VFileProperty;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.WritingAccessProvider;
import org.jetbrains.kotlin.com.intellij.ui.IconDeferrer;
import org.jetbrains.kotlin.com.intellij.ui.LayeredIcon;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.FileIconKey;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = new NullableFunction<FileIconKey, Icon>(){

        @Override
        public Icon fun(FileIconKey key) {
            VirtualFile file2 = key.getFile();
            int flags = key.getFlags();
            Project project = key.getProject();
            if (!file2.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
                return null;
            }
            Icon providersIcon = IconUtil.getProvidersIcon(file2, flags, project);
            Icon icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file2) : providersIcon;
            boolean dumb = project != null && DumbService.getInstance(project).isDumb();
            for (FileIconPatcher patcher : IconUtil.getPatchers()) {
                if (dumb && !DumbService.isDumbAware(patcher)) continue;
                icon = patcher.patchIcon(icon, file2, flags & 0xFFFFFFFD, project);
            }
            if (file2.is(VFileProperty.SYMLINK)) {
                icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
            }
            if (!(!BitUtil.isSet(flags, 2) || file2.isWritable() && WritingAccessProvider.isPotentiallyWritable(file2, project))) {
                icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
            }
            Iconable.LastComputedIcon.put(file2, icon, flags);
            return icon;
        }
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "wasEverInitialized"));
        }
        Boolean was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    public static Icon getIcon(@NotNull VirtualFile file2, int flags, @Nullable Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getIcon"));
        }
        Icon lastIcon = Iconable.LastComputedIcon.get(file2, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIconImpl(file2);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file2, project, flags), ICON_NULLABLE_FUNCTION);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file2, int flags, Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getProvidersIcon"));
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file2, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("add.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getAddIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("remove.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getRemoveIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("edit.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getEditIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("analyze.png");
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getAnalyzeIcon"));
        }
        return icon;
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getToolbarDecoratorIcon"));
        }
        Icon icon = IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name2);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getToolbarDecoratorIcon"));
        }
        return icon;
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        String string = "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/IconUtil", "getToolbarDecoratorIconsFolder"));
        }
        return string;
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);
    }
}

