/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaVersionService;
import org.jetbrains.kotlin.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaDirectoryService;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassLevelDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeclarationStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDoWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstantInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionListStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiForStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPostfixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceListElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.infos.ClassCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.IsConstantExpressionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.HashMap;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public final class PsiUtil
extends PsiUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtil");
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create("VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    private static final Set<String> IGNORED_NAMES = ContainerUtil.newTroveSet("ignore", "ignore1", "ignore2", "ignore3", "ignore4", "ignore5", "ignored", "ignored1", "ignored2", "ignored3", "ignored4", "ignored5");
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create("FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return PsiUtilCore.compareElementsByPosition(o1, o2);
        }
    };
    public static final PsiClass NULL_PSI_CLASS = new NullPsiClass();

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isOnAssignmentLeftHand"));
        }
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        return parent2 instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent2).getLExpression(), expr, false);
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessibleFromPackage"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessibleFromPackage"));
        }
        if (element.hasModifierProperty("public")) {
            return true;
        }
        return !element.hasModifierProperty("private") && JavaPsiFacade.getInstance(element.getProject()).isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessedForWriting"));
        }
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        if (parent2 instanceof PsiPrefixExpression) {
            IElementType tokenType = ((PsiPrefixExpression)parent2).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        if (parent2 instanceof PsiPostfixExpression) {
            IElementType tokenType = ((PsiPostfixExpression)parent2).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    public static boolean isAccessedForReading(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessedForReading"));
        }
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
        return !(parent2 instanceof PsiAssignmentExpression) || !PsiTreeUtil.isAncestor(((PsiAssignmentExpression)parent2).getLExpression(), expr, false) || ((PsiAssignmentExpression)parent2).getOperationTokenType() != JavaTokenType.EQ;
    }

    public static boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessible"));
        }
        return PsiUtil.isAccessible(place.getProject(), member, place, accessObjectClass);
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessible"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessible"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAccessible"));
        }
        return JavaPsiFacade.getInstance(project).getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    @NotNull
    public static JavaResolveResult getAccessObjectClass(@NotNull PsiExpression expression) {
        JavaResolveResult resolveResult;
        PsiType upperBound;
        PsiType lub;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
        }
        if (expression instanceof PsiSuperExpression) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
            }
            return javaResolveResult;
        }
        PsiType type2 = expression.getType();
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type2).resolveGenerics();
            if (classResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
            }
            return classResolveResult;
        }
        if (type2 instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type2).getLeastUpperBound()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)lub).resolveGenerics();
            if (classResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
            }
            return classResolveResult;
        }
        if (type2 instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)type2).getUpperBound()) instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)upperBound).resolve();
            PsiFile containingFile = resolved != null ? resolved.getContainingFile() : null;
            String packageName = containingFile instanceof PsiClassOwner ? ((PsiClassOwner)containingFile).getPackageName() : null;
            String classText = StringUtil.isEmptyOrSpaces(packageName) ? "" : "package " + packageName + ";\n ";
            classText = classText + "class I<T extends " + upperBound.getCanonicalText() + "> {}";
            PsiJavaFile file2 = (PsiJavaFile)PsiFileFactory.getInstance(expression.getProject()).createFileFromText("inference_dummy.java", JavaLanguage.INSTANCE, (CharSequence)classText);
            PsiTypeParameter freshParameter = file2.getClasses()[0].getTypeParameters()[0];
            ClassCandidateInfo classCandidateInfo = new ClassCandidateInfo(freshParameter, PsiSubstitutor.EMPTY);
            if (classCandidateInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
            }
            return classCandidateInfo;
        }
        if (type2 == null && expression instanceof PsiReferenceExpression && (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement() instanceof PsiClass) {
            JavaResolveResult javaResolveResult = resolveResult;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
            }
            return javaResolveResult;
        }
        JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessObjectClass"));
        }
        return javaResolveResult;
    }

    public static boolean isConstantExpression(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression.accept(visitor2);
        return visitor2.myIsConstant;
    }

    public static void addException(@NotNull PsiMethod method, @NotNull @NonNls String exceptionFQName) throws IncorrectOperationException {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "addException"));
        }
        if (exceptionFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionFQName", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "addException"));
        }
        PsiClass exceptionClass = JavaPsiFacade.getInstance(method.getProject()).findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(@NotNull PsiMethod method, @NotNull PsiClass exceptionClass) throws IncorrectOperationException {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "addException"));
        }
        if (exceptionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "addException"));
        }
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(@NotNull PsiMethod method, @Nullable PsiClass exceptionClass, @Nullable String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "addException"));
        }
        assert (exceptionClass != null || exceptionName != null) : "One of exceptionName, exceptionClass must be not null";
        PsiReferenceList throwsList = method.getThrowsList();
        PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
        boolean replaced = false;
        for (PsiJavaCodeReferenceElement ref2 : refs) {
            if (ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass2 = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass2 == null) continue;
            if (aClass2.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                if (replaced) {
                    ref2.delete();
                    continue;
                }
                PsiElementFactory factory2 = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
                if (exceptionName != null) {
                    ref1 = factory2.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type2 = factory2.createType(exceptionClass);
                    ref1 = factory2.createReferenceElementByType(type2);
                }
                ref2.replace(ref1);
                replaced = true;
                continue;
            }
            if (!exceptionClass.isInheritor(aClass2, true)) continue;
            return;
        }
        if (replaced) {
            return;
        }
        PsiElementFactory factory3 = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        if (exceptionName != null) {
            ref = factory3.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClassType type3 = factory3.createType(exceptionClass);
            ref = factory3.createReferenceElementByType(type3);
        }
        throwsList.add(ref);
    }

    public static void removeException(@NotNull PsiMethod method, @NonNls String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "removeException"));
        }
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(@NotNull String name2, @NotNull PsiElement place) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isVariableNameUnique"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isVariableNameUnique"));
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper();
        return helper.resolveAccessibleReferencedVariable(name2, place) == null;
    }

    @Nullable
    public static PsiElement getTopLevelEnclosingCodeBlock(@Nullable PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiExpression) || parent2 instanceof PsiLambdaExpression) {
                if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                    blockSoFar = element;
                }
                if (parent2 instanceof PsiMethod && parent2.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent2.getParent()) || parent2 instanceof PsiClassInitializer && !(parent2.getParent() instanceof PsiAnonymousClass)) break;
                if (parent2 instanceof PsiField && ((PsiField)parent2).getInitializer() == element) {
                    blockSoFar = element;
                }
                if (parent2 instanceof PsiClassLevelDeclarationStatement) {
                    parent2 = parent2.getParent();
                }
                if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
                if (element instanceof PsiFile && PsiUtilCore.getTemplateLanguageFile(element) != null) {
                    return element;
                }
            }
            if (element == scope) break;
            element = parent2;
        }
        return blockSoFar;
    }

    public static boolean isLocalOrAnonymousClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLocalOrAnonymousClass"));
        }
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLocalClass"));
        }
        PsiElement parent2 = psiClass.getParent();
        if (parent2 instanceof PsiDeclarationStatement && parent2.getParent() instanceof PsiCodeBlock) {
            return true;
        }
        if (parent2 instanceof PsiClass) {
            return PsiUtil.isLocalOrAnonymousClass((PsiClass)parent2);
        }
        return false;
    }

    public static boolean isAbstractClass(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isAbstractClass"));
        }
        PsiModifierList modifierList = clazz.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("abstract");
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getVariableCodeBlock"));
        }
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeBlock = ((PsiLambdaExpression)declarationScope).getBody();
            }
        } else {
            if (variable instanceof PsiResourceVariable) {
                PsiElement resourceList = variable.getParent();
                return resourceList != null ? resourceList.getParent() : null;
            }
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context != null) {
                PsiClass aClass2 = ((PsiField)variable).getContainingClass();
                while (context != null && context.getParent() != aClass2) {
                    if (!((context = context.getParent()) instanceof PsiClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context instanceof PsiMethod ? ((PsiMethod)context).getBody() : (context instanceof PsiClassInitializer ? ((PsiClassInitializer)context).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    public static boolean isIncrementDecrementOperation(@NotNull PsiElement element) {
        IElementType sign;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isIncrementDecrementOperation"));
        }
        return element instanceof PsiPostfixExpression ? (sign = ((PsiPostfixExpression)element).getOperationTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS : element instanceof PsiPrefixExpression && ((sign = ((PsiPrefixExpression)element).getOperationTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS);
    }

    @AccessLevel
    public static int getAccessLevel(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessLevel"));
        }
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getAccessModifier(@AccessLevel int accessLevel) {
        String modifier;
        assert (accessLevel > 0 && accessLevel <= accessModifiers.length) : accessLevel;
        String string = modifier = accessModifiers[accessLevel - 1];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getAccessModifier"));
        }
        return string;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isStatement"));
        }
        PsiElement parent2 = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            if (!(parent2 instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent2;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent2 instanceof PsiCodeBlock) {
                return true;
            }
            if (parent2 instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent2 instanceof PsiForStatement) || ((PsiForStatement)parent2).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(@NotNull PsiElement scope, @NotNull TextRange range) {
        PsiElement psiElement;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getElementInclusiveRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getElementInclusiveRange"));
        }
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(@Nullable PsiType type2) {
        PsiType lub;
        if (type2 instanceof PsiClassType) {
            return ((PsiClassType)type2).resolve();
        }
        if (type2 instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type2).getLeastUpperBound()) instanceof PsiClassType) {
            return ((PsiClassType)lub).resolve();
        }
        return null;
    }

    @Nullable
    public static PsiClass resolveClassInClassTypeOnly(@Nullable PsiType type2) {
        return type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
    }

    @NotNull
    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(@Nullable PsiType type2) {
        PsiType lub;
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
            if (classResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "resolveGenericsClassInType"));
            }
            return classResolveResult;
        }
        if (type2 instanceof PsiArrayType) {
            PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(((PsiArrayType)type2).getComponentType());
            if (classResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "resolveGenericsClassInType"));
            }
            return classResolveResult;
        }
        if (type2 instanceof PsiDisjunctionType && (lub = ((PsiDisjunctionType)type2).getLeastUpperBound()) instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)lub).resolveGenerics();
            if (classResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "resolveGenericsClassInType"));
            }
            return classResolveResult;
        }
        PsiClassType.ClassResolveResult classResolveResult = PsiClassType.ClassResolveResult.EMPTY;
        if (classResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "resolveGenericsClassInType"));
        }
        return classResolveResult;
    }

    @NotNull
    public static PsiType convertAnonymousToBaseType(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "convertAnonymousToBaseType"));
        }
        PsiClass psiClass = PsiUtil.resolveClassInType(type2);
        if (psiClass instanceof PsiAnonymousClass) {
            int dims = type2.getArrayDimensions();
            type2 = ((PsiAnonymousClass)psiClass).getBaseClassType();
            while (dims != 0) {
                type2 = type2.createArrayType();
                --dims;
            }
        }
        PsiType psiType = type2;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "convertAnonymousToBaseType"));
        }
        return psiType;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isApplicable"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isApplicable"));
        }
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isApplicable"));
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpression[] argList) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isApplicable"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isApplicable"));
        }
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isApplicable"));
        }
        PsiType[] types = ContainerUtil.map2Array(argList, PsiType.class, PsiExpression.EXPRESSION_TO_TYPE);
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, types, PsiUtil.getLanguageLevel(method)) != 1;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiExpressionList argList) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList.getExpressionTypes(), PsiUtil.getLanguageLevel(argList));
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, true, true);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel, allowUncheckedConversion, checkVarargs, ApplicabilityChecker.ASSIGNABILITY_CHECKER);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public static int getApplicabilityLevel(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutorForMethod, @NotNull PsiType[] args, @NotNull LanguageLevel languageLevel, boolean allowUncheckedConversion, boolean checkVarargs, @NotNull ApplicabilityChecker function2) {
        boolean isRaw;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getApplicabilityLevel"));
        }
        PsiParameter[] parms = method.getParameterList().getParameters();
        if (args.length < parms.length - 1) {
            return 1;
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor(method, substitutorForMethod) && PsiUtil.isRawSubstitutor(containingClass, substitutorForMethod);
        if (!PsiUtil.areFirstArgumentsApplicable(args, parms, languageLevel, substitutorForMethod, isRaw, allowUncheckedConversion, function2)) {
            return 1;
        }
        if (args.length == parms.length) {
            PsiType erasedParamType;
            if (parms.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parms[parms.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args[args.length - 1];
            if (argType == null) {
                return 1;
            }
            if (function2.isApplicable(parmType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
            if (isRaw && (erasedParamType = TypeConversionUtil.erasure(parmType)) != null && function2.isApplicable(erasedParamType, argType, allowUncheckedConversion, parms.length - 1)) {
                return 3;
            }
        }
        if (checkVarargs && method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            PsiParameter lastParameter;
            if (args.length < parms.length) {
                return 2;
            }
            PsiParameter psiParameter = lastParameter = parms.length == 0 ? null : parms[parms.length - 1];
            if (lastParameter == null || !lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            if ((lastParmType = ((PsiArrayType)lastParmType).getComponentType()) instanceof PsiCapturedWildcardType && !JavaVersionService.getInstance().isAtLeast(((PsiCapturedWildcardType)lastParmType).getContext(), JavaSdkVersion.JDK_1_8)) {
                lastParmType = ((PsiCapturedWildcardType)lastParmType).getWildcard();
            }
            if (lastParmType instanceof PsiClassType) {
                lastParmType = ((PsiClassType)lastParmType).setLanguageLevel(languageLevel);
            }
            for (int i = parms.length - 1; i < args.length; ++i) {
                PsiType argType = args[i];
                if (argType != null && function2.isApplicable(lastParmType, argType, allowUncheckedConversion, i)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(@NotNull PsiType[] args, @NotNull PsiParameter[] parms, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutorForMethod, boolean isRaw, boolean allowUncheckedConversion, ApplicabilityChecker function2) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "areFirstArgumentsApplicable"));
        }
        if (parms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parms", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "areFirstArgumentsApplicable"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "areFirstArgumentsApplicable"));
        }
        if (substitutorForMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutorForMethod", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "areFirstArgumentsApplicable"));
        }
        for (int i = 0; i < parms.length - 1; ++i) {
            PsiType substErasure;
            PsiType type2 = args[i];
            if (type2 == null) {
                return false;
            }
            PsiParameter parameter = parms[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (!(isRaw ? (substErasure = TypeConversionUtil.erasure(substitutedParmType)) != null && !function2.isApplicable(substErasure, type2, allowUncheckedConversion, i) : !function2.isApplicable(substitutedParmType, type2, allowUncheckedConversion, i))) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(@NotNull PsiParameter parameter, @NotNull LanguageLevel languageLevel, @NotNull PsiSubstitutor substitutor2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getParameterType"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getParameterType"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getParameterType"));
        }
        PsiType parmType = parameter.getType();
        if (parmType instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor2.substitute(parmType);
    }

    public static boolean equalOnEquivalentClasses(PsiClassType thisClassType, @NotNull PsiClass aClass2, PsiClassType otherClassType, @NotNull PsiClass bClass) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnEquivalentClasses"));
        }
        if (bClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnEquivalentClasses"));
        }
        PsiClassType capture1 = !PsiCapturedWildcardType.isCapture() ? thisClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(thisClassType, aClass2);
        PsiClassType capture2 = !PsiCapturedWildcardType.isCapture() ? otherClassType : (PsiClassType)PsiUtil.captureToplevelWildcards(otherClassType, bClass);
        PsiClassType.ClassResolveResult result1 = capture1.resolveGenerics();
        PsiClassType.ClassResolveResult result2 = capture2.resolveGenerics();
        return PsiUtil.equalOnEquivalentClasses(result1.getSubstitutor(), aClass2, result2.getSubstitutor(), bClass);
    }

    @Deprecated
    public static boolean equalOnClass(@NotNull PsiSubstitutor s1, @NotNull PsiSubstitutor s2, @NotNull PsiClass aClass2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnClass"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnClass"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnClass"));
        }
        return PsiUtil.equalOnEquivalentClasses(s1, aClass2, s2, aClass2);
    }

    public static boolean equalOnEquivalentClasses(@NotNull PsiSubstitutor s1, @NotNull PsiClass aClass2, @NotNull PsiSubstitutor s2, @NotNull PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnEquivalentClasses"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnEquivalentClasses"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnEquivalentClasses"));
        }
        if (bClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "equalOnEquivalentClasses"));
        }
        if (aClass2.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass2.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiType substituted2 = s2.substitute(typeParameters2[i]);
            PsiType substituted1 = s1.substitute(typeParameters1[i]);
            if (Comparing.equal(substituted1, substituted2)) continue;
            return false;
        }
        if (aClass2.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass2.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        return containingClass1 == null && containingClass2 == null;
    }

    public static boolean isCompileTimeConstant(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isCompileTimeConstant"));
        }
        return PsiUtil.isCompileTimeConstant((PsiVariable)field);
    }

    public static boolean isCompileTimeConstant(@NotNull PsiVariable field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isCompileTimeConstant"));
        }
        return field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull(field.getType()) || field.getType().equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(@NotNull PsiMethod[] methods2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "allMethodsHaveSameSignature"));
        }
        if (methods2.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods2[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods2.length; ++i) {
            PsiMethod method = methods2[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isInnerClass"));
        }
        return !aClass2.hasModifierProperty("static") && aClass2.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList, @NonNls String modifier) {
        PsiElement[] children;
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "findModifierInList"));
        }
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getTopLevelClass"));
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof PsiClassOwner) {
            PsiClass[] classes2;
            for (PsiClass aClass2 : classes2 = ((PsiClassOwner)file2).getClasses()) {
                if (!PsiTreeUtil.isAncestor(aClass2, element, false)) continue;
                return aClass2;
            }
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(@NotNull PsiElement place, @Nullable PsiClass aClass2) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getEnclosingStaticElement"));
        }
        LOG.assertTrue(aClass2 == null || !place.isPhysical() || PsiTreeUtil.isContextAncestor(aClass2, place, false));
        for (PsiElement parent2 = place; parent2 != aClass2 && !(parent2 instanceof PsiFile); parent2 = parent2.getParent()) {
            if (!(parent2 instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent2).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent2;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getTypeByPsiElement"));
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    @NotNull
    public static PsiType captureToplevelWildcards(@NotNull PsiType type2, @NotNull PsiElement context) {
        PsiClassType.ClassResolveResult result2;
        PsiClass aClass2;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "captureToplevelWildcards"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "captureToplevelWildcards"));
        }
        if (type2 instanceof PsiClassType && (aClass2 = (result2 = ((PsiClassType)type2).resolveGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor2;
            PsiSubstitutor captureSubstitutor = substitutor2 = result2.getSubstitutor();
            for (PsiTypeParameter psiTypeParameter : PsiUtil.typeParametersIterable(aClass2)) {
                PsiType substituted = substitutor2.substitute(psiTypeParameter);
                if (!(substituted instanceof PsiWildcardType)) continue;
                captureSubstitutor = captureSubstitutor.put(psiTypeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context, psiTypeParameter));
            }
            if (captureSubstitutor != substitutor2) {
                HashMap<PsiTypeParameter, PsiCapturedWildcardType> substitutionMap = null;
                for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
                    PsiCapturedWildcardType capturedWildcard;
                    PsiType substituted = substitutor2.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap<PsiTypeParameter, PsiCapturedWildcardType>(substitutor2.getSubstitutionMap());
                    }
                    LOG.assertTrue((capturedWildcard = (PsiCapturedWildcardType)captureSubstitutor.substitute(typeParameter)) != null);
                    PsiType upperBound = PsiCapturedWildcardType.captureUpperBound(typeParameter, (PsiWildcardType)substituted, captureSubstitutor);
                    if (upperBound != null) {
                        capturedWildcard.setUpperBound(upperBound);
                    }
                    substitutionMap.put(typeParameter, capturedWildcard);
                }
                if (substitutionMap != null) {
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
                    PsiSubstitutor newSubstitutor = psiElementFactory.createSubstitutor(substitutionMap);
                    PsiClassType psiClassType = psiElementFactory.createType(aClass2, newSubstitutor);
                    if (psiClassType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "captureToplevelWildcards"));
                    }
                    return psiClassType;
                }
            }
        }
        PsiType psiType = type2;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "captureToplevelWildcards"));
        }
        return psiType;
    }

    public static PsiType recaptureWildcards(PsiType type2, PsiElement context) {
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 != null) {
                PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
                PsiSubstitutor resultSubstitution = null;
                for (PsiTypeParameter parameter : substitutor2.getSubstitutionMap().keySet()) {
                    PsiType substitute2 = substitutor2.substitute(parameter);
                    if (!(substitute2 instanceof PsiCapturedWildcardType)) continue;
                    if (resultSubstitution == null) {
                        resultSubstitution = substitutor2;
                    }
                    resultSubstitution = resultSubstitution.put(parameter, ((PsiCapturedWildcardType)substitute2).getWildcard());
                }
                if (resultSubstitution != null) {
                    PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(context.getProject());
                    return PsiUtil.captureToplevelWildcards(factory2.createType(aClass2, resultSubstitution), context);
                }
            }
        } else if (type2 instanceof PsiArrayType) {
            return PsiUtil.recaptureWildcards(((PsiArrayType)type2).getComponentType(), context).createArrayType();
        }
        return type2;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true) != null;
    }

    @NotNull
    public static List<PsiTypeElement> getParameterTypeElements(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getParameterTypeElements"));
        }
        PsiTypeElement typeElement = parameter.getTypeElement();
        List<PsiTypeElement> list2 = typeElement != null && typeElement.getType() instanceof PsiDisjunctionType ? PsiTreeUtil.getChildrenOfTypeAsList(typeElement, PsiTypeElement.class) : Collections.singletonList(typeElement);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getParameterTypeElements"));
        }
        return list2;
    }

    public static void checkIsIdentifier(@NotNull PsiManager manager, String text2) throws IncorrectOperationException {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "checkIsIdentifier"));
        }
        if (!PsiNameHelper.getInstance(manager.getProject()).isIdentifier(text2)) {
            throw new IncorrectOperationException(PsiBundle.message("0.is.not.an.identifier", text2));
        }
    }

    @Nullable
    public static VirtualFile getJarFile(@NotNull PsiElement candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getJarFile"));
        }
        VirtualFile file2 = candidate.getContainingFile().getVirtualFile();
        if (file2 != null && file2.getFileSystem().getProtocol().equals("jar")) {
            return VfsUtilCore.getVirtualFileForJar(file2);
        }
        return file2;
    }

    public static boolean isAnnotationMethod(PsiElement element) {
        if (!(element instanceof PsiAnnotationMethod)) {
            return false;
        }
        PsiClass psiClass = ((PsiAnnotationMethod)element).getContainingClass();
        return psiClass != null && psiClass.isAnnotationType();
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass2) {
        return PsiUtil.getMaximumModifierForMember(aClass2, true);
    }

    @PsiModifier.ModifierConstant
    public static String getMaximumModifierForMember(PsiClass aClass2, boolean allowPublicAbstract) {
        String modifier = "public";
        if (!allowPublicAbstract && aClass2.hasModifierProperty("abstract") && !aClass2.isEnum()) {
            modifier = "protected";
        } else if (aClass2.hasModifierProperty("packageLocal") || aClass2.isEnum()) {
            modifier = "packageLocal";
        } else if (aClass2.hasModifierProperty("private")) {
            modifier = "private";
        }
        return modifier;
    }

    @NotNull
    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "typeParametersIterator"));
        }
        Iterator<PsiTypeParameter> iterator2 = PsiUtil.typeParametersIterable(owner).iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "typeParametersIterator"));
        }
        return iterator2;
    }

    @NotNull
    public static Iterable<PsiTypeParameter> typeParametersIterable(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "typeParametersIterable"));
        }
        ArrayList<PsiTypeParameter> result2 = null;
        for (PsiTypeParameterListOwner currentOwner = owner; currentOwner != null; currentOwner = currentOwner.getContainingClass()) {
            PsiTypeParameter[] typeParameters2 = currentOwner.getTypeParameters();
            if (typeParameters2.length > 0) {
                if (result2 == null) {
                    result2 = new ArrayList<PsiTypeParameter>(typeParameters2.length);
                }
                for (int i = typeParameters2.length - 1; i >= 0; --i) {
                    result2.add(typeParameters2[i]);
                }
            }
            if (currentOwner.hasModifierProperty("static")) break;
        }
        if (result2 == null) {
            EmptyIterable<PsiTypeParameter> emptyIterable = EmptyIterable.getInstance();
            if (emptyIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "typeParametersIterable"));
            }
            return emptyIterable;
        }
        ArrayList<PsiTypeParameter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "typeParametersIterable"));
        }
        return arrayList;
    }

    public static boolean canBeOverriden(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "canBeOverriden"));
        }
        PsiClass parentClass = method.getContainingClass();
        return parentClass != null && !method.isConstructor() && !method.hasModifierProperty("static") && !method.hasModifierProperty("final") && !method.hasModifierProperty("private") && !(parentClass instanceof PsiAnonymousClass) && !parentClass.hasModifierProperty("final");
    }

    @NotNull
    public static PsiElement[] mapElements(@NotNull ResolveResult[] candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "mapElements"));
        }
        PsiElement[] result2 = new PsiElement[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            result2[i] = candidates[i].getElement();
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "mapElements"));
        }
        return result2;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent2 = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiEnumConstantInitializer.class, PsiMethod.class, PsiField.class);
        if (parent2 instanceof PsiMethod && !((PsiMethod)parent2).isConstructor()) {
            return null;
        }
        if (parent2 instanceof PsiField && parent2.hasModifierProperty("static")) {
            return null;
        }
        return parent2;
    }

    public static boolean checkName(@NotNull PsiElement element, @NotNull String name2, PsiElement context) {
        PsiMetaData data2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "checkName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "checkName"));
        }
        if (element instanceof PsiMetaOwner && (data2 = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            return name2.equals(data2.getName(context));
        }
        return element instanceof PsiNamedElement && name2.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, @NotNull PsiSubstitutor substitutor2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isRawSubstitutor"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isRawSubstitutor"));
        }
        if (substitutor2 == PsiSubstitutor.EMPTY) {
            return false;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutor2.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLanguageLevel5OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLanguageLevel5OrHigher"));
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_5);
    }

    public static boolean isLanguageLevel6OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLanguageLevel6OrHigher"));
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_6);
    }

    public static boolean isLanguageLevel7OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLanguageLevel7OrHigher"));
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_7);
    }

    public static boolean isLanguageLevel8OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLanguageLevel8OrHigher"));
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static boolean isLanguageLevel9OrHigher(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isLanguageLevel9OrHigher"));
        }
        return PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_9);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        PsiElement context;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
        }
        if (element instanceof PsiDirectory) {
            LanguageLevel languageLevel = JavaDirectoryService.getInstance().getLanguageLevel((PsiDirectory)element);
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
            }
            return languageLevel;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof PsiJavaFile) {
            LanguageLevel languageLevel = ((PsiJavaFile)file2).getLanguageLevel();
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
            }
            return languageLevel;
        }
        if (file2 != null && (context = file2.getContext()) != null) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(context);
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
            }
            return languageLevel;
        }
        PsiResolveHelper instance = PsiResolveHelper.SERVICE.getInstance(element.getProject());
        LanguageLevel languageLevel = instance != null ? instance.getEffectiveLanguageLevel(PsiUtil.getVirtualFile(file2)) : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
        }
        LanguageLevelProjectExtension instance = LanguageLevelProjectExtension.getInstance(project);
        LanguageLevel languageLevel = instance != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getLanguageLevel"));
        }
        return languageLevel;
    }

    public static boolean isInstantiatable(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isInstantiatable"));
        }
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "hasDefaultConstructor"));
        }
        return PsiUtil.hasDefaultConstructor(clazz, false);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "hasDefaultConstructor"));
        }
        return PsiUtil.hasDefaultConstructor(clazz, allowProtected, true);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass clazz, boolean allowProtected, boolean checkModifiers) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "hasDefaultConstructor"));
        }
        return PsiUtil.hasDefaultCtrInHierarchy(clazz, allowProtected, checkModifiers, null);
    }

    private static boolean hasDefaultCtrInHierarchy(@NotNull PsiClass clazz, boolean allowProtected, boolean checkModifiers, @Nullable Set<PsiClass> visited2) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "hasDefaultCtrInHierarchy"));
        }
        PsiMethod[] constructors2 = clazz.getConstructors();
        if (constructors2.length > 0) {
            for (PsiMethod cls : constructors2) {
                if (checkModifiers && !cls.hasModifierProperty("public") && (!allowProtected || !cls.hasModifierProperty("protected")) || cls.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        } else {
            PsiClass superClass = clazz.getSuperClass();
            if (superClass == null) {
                return true;
            }
            if (visited2 == null) {
                visited2 = new THashSet<PsiClass>();
            }
            if (!visited2.add(clazz)) {
                return false;
            }
            return PsiUtil.hasDefaultCtrInHierarchy(superClass, true, true, visited2);
        }
        return false;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiType extractIterableTypeParameter(@Nullable PsiType psiType, boolean eraseTypeParameter) {
        PsiType type2 = PsiUtil.substituteTypeParameter(psiType, "java.lang.Iterable", 0, eraseTypeParameter);
        return type2 != null ? type2 : PsiUtil.substituteTypeParameter(psiType, "java.util.Collection", 0, eraseTypeParameter);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static PsiType substituteTypeParameter(@Nullable PsiType psiType, @NotNull String superClass, int typeParamIndex, boolean eraseTypeParameter) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "substituteTypeParameter"));
        }
        if (psiType == null) {
            return null;
        }
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)psiType;
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass baseClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(superClass, psiClass.getResolveScope());
        if (baseClass == null) {
            return null;
        }
        if (!psiClass.isEquivalentTo(baseClass) && !psiClass.isInheritor(baseClass, true)) {
            return null;
        }
        PsiTypeParameter[] parameters2 = baseClass.getTypeParameters();
        if (parameters2.length <= typeParamIndex) {
            return PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getSuperClassSubstitutor(baseClass, psiClass, classResolveResult.getSubstitutor());
        PsiType type2 = substitutor2.substitute(parameters2[typeParamIndex]);
        if (type2 == null && eraseTypeParameter) {
            return TypeConversionUtil.typeParameterErasure(parameters2[typeParamIndex]);
        }
        return type2;
    }

    public static void setModifierProperty(@NotNull PsiModifierListOwner owner, @NotNull @PsiModifier.ModifierConstant String property, boolean value) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "setModifierProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "setModifierProperty"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null) : owner;
        modifierList.setModifierProperty(property, value);
    }

    public static boolean isTryBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        return parent2 instanceof PsiTryStatement && element == ((PsiTryStatement)parent2).getTryBlock();
    }

    public static boolean isElseBlock(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent2 = element.getParent();
        return parent2 instanceof PsiIfStatement && element == ((PsiIfStatement)parent2).getElseBranch();
    }

    public static boolean isJavaToken(@Nullable PsiElement element, IElementType type2) {
        return element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == type2;
    }

    public static boolean isJavaToken(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "isJavaToken"));
        }
        return element instanceof PsiJavaToken && types.contains(((PsiJavaToken)element).getTokenType());
    }

    public static boolean isCatchParameter(@Nullable PsiElement element) {
        return element instanceof PsiParameter && element.getParent() instanceof PsiCatchSection;
    }

    public static boolean isIgnoredName(@Nullable String name2) {
        return name2 != null && IGNORED_NAMES.contains(name2);
    }

    @Nullable
    public static PsiMethod getResourceCloserMethod(@NotNull PsiResourceListElement resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getResourceCloserMethod"));
        }
        PsiType resourceType = resource.getType();
        return resourceType instanceof PsiClassType ? PsiUtil.getResourceCloserMethodForType((PsiClassType)resourceType) : null;
    }

    public static PsiMethod getResourceCloserMethod(@NotNull PsiResourceVariable resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getResourceCloserMethod"));
        }
        return PsiUtil.getResourceCloserMethod((PsiResourceListElement)resource);
    }

    @Nullable
    public static PsiMethod getResourceCloserMethodForType(@NotNull PsiClassType resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getResourceCloserMethodForType"));
        }
        PsiClass resourceClass = resourceType.resolve();
        if (resourceClass == null) {
            return null;
        }
        Project project = resourceClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiClass autoCloseable = facade.findClass("java.lang.AutoCloseable", ProjectScope.getLibrariesScope(project));
        if (autoCloseable == null) {
            return null;
        }
        if (JavaClassSupers.getInstance().getSuperClassSubstitutor(autoCloseable, resourceClass, resourceType.getResolveScope(), PsiSubstitutor.EMPTY) == null) {
            return null;
        }
        PsiMethod[] closes = autoCloseable.findMethodsByName("close", false);
        return closes.length == 1 ? resourceClass.findMethodBySignature(closes[0], true) : null;
    }

    @Nullable
    public static PsiExpression skipParenthesizedExprDown(PsiExpression initializer2) {
        while (initializer2 instanceof PsiParenthesizedExpression) {
            initializer2 = ((PsiParenthesizedExpression)initializer2).getExpression();
        }
        return initializer2;
    }

    public static PsiElement skipParenthesizedExprUp(PsiElement parent2) {
        while (parent2 instanceof PsiParenthesizedExpression) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    public static void ensureValidType(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "ensureValidType"));
        }
        PsiUtil.ensureValidType(type2, null);
    }

    public static void ensureValidType(@NotNull PsiType type2, @Nullable String customMessage) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "ensureValidType"));
        }
        if (!type2.isValid()) {
            TimeoutUtil.sleep(1L);
            if (type2.isValid()) {
                LOG.error("PsiType resurrected: " + type2 + " of " + type2.getClass() + " " + customMessage);
                return;
            }
            if (type2 instanceof PsiClassType) {
                try {
                    PsiClass psiClass = ((PsiClassType)type2).resolve();
                    if (psiClass != null) {
                        PsiUtil.ensureValid(psiClass);
                    }
                }
                catch (PsiInvalidElementAccessException e) {
                    throw customMessage == null ? e : new RuntimeException(customMessage, e);
                }
            }
            throw new AssertionError((Object)("Invalid type: " + type2 + " of class " + type2.getClass() + " " + customMessage));
        }
    }

    @Nullable
    public static String getMemberQualifiedName(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "getMemberQualifiedName"));
        }
        if (member instanceof PsiClass) {
            return ((PsiClass)member).getQualifiedName();
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String className2 = containingClass.getQualifiedName();
        if (className2 == null) {
            return null;
        }
        return className2 + "." + member.getName();
    }

    static boolean checkSameExpression(PsiElement templateExpr, PsiExpression expression) {
        return templateExpr.equals(PsiUtil.skipParenthesizedExprDown(expression));
    }

    public static boolean isCondition(PsiElement expr, PsiElement parent2) {
        return parent2 instanceof PsiIfStatement ? PsiUtil.checkSameExpression(expr, ((PsiIfStatement)parent2).getCondition()) : (parent2 instanceof PsiWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiWhileStatement)parent2).getCondition()) : (parent2 instanceof PsiForStatement ? PsiUtil.checkSameExpression(expr, ((PsiForStatement)parent2).getCondition()) : (parent2 instanceof PsiDoWhileStatement ? PsiUtil.checkSameExpression(expr, ((PsiDoWhileStatement)parent2).getCondition()) : parent2 instanceof PsiConditionalExpression && PsiUtil.checkSameExpression(expr, ((PsiConditionalExpression)parent2).getCondition()))));
    }

    @NotNull
    public static PsiReturnStatement[] findReturnStatements(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "findReturnStatements"));
        }
        PsiReturnStatement[] psiReturnStatementArray = PsiUtil.findReturnStatements(method.getBody());
        if (psiReturnStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "findReturnStatements"));
        }
        return psiReturnStatementArray;
    }

    @NotNull
    public static PsiReturnStatement[] findReturnStatements(@Nullable PsiCodeBlock body) {
        ArrayList<PsiReturnStatement> vector = new ArrayList<PsiReturnStatement>();
        if (body != null) {
            PsiUtil.addReturnStatements(vector, body);
        }
        PsiReturnStatement[] psiReturnStatementArray = vector.toArray(new PsiReturnStatement[vector.size()]);
        if (psiReturnStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil", "findReturnStatements"));
        }
        return psiReturnStatementArray;
    }

    private static void addReturnStatements(ArrayList<PsiReturnStatement> vector, PsiElement element) {
        if (element instanceof PsiReturnStatement) {
            vector.add((PsiReturnStatement)element);
        } else if (!(element instanceof PsiClass) && !(element instanceof PsiLambdaExpression)) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                PsiUtil.addReturnStatements(vector, child);
            }
        }
    }

    public static class NullPsiClass
    extends PsiUtilCore.NullPsiElement
    implements PsiClass {
        @Override
        @Nullable
        public ItemPresentation getPresentation() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiDocComment getDocComment() {
            throw this.createException();
        }

        @Override
        public boolean hasTypeParameters() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiModifierList getModifierList() {
            throw this.createException();
        }

        @Override
        @Nullable
        public String getName() {
            throw this.createException();
        }

        @Override
        public boolean isDeprecated() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiTypeParameterList getTypeParameterList() {
            throw this.createException();
        }

        @Override
        public void navigate(boolean requestFocus) {
            throw this.createException();
        }

        @Override
        public boolean canNavigate() {
            throw this.createException();
        }

        @Override
        public boolean hasModifierProperty(@PsiModifier.ModifierConstant @NonNls @NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil$NullPsiClass", "hasModifierProperty"));
            }
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiTypeParameter[] getTypeParameters() {
            throw this.createException();
        }

        @Override
        public boolean canNavigateToSource() {
            throw this.createException();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            throw this.createException();
        }

        @Override
        public boolean isInterface() {
            throw this.createException();
        }

        @Override
        public boolean isAnnotationType() {
            throw this.createException();
        }

        @Override
        public boolean isEnum() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReferenceList getExtendsList() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReferenceList getImplementsList() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassType[] getExtendsListTypes() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassType[] getImplementsListTypes() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiClass getSuperClass() {
            throw this.createException();
        }

        @Override
        public PsiClass[] getInterfaces() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClass[] getSupers() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassType[] getSuperTypes() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiField[] getFields() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] getMethods() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] getConstructors() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClass[] getInnerClasses() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClassInitializer[] getInitializers() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiField[] getAllFields() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] getAllMethods() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiClass[] getAllInnerClasses() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiField findFieldByName(@NonNls String name2, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiMethod[] findMethodsByName(@NonNls String name2, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String name2, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @NotNull
        public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiClass findInnerClassByName(@NonNls String name2, boolean checkBases) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLBrace() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getRBrace() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiIdentifier getNameIdentifier() {
            throw this.createException();
        }

        @Override
        public PsiElement getScope() {
            throw this.createException();
        }

        @Override
        public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil$NullPsiClass", "isInheritor"));
            }
            throw this.createException();
        }

        @Override
        public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiClass getContainingClass() {
            throw this.createException();
        }

        @Override
        @NotNull
        public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
            throw this.createException();
        }

        @Override
        public PsiElement setName(@NonNls @NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtil$NullPsiClass", "setName"));
            }
            throw this.createException();
        }
    }

    public static interface ApplicabilityChecker {
        public static final ApplicabilityChecker ASSIGNABILITY_CHECKER = new ApplicabilityChecker(){

            @Override
            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
            }
        };

        public boolean isApplicable(PsiType var1, PsiType var2, boolean var3, int var4);
    }

    public static @interface AccessLevel {
    }
}

