/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public abstract class LeafElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
    private static final Key<SoftReference<String>> CACHED_TEXT = Key.create("CACHED_TEXT");
    private final CharSequence myText;

    protected LeafElement(@NotNull IElementType type2, CharSequence text2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "<init>"));
        }
        super(type2);
        this.myText = text2;
    }

    @Override
    @NotNull
    public LeafElement clone() {
        LeafElement clone = (LeafElement)super.clone();
        clone.clearCaches();
        LeafElement leafElement = clone;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "clone"));
        }
        return leafElement;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "getChars"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText.length() > 1000 && !(this.myText instanceof String)) {
            String text2 = (String)SoftReference.dereference(this.getUserData(CACHED_TEXT));
            if (text2 == null) {
                text2 = this.myText.toString();
                this.putUserData(CACHED_TEXT, new SoftReference<String>(text2));
            }
            String string = text2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "getText"));
            }
            return string;
        }
        String string = this.myText.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "getText"));
        }
        return string;
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        int length = this.myText.length();
        if (buffer != null) {
            CharArrayUtil.getChars(this.myText, buffer, start, length);
        }
        return start + length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars(this.myText, buffer, 0);
        if (buffer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "textToCharArray"));
        }
        return buffer;
    }

    @Override
    public boolean textContains(char c) {
        char[] chars;
        CharSequence text2 = this.myText;
        int len = this.myText.length();
        if (len > 5 && (chars = CharArrayUtil.fromSequenceWithoutCopying(this.myText)) != null) {
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (c != text2.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "textMatches"));
        }
        assert (start >= 0) : start;
        CharSequence text2 = this.myText;
        return LeafElement.leafTextMatches(text2, buffer, start);
    }

    static int leafTextMatches(@NotNull CharSequence text2, @NotNull CharSequence buffer, int start) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "leafTextMatches"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "leafTextMatches"));
        }
        assert (start >= 0) : start;
        int length = text2.length();
        if (buffer.length() - start < length) {
            return start == 0 ? Integer.MIN_VALUE : -start;
        }
        for (int i = 0; i < length; ++i) {
            int k = i + start;
            if (text2.charAt(i) == buffer.charAt(k)) continue;
            return k == 0 ? Integer.MIN_VALUE : -k;
        }
        return start + length;
    }

    @NotNull
    public LeafElement rawReplaceWithText(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "rawReplaceWithText"));
        }
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo(newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "rawReplaceWithText"));
        }
        return leafElement;
    }

    @NotNull
    public LeafElement replaceWithText(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "replaceWithText"));
        }
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        LeafElement leafElement = newLeaf;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "replaceWithText"));
        }
        return leafElement;
    }

    @Override
    public LeafElement findLeafElementAt(int offset2) {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence buf, int start, int end) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "textMatches"));
        }
        CharSequence text2 = this.getChars();
        int len = text2.length();
        if (end - start != len) {
            return false;
        }
        if (buf == text2) {
            return true;
        }
        if (len > 5 && text2 instanceof String && buf instanceof String) {
            return ((String)text2).regionMatches(0, (String)buf, start, len);
        }
        for (int i = 0; i < len; ++i) {
            if (text2.charAt(i) == buf.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor2) {
        visitor2.visitLeaf(this);
    }

    @Override
    public ASTNode findChildByType(IElementType type2) {
        return null;
    }

    public ASTNode findChildByType(IElementType type2, @Nullable ASTNode anchor2) {
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "findChildByType"));
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor2) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "findChildByType"));
        }
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    static int leafHC(CharSequence text2) {
        int len = text2.length();
        int hc = 0;
        for (int i = 0; i < len; ++i) {
            hc += text2.charAt(i);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    @Override
    @NotNull
    public ASTNode[] getChildren(TokenSet filter2) {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }

    @Override
    public void addChild(@NotNull ASTNode child, ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "addChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafType", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "addLeaf"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "addChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "removeChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "replaceChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "replaceChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "removeRange"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public PsiElement getPsi() {
        return null;
    }

    @Override
    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "getPsi"));
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    static <T extends PsiElement> T getPsi(@NotNull Class<T> clazz, PsiElement element, Logger log2) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement", "getPsi"));
        }
        log2.assertTrue(clazz.isInstance(element), "unexpected psi class. expected: " + clazz + " got: " + (element == null ? null : element.getClass()));
        return (T)element;
    }
}

