/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiFileSystemItemProcessor;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class SyntheticFileSystemItem
extends PsiElementBase
implements PsiFileSystemItem {
    private static final Logger LOG = Logger.getInstance("#" + SyntheticFileSystemItem.class.getPackage().getName());
    protected final Project myProject;
    protected final PsiManager myManager;

    public SyntheticFileSystemItem(Project project) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance(this.myProject);
    }

    protected static boolean processFileSystemItem(PsiElementProcessor<PsiFileSystemItem> processor, PsiFileSystemItem element) {
        if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(element.getName(), true)) {
            return true;
        }
        return processor.execute(element);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isValid() {
        VirtualFile virtualFile = this.getVirtualFile();
        return virtualFile != null && virtualFile.isValid();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "replace"));
        }
        throw new IncorrectOperationException("Frameworks cannot be changed");
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be deleted");
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be deleted");
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "accept"));
        }
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiElementProcessor.CollectElements<PsiFileSystemItem> collector2 = new PsiElementProcessor.CollectElements<PsiFileSystemItem>();
        this.processChildren(collector2);
        PsiElement[] psiElementArray = collector2.toArray(new PsiFileSystemItem[0]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "getLanguage"));
        }
        return language;
    }

    @Override
    public void checkSetName(String name2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be renamed");
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "setName"));
        }
        throw new IncorrectOperationException("Frameworks cannot be renamed");
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset2) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    @Nullable
    public String getText() {
        return null;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "textToCharArray"));
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "textMatches"));
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "textMatches"));
        }
        return false;
    }

    @Override
    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "add"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "addBefore"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "addAfter"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/SyntheticFileSystemItem", "checkAdd"));
        }
        throw new IncorrectOperationException();
    }
}

