/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.navigation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProvider;
import org.jetbrains.kotlin.com.intellij.navigation.NavigationItem;
import org.jetbrains.kotlin.com.intellij.openapi.util.ClassExtension;

public class ItemPresentationProviders
extends ClassExtension<ItemPresentationProvider> {
    public static final ItemPresentationProviders INSTANCE = new ItemPresentationProviders();

    private ItemPresentationProviders() {
        super("org.jetbrains.kotlin.com.intellij.itemPresentationProvider");
    }

    @Nullable
    public static <T extends NavigationItem> ItemPresentationProvider<T> getItemPresentationProvider(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/navigation/ItemPresentationProviders", "getItemPresentationProvider"));
        }
        ItemPresentationProvider provider = (ItemPresentationProvider)INSTANCE.forClass(element.getClass());
        return provider;
    }

    @Nullable
    public static ItemPresentation getItemPresentation(@NotNull NavigationItem element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/navigation/ItemPresentationProviders", "getItemPresentation"));
        }
        ItemPresentationProvider<NavigationItem> provider = ItemPresentationProviders.getItemPresentationProvider(element);
        return provider == null ? null : provider.getPresentation(element);
    }
}

