/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.FileSystems;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.PosixFiles;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.Terminals;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.internal.DefaultPosixFiles;
import net.rubygrapefruit.platform.internal.DefaultProcess;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import net.rubygrapefruit.platform.internal.DefaultSystemInfo;
import net.rubygrapefruit.platform.internal.DefaultWindowsRegistry;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.PosixFileSystems;
import net.rubygrapefruit.platform.internal.TerminfoTerminals;
import net.rubygrapefruit.platform.internal.WindowsProcessLauncher;
import net.rubygrapefruit.platform.internal.WindowsTerminals;
import net.rubygrapefruit.platform.internal.WrapperProcess;
import net.rubygrapefruit.platform.internal.WrapperProcessLauncher;
import net.rubygrapefruit.platform.internal.jni.TerminfoFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private static Platform platform;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Platform current() {
        Class<Platform> clazz = Platform.class;
        synchronized (Platform.class) {
            if (platform == null) {
                String osName = Platform.getOperatingSystem().toLowerCase();
                String arch = Platform.getArchitecture();
                if (osName.contains("windows")) {
                    if (arch.equals("x86")) {
                        platform = new Window32Bit();
                    } else if (arch.equals("amd64")) {
                        platform = new Window64Bit();
                    }
                } else if (osName.contains("linux")) {
                    if (arch.equals("amd64")) {
                        platform = new Linux64Bit();
                    } else if (arch.equals("i386") || arch.equals("x86")) {
                        platform = new Linux32Bit();
                    }
                } else if (osName.contains("os x") || osName.contains("darwin")) {
                    if (arch.equals("i386")) {
                        platform = new OsX32Bit();
                    } else if (arch.equals("x86_64") || arch.equals("amd64") || arch.equals("universal")) {
                        platform = new OsX64Bit();
                    }
                } else if (osName.contains("freebsd")) {
                    if (arch.equals("amd64")) {
                        platform = new FreeBSD64Bit();
                    } else if (arch.equals("i386") || arch.equals("x86")) {
                        platform = new FreeBSD32Bit();
                    }
                }
                if (platform == null) {
                    platform = new Unsupported();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    public boolean isWindows() {
        return false;
    }

    public String toString() {
        return String.format("%s %s", Platform.getOperatingSystem(), Platform.getArchitecture());
    }

    public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
        throw new NativeIntegrationUnavailableException(String.format("Native integration %s is not supported for %s.", type2.getSimpleName(), this.toString()));
    }

    public String getLibraryName() {
        throw new NativeIntegrationUnavailableException(String.format("Native integration is not available for %s.", this.toString()));
    }

    public abstract String getId();

    private static String getOperatingSystem() {
        return System.getProperty("os.name");
    }

    private static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    private static class Unsupported
    extends Platform {
        private Unsupported() {
        }

        public String getId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OsX64Bit
    extends OsX {
        private OsX64Bit() {
        }

        public String getId() {
            return "osx-amd64";
        }
    }

    private static class OsX32Bit
    extends OsX {
        private OsX32Bit() {
        }

        public String getId() {
            return "osx-i386";
        }
    }

    private static abstract class OsX
    extends Posix {
        private OsX() {
        }

        public String getLibraryName() {
            return "libnative-platform.dylib";
        }

        String getCursesLibraryName() {
            return "libnative-platform-curses.dylib";
        }
    }

    private static class FreeBSD64Bit
    extends Unix {
        private FreeBSD64Bit() {
        }

        public String getId() {
            return "freebsd-amd64";
        }
    }

    private static class FreeBSD32Bit
    extends Unix {
        private FreeBSD32Bit() {
        }

        public String getId() {
            return "freebsd-i386";
        }
    }

    private static class Linux64Bit
    extends Unix {
        private Linux64Bit() {
        }

        public String getId() {
            return "linux-amd64";
        }
    }

    private static class Linux32Bit
    extends Unix {
        private Linux32Bit() {
        }

        public String getId() {
            return "linux-i386";
        }
    }

    private static abstract class Unix
    extends Posix {
        private Unix() {
        }

        public String getLibraryName() {
            return "libnative-platform.so";
        }

        String getCursesLibraryName() {
            return "libnative-platform-curses.so";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Posix
    extends Platform {
        private Posix() {
        }

        abstract String getCursesLibraryName();

        @Override
        public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
            if (type2.equals(PosixFiles.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultPosixFiles()));
            }
            if (type2.equals(Process.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcess(new DefaultProcess(), false)));
            }
            if (type2.equals(ProcessLauncher.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcessLauncher(new DefaultProcessLauncher())));
            }
            if (type2.equals(Terminals.class)) {
                nativeLibraryLoader.load(this.getCursesLibraryName());
                int nativeVersion = TerminfoFunctions.getVersion();
                if (nativeVersion != 19) {
                    throw new NativeException(String.format("Unexpected native library version loaded. Expected %s, was %s.", nativeVersion, 19));
                }
                return (T)((NativeIntegration)type2.cast(new TerminfoTerminals()));
            }
            if (type2.equals(SystemInfo.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultSystemInfo()));
            }
            if (type2.equals(FileSystems.class)) {
                return (T)((NativeIntegration)type2.cast(new PosixFileSystems()));
            }
            return super.get(type2, nativeLibraryLoader);
        }
    }

    private static class Window64Bit
    extends Windows {
        private Window64Bit() {
        }

        public String getId() {
            return "windows-amd64";
        }
    }

    private static class Window32Bit
    extends Windows {
        private Window32Bit() {
        }

        public String getId() {
            return "windows-i386";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Windows
    extends Platform {
        private Windows() {
        }

        @Override
        public boolean isWindows() {
            return true;
        }

        @Override
        public String getLibraryName() {
            return "native-platform.dll";
        }

        @Override
        public <T extends NativeIntegration> T get(Class<T> type2, NativeLibraryLoader nativeLibraryLoader) {
            if (type2.equals(Process.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcess(new DefaultProcess(), true)));
            }
            if (type2.equals(Terminals.class)) {
                return (T)((NativeIntegration)type2.cast(new WindowsTerminals()));
            }
            if (type2.equals(ProcessLauncher.class)) {
                return (T)((NativeIntegration)type2.cast(new WrapperProcessLauncher(new WindowsProcessLauncher(new DefaultProcessLauncher()))));
            }
            if (type2.equals(SystemInfo.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultSystemInfo()));
            }
            if (type2.equals(FileSystems.class)) {
                return (T)((NativeIntegration)type2.cast(new PosixFileSystems()));
            }
            if (type2.equals(WindowsRegistry.class)) {
                return (T)((NativeIntegration)type2.cast(new DefaultWindowsRegistry()));
            }
            return super.get(type2, nativeLibraryLoader);
        }
    }
}

