/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import java.util.Collection;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentMultiMap;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticsElementsCache {
    private final Diagnostics diagnostics;
    private final Function1<Diagnostic, Boolean> filter;
    private final AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>> elementToDiagnostic = new AtomicNotNullLazyValue<MultiMap<PsiElement, Diagnostic>>(){

        @Override
        @NotNull
        protected MultiMap<PsiElement, Diagnostic> compute() {
            MultiMap multiMap = DiagnosticsElementsCache.buildElementToDiagnosticCache(DiagnosticsElementsCache.this.diagnostics, DiagnosticsElementsCache.this.filter);
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache$1", "compute"));
            }
            return multiMap;
        }
    };

    public DiagnosticsElementsCache(Diagnostics diagnostics, Function1<Diagnostic, Boolean> filter2) {
        this.diagnostics = diagnostics;
        this.filter = filter2;
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache", "getDiagnostics"));
        }
        Collection<Diagnostic> collection = this.elementToDiagnostic.getValue().get(psiElement);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsElementsCache", "getDiagnostics"));
        }
        return collection;
    }

    private static MultiMap<PsiElement, Diagnostic> buildElementToDiagnosticCache(Diagnostics diagnostics, Function1<Diagnostic, Boolean> filter2) {
        ConcurrentMultiMap<PsiElement, Diagnostic> elementToDiagnostic = new ConcurrentMultiMap<PsiElement, Diagnostic>();
        for (Diagnostic diagnostic : diagnostics) {
            if (!filter2.invoke(diagnostic).booleanValue()) continue;
            elementToDiagnostic.putValue(diagnostic.getPsiElement(), diagnostic);
        }
        return elementToDiagnostic;
    }
}

