/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.impl.IrAnonymousInitializerImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrErrorDeclarationImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionBase;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeAliasImpl;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.PropertyGenerator;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010'\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010,\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020-R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "createBodyGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "generateAnonymousInitializerDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ktAnonymousInitializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateClassMemberDeclaration", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "generateClassOrObjectDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "generateEnumEntryDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "generateFunctionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "scopeOwner", "ktBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ktFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "generateInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "generateMemberDeclaration", "generateSecondaryConstructor", "ktConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "generateSecondaryConstructorWithNestedInitializers", "generateTypeAliasDeclaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin-compiler"})
public final class DeclarationGenerator
implements Generator {
    @NotNull
    private final GeneratorContext context;

    @NotNull
    public final IrDeclaration generateMemberDeclaration(@NotNull KtDeclaration ktDeclaration) {
        IrDeclaration irDeclaration;
        Intrinsics.checkParameterIsNotNull(ktDeclaration, "ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtNamedFunction) {
            irDeclaration = this.generateFunctionDeclaration((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            irDeclaration = new PropertyGenerator(this).generatePropertyDeclaration((KtProperty)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassOrObject) {
            irDeclaration = this.generateClassOrObjectDeclaration((KtClassOrObject)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtTypeAlias) {
            irDeclaration = this.generateTypeAliasDeclaration((KtTypeAlias)ktDeclaration);
        } else {
            int n = PsiUtilsKt.getStartOffset(ktDeclaration);
            int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
            ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
            Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, "BindingContext.DECLARATION_TO_DESCRIPTOR");
            DeclarationDescriptor declarationDescriptor = GeneratorKt.getOrFail(this, readOnlySlice, ktDeclaration);
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "getOrFail(BindingContext\u2026ESCRIPTOR, ktDeclaration)");
            irDeclaration = new IrErrorDeclarationImpl(n, n2, declarationDescriptor);
        }
        return irDeclaration;
    }

    @NotNull
    public final IrDeclaration generateClassMemberDeclaration(@NotNull KtDeclaration ktDeclaration, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(ktDeclaration, "ktDeclaration");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        return ktDeclaration2 instanceof KtAnonymousInitializer ? this.generateAnonymousInitializerDeclaration((KtAnonymousInitializer)ktDeclaration, classDescriptor) : (ktDeclaration2 instanceof KtSecondaryConstructor ? (IrDeclaration)this.generateSecondaryConstructor((KtSecondaryConstructor)ktDeclaration) : (ktDeclaration2 instanceof KtEnumEntry ? (IrDeclaration)this.generateEnumEntryDeclaration((KtEnumEntry)ktDeclaration) : this.generateMemberDeclaration(ktDeclaration)));
    }

    private final IrEnumEntry generateEnumEntryDeclaration(KtEnumEntry ktEnumEntry) {
        return new ClassGenerator(this).generateEnumEntry(ktEnumEntry);
    }

    @NotNull
    public final IrClass generateClassOrObjectDeclaration(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull(ktClassOrObject, "ktClassOrObject");
        return new ClassGenerator(this).generateClass(ktClassOrObject);
    }

    @NotNull
    public final IrDeclaration generateTypeAliasDeclaration(@NotNull KtTypeAlias ktDeclaration) {
        Intrinsics.checkParameterIsNotNull(ktDeclaration, "ktDeclaration");
        int n = PsiUtilsKt.getStartOffset(ktDeclaration);
        int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        WritableSlice<PsiElement, TypeAliasDescriptor> writableSlice = BindingContext.TYPE_ALIAS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.TYPE_ALIAS");
        Object v = GeneratorKt.getOrFail(this, writableSlice, ktDeclaration);
        Intrinsics.checkExpressionValueIsNotNull(v, "getOrFail(BindingContext\u2026YPE_ALIAS, ktDeclaration)");
        return new IrTypeAliasImpl(n, n2, irDeclarationOrigin, (TypeAliasDescriptor)v);
    }

    @NotNull
    public final IrDeclaration generateAnonymousInitializerDeclaration(@NotNull KtAnonymousInitializer ktAnonymousInitializer, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(ktAnonymousInitializer, "ktAnonymousInitializer");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        IrAnonymousInitializerImpl irAnonymousInitializer = new IrAnonymousInitializerImpl(PsiUtilsKt.getStartOffset(ktAnonymousInitializer), PsiUtilsKt.getEndOffset(ktAnonymousInitializer), IrDeclarationOrigin.DEFINED.INSTANCE, classDescriptor);
        irAnonymousInitializer.setBody(new BodyGenerator(classDescriptor, this.getContext()).generateAnonymousInitializerBody(ktAnonymousInitializer));
        return irAnonymousInitializer;
    }

    @NotNull
    public final IrFunction generateFunctionDeclaration(@NotNull KtNamedFunction ktFunction) {
        IrBody irBody;
        Intrinsics.checkParameterIsNotNull(ktFunction, "ktFunction");
        WritableSlice<PsiElement, SimpleFunctionDescriptor> writableSlice = BindingContext.FUNCTION;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.FUNCTION");
        SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)GeneratorKt.getOrFail(this, writableSlice, ktFunction);
        int n = PsiUtilsKt.getStartOffset(ktFunction);
        int n2 = PsiUtilsKt.getEndOffset(ktFunction);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor, "functionDescriptor");
        IrFunctionImpl irFunction = new IrFunctionImpl(n, n2, irDeclarationOrigin, simpleFunctionDescriptor);
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = functionDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptor2, "functionDescriptor");
        BodyGenerator bodyGenerator = this.createBodyGenerator(simpleFunctionDescriptor2);
        bodyGenerator.generateDefaultParameters(ktFunction, (IrFunctionBase)irFunction);
        IrFunctionImpl irFunctionImpl = irFunction;
        KtExpression ktExpression = ktFunction.getBodyExpression();
        if (ktExpression != null) {
            KtExpression it;
            KtExpression ktExpression2 = ktExpression;
            IrFunctionImpl irFunctionImpl2 = irFunctionImpl;
            KtExpression ktExpression3 = it = ktExpression2;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "it");
            IrBody irBody2 = bodyGenerator.generateFunctionBody(ktExpression3);
            irFunctionImpl = irFunctionImpl2;
            irBody = irBody2;
        } else {
            irBody = null;
        }
        irFunctionImpl.setBody(irBody);
        return irFunction;
    }

    @NotNull
    public final IrFunction generateSecondaryConstructor(@NotNull KtSecondaryConstructor ktConstructor) {
        Intrinsics.checkParameterIsNotNull(ktConstructor, "ktConstructor");
        if (KotlinUtilsKt.isConstructorDelegatingToSuper(ktConstructor, this.getContext().getBindingContext())) {
            return this.generateSecondaryConstructorWithNestedInitializers(ktConstructor);
        }
        WritableSlice<PsiElement, ConstructorDescriptor> writableSlice = BindingContext.CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.CONSTRUCTOR");
        Object v = GeneratorKt.getOrFail(this, writableSlice, ktConstructor);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
        }
        ClassConstructorDescriptor constructorDescriptor = (ClassConstructorDescriptor)v;
        IrConstructorImpl irConstructor = new IrConstructorImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor), IrDeclarationOrigin.DEFINED.INSTANCE, constructorDescriptor);
        BodyGenerator bodyGenerator = this.createBodyGenerator(constructorDescriptor);
        bodyGenerator.generateDefaultParameters(ktConstructor, (IrFunctionBase)irConstructor);
        irConstructor.setBody(bodyGenerator.generateSecondaryConstructorBody(ktConstructor));
        return irConstructor;
    }

    private final IrFunction generateSecondaryConstructorWithNestedInitializers(KtSecondaryConstructor ktConstructor) {
        WritableSlice<PsiElement, ConstructorDescriptor> writableSlice = BindingContext.CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, "BindingContext.CONSTRUCTOR");
        Object v = GeneratorKt.getOrFail(this, writableSlice, ktConstructor);
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor");
        }
        ClassConstructorDescriptor constructorDescriptor = (ClassConstructorDescriptor)v;
        IrConstructorImpl irConstructor = new IrConstructorImpl(PsiUtilsKt.getStartOffset(ktConstructor), PsiUtilsKt.getEndOffset(ktConstructor), IrDeclarationOrigin.DEFINED.INSTANCE, constructorDescriptor);
        BodyGenerator bodyGenerator = this.createBodyGenerator(constructorDescriptor);
        bodyGenerator.generateDefaultParameters(ktConstructor, (IrFunctionBase)irConstructor);
        irConstructor.setBody(this.createBodyGenerator(constructorDescriptor).generateSecondaryConstructorBodyWithNestedInitializers(ktConstructor));
        return irConstructor;
    }

    @NotNull
    public final IrBody generateFunctionBody(@NotNull CallableDescriptor scopeOwner, @NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        Intrinsics.checkParameterIsNotNull(ktBody, "ktBody");
        return this.createBodyGenerator(scopeOwner).generateFunctionBody(ktBody);
    }

    @NotNull
    public final IrExpressionBody generateInitializerBody(@NotNull CallableDescriptor scopeOwner, @NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull(scopeOwner, "scopeOwner");
        Intrinsics.checkParameterIsNotNull(ktBody, "ktBody");
        return this.createBodyGenerator(scopeOwner).generatePropertyInitializerBody(ktBody);
    }

    private final BodyGenerator createBodyGenerator(CallableDescriptor descriptor2) {
        return new BodyGenerator(descriptor2, this.getContext());
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public DeclarationGenerator(@NotNull GeneratorContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }
}

