/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.BuiltInPropertyIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "kotlin-compiler"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression, @NotNull TranslationContext context) {
        JsStatement bodyStatement;
        JsStatement jsStatement;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression ktExpression = expression.getCondition();
        if (ktExpression == null) {
            throw (Throwable)new IllegalArgumentException("condition expression should not be null: " + expression.getText());
        }
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsCondition = Translation.translateAsExpression(conditionExpression, context, conditionBlock);
        KtExpression body = expression.getBody();
        if (body != null) {
            JsStatement jsStatement2 = Translation.translateAsStatementAndMergeInBlockIfNeeded(body, context);
            jsStatement = jsStatement2;
            Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "Translation.translateAsS\u2026ckIfNeeded(body, context)");
        } else {
            jsStatement = bodyStatement = (JsStatement)JsEmpty.INSTANCE;
        }
        if (!conditionBlock.isEmpty()) {
            JsIf breakIfConditionIsFalseStatement = new JsIf(JsAstUtils.not(jsCondition), new JsBreak());
            JsBlock bodyBlock = JsAstUtils.convertToBlock(bodyStatement);
            jsCondition = JsLiteral.TRUE;
            if (doWhile) {
                JsExpression secondRun = context.defineTemporary(JsLiteral.FALSE);
                conditionBlock.getStatements().add(breakIfConditionIsFalseStatement);
                JsIf ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, JsLiteral.TRUE).makeStmt());
                bodyBlock.getStatements().add(0, ifStatement);
            } else {
                conditionBlock.getStatements().add(breakIfConditionIsFalseStatement);
                List<JsStatement> list2 = bodyBlock.getStatements();
                List<JsStatement> list3 = conditionBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list3, "conditionBlock.statements");
                list2.addAll(0, (Collection<JsStatement>)list3);
            }
            JsBlock jsBlock = bodyBlock;
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "bodyBlock");
            bodyStatement = jsBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression);
        if (jsNode == null) {
            Intrinsics.throwNpe();
        }
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression, @NotNull TranslationContext context) {
        KtParameter loopParameter;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KtExpression loopRange = PsiUtils.getLoopRange(expression);
        KotlinType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        Function0<Boolean> isForOverRange$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                Object object = this.$rangeType.getConstructor().getDeclarationDescriptor();
                if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
                    return false;
                }
                Object fqn = object;
                return Intrinsics.areEqual(((FqName)fqn).asString(), "kotlin.ranges.IntRange");
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        Function0<Boolean> isForOverRangeLiteral$ = new Function0<Boolean>(loopRange, isForOverRange$){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.1 $isForOverRange;

            public final boolean invoke() {
                return this.$loopRange instanceof KtBinaryExpression && Intrinsics.areEqual(((KtBinaryExpression)this.$loopRange).getOperationToken(), KtTokens.RANGE) && this.$isForOverRange.invoke();
            }
            {
                this.$loopRange = ktExpression;
                this.$isForOverRange = var2_2;
                super(0);
            }
        };
        Function0<Boolean> isForOverArray$ = new Function0<Boolean>(rangeType){
            final /* synthetic */ KotlinType $rangeType;

            public final boolean invoke() {
                return KotlinBuiltIns.isArray(this.$rangeType) || KotlinBuiltIns.isPrimitiveArray(this.$rangeType);
            }
            {
                this.$rangeType = kotlinType;
                super(0);
            }
        };
        KtParameter ktParameter = expression.getLoopParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        KtParameter ktParameter2 = loopParameter = ktParameter;
        KtDestructuringDeclaration destructuringParameter = ktParameter2 != null ? ktParameter2.getDestructuringDeclaration() : null;
        JsName parameterName = destructuringParameter == null ? context.getNameForElement(loopParameter) : context.scope().declareTemporary();
        Function1<JsExpression, JsStatement> translateBody$ = new Function1<JsExpression, JsStatement>(expression, context, destructuringParameter, parameterName){
            final /* synthetic */ KtForExpression $expression;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
            final /* synthetic */ JsName $parameterName;

            @Nullable
            public final JsStatement invoke(@Nullable JsExpression itemValue) {
                JsVars currentVarInit;
                JsStatement realBody;
                JsStatement jsStatement;
                KtExpression ktExpression = this.$expression.getBody();
                if (ktExpression != null) {
                    KtExpression ktExpression2;
                    KtExpression it = ktExpression2 = ktExpression;
                    jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, this.$context);
                } else {
                    jsStatement = realBody = null;
                }
                if (itemValue == null && this.$destructuringParameter == null) {
                    return realBody;
                }
                JsVars jsVars = currentVarInit = this.$destructuringParameter == null ? JsAstUtils.newVar(this.$parameterName, itemValue) : DestructuringDeclarationTranslator.translate(this.$destructuringParameter, this.$parameterName, itemValue, this.$context);
                if (realBody == null) {
                    return new JsBlock((JsStatement)currentVarInit);
                }
                JsBlock block = JsAstUtils.convertToBlock(realBody);
                block.getStatements().add(0, currentVarInit);
                return block;
            }
            {
                this.$expression = ktForExpression;
                this.$context = translationContext;
                this.$destructuringParameter = ktDestructuringDeclaration;
                this.$parameterName = jsName;
                super(1);
            }
        };
        Function0<JsStatement> translateForOverLiteralRange$ = new Function0<JsStatement>(loopRange, context, translateBody$, parameterName){
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ translateForExpression.4 $translateBody;
            final /* synthetic */ JsName $parameterName;

            @NotNull
            public final JsStatement invoke() {
                if (!(this.$loopRange instanceof KtBinaryExpression)) {
                    throw (Throwable)new IllegalStateException("expected JetBinaryExpression, but " + this.$loopRange.getText());
                }
                JsBlock startBlock = new JsBlock();
                JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.$context, (KtBinaryExpression)this.$loopRange, startBlock);
                JsBlock endBlock = new JsBlock();
                JsExpression rightExpression = TranslationUtils.translateRightExpression(this.$context, (KtBinaryExpression)this.$loopRange, endBlock);
                JsExpression rangeStart = this.$context.cacheExpressionIfNeeded(leftExpression);
                this.$context.addStatementsToCurrentBlockFrom(startBlock);
                this.$context.addStatementsToCurrentBlockFrom(endBlock);
                JsExpression rangeEnd = this.$context.defineTemporary(rightExpression);
                JsStatement body = this.$translateBody.invoke(null);
                JsBinaryOperation conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), rangeEnd);
                JsPostfixOperation incrementExpression = new JsPostfixOperation(JsUnaryOperator.INC, this.$parameterName.makeRef());
                return new JsFor(JsAstUtils.newVar(this.$parameterName, rangeStart), (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$loopRange = ktExpression;
                this.$context = translationContext;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverRange$ = new Function0<JsStatement>(context, loopRange, translateBody$, parameterName){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.4 $translateBody;
            final /* synthetic */ JsName $parameterName;

            @NotNull
            public final JsStatement invoke() {
                JsExpression rangeExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                Function1<String, JsExpression> getProperty$ = new Function1<String, JsExpression>(rangeExpression){
                    final /* synthetic */ JsExpression $rangeExpression;

                    @NotNull
                    public final JsExpression invoke(@NotNull String funName) {
                        Intrinsics.checkParameterIsNotNull(funName, "funName");
                        return new JsNameRef(funName, this.$rangeExpression);
                    }
                    {
                        this.$rangeExpression = jsExpression;
                        super(1);
                    }
                };
                JsExpression start = this.$context.defineTemporary(getProperty$.invoke("first"));
                JsExpression end = this.$context.defineTemporary(getProperty$.invoke("last"));
                JsExpression increment = this.$context.defineTemporary(getProperty$.invoke("step"));
                JsStatement body = this.$translateBody.invoke(null);
                JsBinaryOperation conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), end);
                JsBinaryOperation incrementExpression = JsAstUtils.addAssign(this.$parameterName.makeRef(), increment);
                return new JsFor(JsAstUtils.newVar(this.$parameterName, start), (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                this.$parameterName = jsName;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverArray$ = new Function0<JsStatement>(context, loopRange, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.4 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                JsExpression rangeExpression;
                JsExpression jsExpression = rangeExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                BuiltInPropertyIntrinsic builtInPropertyIntrinsic = CompositeFIF.LENGTH_PROPERTY_INTRINSIC;
                List<T> list2 = CollectionsKt.emptyList();
                JsExpression length = builtInPropertyIntrinsic.apply(jsExpression, list2, this.$context);
                JsExpression end = this.$context.defineTemporary(length);
                TemporaryVariable index2 = this.$context.declareTemporary(this.$context.program().getNumberLiteral(0));
                JsArrayAccess arrayAccess = new JsArrayAccess(rangeExpression, index2.reference());
                JsStatement body = this.$translateBody.invoke(arrayAccess);
                JsBinaryOperation initExpression = JsAstUtils.assignment(index2.reference(), this.$context.program().getNumberLiteral(0));
                JsBinaryOperation conditionExpression = JsAstUtils.inequality(index2.reference(), end);
                JsPrefixOperation incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference());
                return new JsFor(initExpression, (JsExpression)conditionExpression, (JsExpression)incrementExpression, body);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                super(0);
            }
        };
        Function0<JsStatement> translateForOverIterator$ = new Function0<JsStatement>(context, loopRange, translateBody$){
            final /* synthetic */ TranslationContext $context;
            final /* synthetic */ KtExpression $loopRange;
            final /* synthetic */ translateForExpression.4 $translateBody;

            @NotNull
            public final JsStatement invoke() {
                List<T> list2;
                List<JsStatement> list3;
                Iterable<Object> iterable;
                Collection collection;
                JsExpression jsExpression;
                Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression> translateMethodInvocation$ = new Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression>(this){
                    final /* synthetic */ translateForExpression.8 this$0;

                    @NotNull
                    public final JsExpression invoke(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull JsBlock block) {
                        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
                        Intrinsics.checkParameterIsNotNull(block, "block");
                        TranslationContext translationContext = this.this$0.$context.innerBlock(block);
                        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context.innerBlock(block)");
                        return CallTranslator.translate(translationContext, resolvedCall2, receiver);
                    }
                    {
                        this.this$0 = var1_1;
                        super(3);
                    }
                };
                Function0<JsExpression> iteratorMethodInvocation$ = new Function0<JsExpression>(this){
                    final /* synthetic */ translateForExpression.8 this$0;

                    @NotNull
                    public final JsExpression invoke() {
                        JsExpression range = Translation.translateAsExpression(this.this$0.$loopRange, this.this$0.$context);
                        ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        TranslationContext translationContext = this.this$0.$context;
                        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                        return CallTranslator.translate(translationContext, resolvedCall3, range);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                };
                JsExpression iteratorVar = this.$context.defineTemporary((JsExpression)iteratorMethodInvocation$.invoke());
                Function1<JsBlock, JsExpression> hasNextMethodInvocation$ = new Function1<JsBlock, JsExpression>(this, translateMethodInvocation$, iteratorVar){
                    final /* synthetic */ translateForExpression.8 this$0;
                    final /* synthetic */ translateForExpression.1 $translateMethodInvocation;
                    final /* synthetic */ JsExpression $iteratorVar;

                    @NotNull
                    public final JsExpression invoke(@NotNull JsBlock block) {
                        ResolvedCall<FunctionDescriptor> resolvedCall2;
                        Intrinsics.checkParameterIsNotNull(block, "block");
                        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = BindingUtils.getHasNextCallable(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                        Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "resolvedCall");
                        return this.$translateMethodInvocation.invoke(this.$iteratorVar, resolvedCall3, block);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$translateMethodInvocation = var2_2;
                        this.$iteratorVar = jsExpression;
                        super(1);
                    }
                };
                JsBlock hasNextBlock = new JsBlock();
                JsExpression hasNextInvocation = hasNextMethodInvocation$.invoke(hasNextBlock);
                JsBlock nextBlock = new JsBlock();
                ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction(this.$context.bindingContext(), this.$loopRange);
                Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, "getNextFunction(context.\u2026dingContext(), loopRange)");
                JsExpression nextInvoke = translateMethodInvocation$.invoke(iteratorVar, resolvedCall2, nextBlock);
                List bodyStatements = new ArrayList<E>();
                if (hasNextBlock.isEmpty()) {
                    jsExpression = hasNextInvocation;
                } else {
                    collection = bodyStatements;
                    List<JsStatement> list4 = hasNextBlock.getStatements();
                    Intrinsics.checkExpressionValueIsNotNull(list4, "hasNextBlock.statements");
                    iterable = list4;
                    CollectionsKt.addAll(collection, iterable);
                    collection = bodyStatements;
                    iterable = new JsIf(JsAstUtils.notOptimized(hasNextInvocation), new JsBreak());
                    collection.add(iterable);
                    jsExpression = JsLiteral.TRUE;
                }
                JsExpression exitCondition = jsExpression;
                collection = bodyStatements;
                List<JsStatement> list5 = nextBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list5, "nextBlock.statements");
                iterable = list5;
                CollectionsKt.addAll(collection, iterable);
                collection = bodyStatements;
                JsStatement jsStatement = this.$translateBody.invoke(nextInvoke);
                if (jsStatement != null) {
                    iterable = jsStatement;
                    JsStatement p1 = (JsStatement)((Object)iterable);
                    list3 = JsAstUtils.flattenStatement(p1);
                } else {
                    list3 = null;
                }
                if ((list2 = (iterable = list3)) == null) {
                    list2 = CollectionsKt.emptyList();
                }
                iterable = list2;
                CollectionsKt.addAll(collection, iterable);
                JsStatement jsStatement2 = (JsStatement)CollectionsKt.singleOrNull(bodyStatements);
                if (jsStatement2 == null) {
                    jsStatement2 = new JsBlock(bodyStatements);
                }
                return new JsWhile(exitCondition, jsStatement2);
            }
            {
                this.$context = translationContext;
                this.$loopRange = ktExpression;
                this.$translateBody = var3_3;
                super(0);
            }
        };
        return isForOverRangeLiteral$.invoke() ? translateForOverLiteralRange$.invoke() : (isForOverRange$.invoke() ? translateForOverRange$.invoke() : (isForOverArray$.invoke() ? translateForOverArray$.invoke() : translateForOverIterator$.invoke()));
    }
}

