/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "refreshLabelNames", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "kotlin-compiler"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        boolean bl2 = bl = arguments2.size() <= parameters2.size();
        if (!bl) {
            String string = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (Pair pair : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsName jsName;
            JsExpression arg = (JsExpression)pair.component1();
            JsParameter param = (JsParameter)pair.component2();
            JsName paramName = param.getName();
            String string = paramName.getIdent();
            Intrinsics.checkExpressionValueIsNotNull(string, "paramName.ident");
            JsName $receiver = jsName = context.getTemporaryName(string);
            MetadataProperties.setStaticRef($receiver, arg);
            context.newVar($receiver, arg.deepCopy());
            JsNameRef replacement = jsName.makeRef();
            JsName jsName2 = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "paramName");
            JsNameRef jsNameRef = replacement;
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "replacement");
            context.replaceName(jsName2, jsNameRef);
        }
        List<JsParameter> defaultParams = parameters2.subList(arguments2.size(), parameters2.size());
        for (JsParameter defaultParam : defaultParams) {
            JsName paramName = defaultParam.getName();
            String string = paramName.getIdent();
            Intrinsics.checkExpressionValueIsNotNull(string, "paramName.ident");
            JsName freshName = context.getTemporaryName(string);
            NamingContext.newVar$default(context, freshName, null, 2, null);
            JsName jsName = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            JsNameRef jsNameRef = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "freshName.makeRef()");
            context.replaceName(jsName, jsNameRef);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "function.body");
        for (JsName name2 : CollectUtilsKt.collectDefinedNames(jsBlock)) {
            JsName jsName;
            String string = name2.getIdent();
            Intrinsics.checkExpressionValueIsNotNull(string, "name.ident");
            JsName $receiver = jsName = context.getTemporaryName(string);
            MetadataProperties.setStaticRef($receiver, MetadataProperties.getStaticRef(name2));
            JsName temporaryName = jsName;
            JsNameRef jsNameRef = temporaryName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "temporaryName.makeRef()");
            context.replaceName(name2, jsNameRef);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (!(scope instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkExpressionValueIsNotNull(jsNode, "visitor.accept(node)");
        return jsNode;
    }
}

