/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0013H\u0016R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/ScopeCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "()V", "scopeTree", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "", "getScopeTree", "()Ljava/util/Map;", "recordScope", "", "scope", "visitCatch", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsCatch;", "visitElement", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "kotlin-compiler"})
final class ScopeCollector
extends RecursiveJsVisitor {
    @NotNull
    private final Map<JsScope, Set<JsScope>> scopeTree;

    @NotNull
    public final Map<JsScope, Set<JsScope>> getScopeTree() {
        return this.scopeTree;
    }

    @Override
    public void visitCatch(@NotNull JsCatch x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        JsScope jsScope = x.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "x.scope");
        this.recordScope(jsScope);
        super.visitCatch(x);
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        JsFunctionScope jsFunctionScope = x.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsFunctionScope, "x.scope");
        this.recordScope(jsFunctionScope);
        super.visitFunction(x);
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        if (node instanceof HasName) {
            JsName jsName = ((HasName)((Object)node)).getName();
            if (jsName != null) {
                JsName jsName2;
                JsName it = jsName2 = jsName;
                JsScope jsScope = it.getEnclosing();
                Intrinsics.checkExpressionValueIsNotNull(jsScope, "it.enclosing");
                this.recordScope(jsScope);
            }
        }
        super.visitElement(node);
    }

    private final void recordScope(JsScope scope) {
        Map<JsScope, Set<JsScope>> map2 = this.scopeTree;
        Object object = map2;
        Map<JsScope, Set<JsScope>> map3 = object;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (map3.containsKey(scope) ^ true) {
            map2 = this.scopeTree;
            object = new LinkedHashSet();
            map2.put(scope, (Set<JsScope>)object);
            JsScope parent2 = scope.getParent();
            if (parent2 != null) {
                this.recordScope(parent2);
                Set<JsScope> set = this.scopeTree.get(parent2);
                if (set == null) {
                    Intrinsics.throwNpe();
                }
                set.add(scope);
            }
        }
    }

    public ScopeCollector() {
        Map map2;
        ScopeCollector scopeCollector = this;
        scopeCollector.scopeTree = map2 = (Map)new LinkedHashMap();
    }
}

