/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ConcurrentHashMultiset;
import org.jetbrains.kotlin.com.intellij.concurrency.JobScheduler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationEx;
import org.jetbrains.kotlin.com.intellij.openapi.progress.EmptyProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.StandardProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.Task;
import org.jetbrains.kotlin.com.intellij.openapi.progress.WrappedProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.impl.NonCancelableIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.SmartHashSet;
import org.jetbrains.kotlin.com.intellij.util.io.storage.HeavyProcessLatch;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static boolean ourMaySleepInCheckCanceled;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    private static volatile boolean shouldCheckCanceled;
    private static final Collection<ProgressIndicator> nonStandardIndicators;

    public CoreProgressManager() {
        HeavyProcessLatch.INSTANCE.addUIActivityListener(this, new HeavyProcessLatch.HeavyProcessListener(){

            @Override
            public void processFinished() {
                CoreProgressManager.updateShouldCheckCanceled();
            }
        });
    }

    @NotNull
    private ScheduledFuture<?> startBackgroundIndicatorPing() {
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        CoreProgressManager.this.indicatorCanceled(indicator);
                    }
                }
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "startBackgroundIndicatorPing"));
        }
        return scheduledFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            if (this.myCheckCancelledFuture != null) {
                this.myCheckCancelledFuture.cancel(true);
                this.myCheckCancelledFuture = null;
            }
        }
    }

    public static boolean sleepIfNeeded() {
        if (ourMaySleepInCheckCanceled && HeavyProcessLatch.INSTANCE.isInsideLowPriorityThread()) {
            TimeoutUtil.sleep(1L);
            return true;
        }
        return false;
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        if (!shouldCheckCanceled) {
            return;
        }
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null && ENABLED) {
            progress.checkCanceled();
        } else {
            CoreProgressManager.sleepIfNeeded();
        }
    }

    @Override
    public void runProcess(final @NotNull Runnable process2, final ProgressIndicator progress) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcess"));
        }
        this.executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        if (progress != null && !progress.isRunning()) {
                            progress.start();
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                    process2.run();
                }
                finally {
                    if (progress != null && progress.isRunning()) {
                        progress.stop();
                        if (progress instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)progress).processFinish();
                        }
                    }
                }
            }
        }, progress);
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "executeNonCancelableSection"));
        }
        this.executeProcessUnderProgress(runnable, NonCancelableIndicator.INSTANCE);
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "run"));
        }
        if (task.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                new TaskRunnable(task, new EmptyProgressIndicator()).run();
            }
        } else if (task.isModal()) {
            this.runProcessWithProgressSynchronously(task.asModal(), null);
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                this.runProcessWithProgressAsynchronously(backgroundable);
            }
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation2, ModalityState.NON_MODAL);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2, final @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        final TaskRunnable process2 = new TaskRunnable(task, progressIndicator, continuation2);
        TaskContainer action = new TaskContainer(task){

            @Override
            public void run() {
                boolean processCanceled = false;
                Exception exception = null;
                try {
                    ProgressManager.getInstance().runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Exception e) {
                    exception = e;
                }
                final boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                final Exception finalException = exception;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoreProgressManager.finishTask(task, finalCanceled, finalException);
                    }
                }, modalityState);
            }
        };
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(action);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "runProcessWithProgressSynchronously"));
        }
        final Ref exceptionRef = new Ref();
        TaskContainer taskContainer = new TaskContainer(task){

            @Override
            public void run() {
                try {
                    new TaskRunnable(task, ProgressManager.getInstance().getProgressIndicator()).run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    exceptionRef.set(e);
                }
            }
        };
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        CoreProgressManager.finishTask(task, !result2, (Exception)exceptionRef.get());
        return result2;
    }

    protected static void finishTask(@NotNull Task task, boolean canceled, @Nullable Exception exception) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "finishTask"));
        }
        try {
            if (exception != null) {
                task.onError(exception);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        block12: {
            boolean modal;
            if (process2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "executeProcessUnderProgress"));
            }
            boolean bl = modal = progress != null && progress.isModal();
            if (modal) {
                this.myCurrentModalProgressCount.incrementAndGet();
            }
            if (progress == null) {
                this.myCurrentUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set;
                ProgressIndicator oldIndicator = null;
                boolean bl2 = set = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set) {
                    Thread currentThread = Thread.currentThread();
                    CoreProgressManager.setCurrentIndicator(currentThread, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
                        break block12;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(currentThread, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress == null) {
                    this.myCurrentUnsafeProgressCount.decrementAndGet();
                }
                if (modal) {
                    this.myCurrentModalProgressCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        ArrayList<Set<Thread>> threadsUnderThisIndicator = new ArrayList<Set<Thread>>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Set<Thread> underIndicator = threadsUnderIndicator.get(thisIndicator);
                if (underIndicator == null) {
                    underIndicator = new SmartHashSet<Thread>();
                    threadsUnderIndicator.put(thisIndicator, underIndicator);
                }
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    if (this.myCheckCancelledFuture == null) {
                        this.myCheckCancelledFuture = this.startBackgroundIndicatorPing();
                    }
                }
                if (thisIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                } else {
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            CoreProgressManager.updateShouldCheckCanceled();
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard;
                    boolean removed;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if (!(isStandard = thisIndicator2 instanceof StandardProgressIndicator)) {
                        nonStandardIndicators.remove(thisIndicator2);
                        if (nonStandardIndicators.isEmpty()) {
                            this.myCheckCancelledFuture.cancel(true);
                            this.myCheckCancelledFuture = null;
                        }
                    }
                    if (oldIndicator != null && oldIndicator.isCanceled()) {
                        threadsUnderCanceledIndicator.add(currentThread);
                        continue;
                    }
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                CoreProgressManager.updateShouldCheckCanceled();
            }
            throw throwable;
        }
        synchronized (map2) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean isStandard;
                boolean removed;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed = underIndicator != null && underIndicator.remove(currentThread);
                if (removed && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (!(isStandard = thisIndicator instanceof StandardProgressIndicator)) {
                    nonStandardIndicators.remove(thisIndicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.myCheckCancelledFuture.cancel(true);
                        this.myCheckCancelledFuture = null;
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                    continue;
                }
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            CoreProgressManager.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateShouldCheckCanceled() {
        ourMaySleepInCheckCanceled = Registry.is("ide.prioritize.ui.thread", false);
        if (ourMaySleepInCheckCanceled && HeavyProcessLatch.INSTANCE.hasPrioritizedThread()) {
            shouldCheckCanceled = true;
            return;
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            shouldCheckCanceled = !threadsUnderCanceledIndicator.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "indicatorCanceled"));
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread2 : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread2);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread2);
                    shouldCheckCanceled = true;
                }
            }
        }
    }

    private static void setCurrentIndicator(@NotNull Thread currentThread, ProgressIndicator indicator) {
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "setCurrentIndicator"));
        }
        if (indicator == null) {
            currentIndicators.remove(currentThread.getId());
        } else {
            currentIndicators.put(currentThread.getId(), indicator);
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread2) {
        if (thread2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager", "getCurrentIndicator"));
        }
        return currentIndicators.get(thread2.getId());
    }

    static {
        threadsUnderIndicator = new THashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = ContainerUtil.newConcurrentSet();
        nonStandardIndicators = ConcurrentHashMultiset.create();
    }

    protected static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        public TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            this(task, indicator, null);
        }

        public TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation2) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable", "<init>"));
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation2;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish(this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "<init>"));
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer", "getTask"));
            }
            return task;
        }

        public String toString() {
            return this.myTask.toString();
        }
    }
}

