/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.base.Predicates;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/types/CastDiagnosticsUtil;", "", "()V", "allParametersReified", "", "subtype", "Lorg/jetbrains/kotlin/types/KotlinType;", "findStaticallyKnownSubtype", "Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "supertype", "subtypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "isCastErased", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "isCastPossible", "lhsType", "rhsType", "platformToKotlinClassMap", "Lorg/jetbrains/kotlin/platform/PlatformToKotlinClassMap;", "isFinal", "type", "isRelated", "a", "b", "isTrait", "mapToPlatformClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-compiler"})
public final class CastDiagnosticsUtil {
    public static final CastDiagnosticsUtil INSTANCE;

    @JvmStatic
    public static final boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        Intrinsics.checkParameterIsNotNull(lhsType, "lhsType");
        Intrinsics.checkParameterIsNotNull(rhsType, "rhsType");
        Intrinsics.checkParameterIsNotNull(platformToKotlinClassMap, "platformToKotlinClassMap");
        boolean rhsNullable = TypeUtils.isNullableType(rhsType);
        boolean lhsNullable = TypeUtils.isNullableType(lhsType);
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !rhsNullable) {
            return false;
        }
        if (KotlinBuiltIns.isNothing(rhsType)) {
            return false;
        }
        if (KotlinBuiltIns.isNullableNothing(rhsType)) {
            return lhsNullable;
        }
        if (lhsNullable && rhsNullable) {
            return true;
        }
        if (lhsType.isError()) {
            return true;
        }
        if (INSTANCE.isRelated(lhsType, rhsType, platformToKotlinClassMap)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (INSTANCE.isFinal(lhsType) || INSTANCE.isFinal(rhsType)) {
            return false;
        }
        return INSTANCE.isTrait(lhsType) || INSTANCE.isTrait(rhsType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelated(KotlinType a, KotlinType b, PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassDescriptor it;
        Object element$iv2;
        Iterable $receiver$iv;
        List<ClassDescriptor> aClasses = this.mapToPlatformClasses(a, platformToKotlinClassMap);
        List<ClassDescriptor> bClasses = this.mapToPlatformClasses(b, platformToKotlinClassMap);
        Iterable iterable = aClasses;
        for (Object element$iv2 : $receiver$iv) {
            it = (ClassDescriptor)element$iv2;
            if (!DescriptorUtils.isSubtypeOfClass(b, it)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        $receiver$iv = bClasses;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!DescriptorUtils.isSubtypeOfClass(a, it = (ClassDescriptor)(element$iv2 = iterator2.next())));
        return true;
    }

    private final List<ClassDescriptor> mapToPlatformClasses(KotlinType type2, PlatformToKotlinClassMap platformToKotlinClassMap) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        return CollectionsKt.plus(platformToKotlinClassMap.mapPlatformClass(descriptor2), descriptor2);
    }

    private final boolean isFinal(KotlinType type2) {
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private final boolean isTrait(KotlinType type2) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor it = classifierDescriptor;
        return it instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)it).getKind(), (Object)ClassKind.INTERFACE);
    }

    @JvmStatic
    public static final boolean isCastErased(@NotNull KotlinType supertype, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(subtype, "subtype");
        Intrinsics.checkParameterIsNotNull(typeChecker, "typeChecker");
        if (supertype.isMarkedNullable() || subtype.isMarkedNullable()) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(supertype);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNotNullable(supertype)");
            KotlinType kotlinType2 = TypeUtils.makeNotNullable(subtype);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNotNullable(subtype)");
            return CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, typeChecker);
        }
        if (typeChecker.isSubtypeOf(supertype, subtype)) {
            return false;
        }
        if (TypeUtils.isNonReifiedTypeParameter(subtype)) {
            return true;
        }
        if (INSTANCE.allParametersReified(subtype)) {
            return false;
        }
        TypeConstructor typeConstructor2 = subtype.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "subtype.constructor");
        KotlinType kotlinType = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, typeConstructor2).getResultingType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType staticallyKnownSubtype = kotlinType;
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype, @NotNull TypeConstructor subtypeConstructor) {
        Map substitution;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(subtypeConstructor, "subtypeConstructor");
        boolean bl = !supertype.isMarkedNullable();
        if (_Assertions.ENABLED && !bl) {
            String string = "This method only makes sense for non-nullable types";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassifierDescriptor classifierDescriptor = subtypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String $i$a$1$assert = "Can't create default type for " + subtypeConstructor;
            throw (Throwable)new IllegalStateException($i$a$1$assert.toString());
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        KotlinType subtypeWithVariables = descriptor2.getDefaultType();
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        List<TypeParameterDescriptor> variables = subtypeWithVariables.getConstructor().getParameters();
        Iterable iterable = variables;
        void var7_10 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void descriptor3;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            void var12_16 = destination$iv$iv;
            TypeConstructor typeConstructor2 = descriptor3.getTypeConstructor();
            var12_16.add(typeConstructor2);
        }
        Set variableConstructors = CollectionsKt.toSet((List)destination$iv$iv);
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult solution = TypeUnifier.unify(new TypeProjectionImpl(supertype), new TypeProjectionImpl(supertypeWithVariables), Predicates.in(variableConstructors));
            HashMap<TypeConstructor, TypeProjection> hashMap = Maps.newHashMap(solution.getSubstitution());
            Intrinsics.checkExpressionValueIsNotNull(hashMap, "Maps.newHashMap(solution.substitution)");
            substitution = hashMap;
        } else {
            HashMap hashMap = Maps.newHashMapWithExpectedSize(variables.size());
            Intrinsics.checkExpressionValueIsNotNull(hashMap, "Maps.newHashMapWithExpec\u2026ojection>(variables.size)");
            substitution = hashMap;
        }
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable : variables) {
            TypeProjection value = (TypeProjection)substitution.get(variable.getTypeConstructor());
            if (value != null) continue;
            TypeConstructor typeConstructor3 = variable.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "variable.typeConstructor");
            TypeProjection typeProjection = TypeUtils.makeStarProjection(variable);
            Intrinsics.checkExpressionValueIsNotNull(typeProjection, "TypeUtils.makeStarProjection(variable)");
            substitution.put(typeConstructor3, typeProjection);
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private final boolean allParametersReified(KotlinType subtype) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = subtype.getConstructor().getParameters();
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                if (it.isReified()) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private CastDiagnosticsUtil() {
        INSTANCE = this;
    }

    static {
        new CastDiagnosticsUtil();
    }
}

