/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.operation.AssignmentTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public final class OverloadedAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    private final ResolvedCall<? extends FunctionDescriptor> resolvedCall;

    @NotNull
    public static JsExpression doTranslate(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "doTranslate"));
        }
        JsExpression jsExpression = new OverloadedAssignmentTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "doTranslate"));
        }
        return jsExpression;
    }

    private OverloadedAssignmentTranslator(@NotNull KtBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "<init>"));
        }
        super(expression, context);
        this.resolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(expression, context.bindingContext());
    }

    @NotNull
    private JsExpression translate() {
        if (this.isVariableReassignment) {
            JsExpression jsExpression = this.reassignment();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.overloadedMethodInvocation(this.createAccessTranslator(this.expression.getLeft(), false));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression reassignment() {
        AccessTranslator accessTranslator = this.createAccessTranslator(this.expression.getLeft(), false).getCached();
        JsExpression newValue = this.overloadedMethodInvocation(accessTranslator);
        JsExpression jsExpression = accessTranslator.translateAsSet(newValue);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "reassignment"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression overloadedMethodInvocation(AccessTranslator accessTranslator) {
        JsBlock innerBlock = new JsBlock();
        TranslationContext innerContext = this.context().innerBlock(innerBlock);
        JsExpression oldValue = accessTranslator.translateAsGet();
        JsExpression result2 = CallTranslator.translate(innerContext, this.resolvedCall, oldValue);
        this.context().addStatementsToCurrentBlockFrom(innerBlock);
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/OverloadedAssignmentTranslator", "overloadedMethodInvocation"));
        }
        return jsExpression;
    }
}

