/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.annotations;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;

public class AnnotationDescriptorImpl
implements AnnotationDescriptor {
    private final KotlinType annotationType;
    private final Map<ValueParameterDescriptor, ConstantValue<?>> valueArguments;
    private final SourceElement source;

    public AnnotationDescriptorImpl(@NotNull KotlinType annotationType, @NotNull Map<ValueParameterDescriptor, ConstantValue<?>> valueArguments2, @NotNull SourceElement source) {
        if (annotationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationType", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "<init>"));
        }
        this.annotationType = annotationType;
        this.valueArguments = Collections.unmodifiableMap(valueArguments2);
        this.source = source;
    }

    @Override
    @NotNull
    public KotlinType getType() {
        KotlinType kotlinType = this.annotationType;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "getType"));
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ConstantValue<?>> getAllValueArguments() {
        Map<ValueParameterDescriptor, ConstantValue<?>> map2 = this.valueArguments;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "getAllValueArguments"));
        }
        return map2;
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = this.source;
        if (sourceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptorImpl", "getSource"));
        }
        return sourceElement;
    }

    public String toString() {
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderAnnotation(this, null);
    }
}

