/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.BitSet;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.text.Matcher;

public class MinusculeMatcher
implements Matcher {
    private final ThreadLocal<MatchingState> myMatchingState;
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;

    MinusculeMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "<init>"));
        }
        if (hardSeparators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardSeparators", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "<init>"));
        }
        this.myMatchingState = new ThreadLocal<MatchingState>(){

            @Override
            protected MatchingState initialValue() {
                return new MatchingState();
            }
        };
        this.myOptions = options;
        this.myPattern = StringUtil.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = MinusculeMatcher.isWordSeparator(c);
            this.toUpperCase[k] = StringUtil.toUpperCase(c);
            this.toLowerCase[k] = StringUtil.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i = 0;
        while (this.isWildcard(i)) {
            ++i;
        }
        this.myHasHumps = this.hasFlag(i + 1, this.isUpperCase) && this.hasFlag(i, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i, this.isWordSeparator);
        this.myHasDots = this.hasDots(i);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static boolean isWordStart(String text, int i) {
        char c = text.charAt(i);
        if (Character.isUpperCase(c)) {
            if (i > 0 && Character.isUpperCase(text.charAt(i - 1))) {
                return i + 1 < text.length() && Character.isLowerCase(text.charAt(i + 1));
            }
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (!Character.isLetter(c)) {
            return false;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1));
    }

    private static int nextWord(@NotNull String name, int start) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "nextWord"));
        }
        if (start < name.length() && Character.isDigit(name.charAt(start))) {
            return start + 1;
        }
        return NameUtil.nextWord(name, start);
    }

    private boolean hasFlag(int start, boolean[] flags) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (!flags[i]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (this.myPattern[i] != '.') continue;
            return true;
        }
        return false;
    }

    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges2, int from, int length) {
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "prependRange"));
        }
        TextRange head = ranges2.getHead();
        if (head != null && head.getStartOffset() == from + length) {
            return ranges2.getTail().prepend(new TextRange(from, head.getEndOffset()));
        }
        return ranges2.prepend(TextRange.from(from, length));
    }

    public int matchingDegree(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchingDegree"));
        }
        return this.matchingDegree(name, false);
    }

    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchingDegree"));
        }
        return this.matchingDegree(name, valueStartCaseMatch, this.matchingFragments(name));
    }

    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<TextRange> fragments2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchingDegree"));
        }
        if (fragments2 == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments2.isEmpty()) {
            return 0;
        }
        TextRange first = fragments2.getHead();
        boolean startMatch = first.getStartOffset() == 0;
        int matchingCase = 0;
        int p = -1;
        int integral = 0;
        int humpIndex = 1;
        int nextHumpStart = 0;
        block0: for (TextRange range : fragments2) {
            for (int i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    }
                    nextHumpStart = MinusculeMatcher.nextWord(name, nextHumpStart);
                    if (first == range) continue;
                    ++humpIndex;
                }
                integral -= humpIndex;
                char c = name.charAt(i);
                p = StringUtil.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) continue block0;
                if (c == this.myPattern[p]) {
                    if (this.isUpperCase[p]) {
                        matchingCase += 50;
                        continue;
                    }
                    if (i == 0 && startMatch) {
                        matchingCase += 15;
                        continue;
                    }
                    if (!isHumpStart) continue;
                    ++matchingCase;
                    continue;
                }
                if (!isHumpStart) continue;
                --matchingCase;
            }
        }
        int startIndex = first.getStartOffset();
        boolean afterSeparator = StringUtil.indexOfAny(name, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || MinusculeMatcher.isWordStart(name, startIndex) && !MinusculeMatcher.isWordStart(name, startIndex - 1);
        boolean finalMatch = fragments2.get(fragments2.size() - 1).getEndOffset() == name.length();
        return (wordStart ? 1000 : 0) + integral * 10 + matchingCase * (startMatch && valueStartCaseMatch ? 10 : 1) + (afterSeparator ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    public boolean isStartMatch(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "isStartMatch"));
        }
        FList<TextRange> fragments2 = this.matchingFragments(name);
        return fragments2 != null && MinusculeMatcher.isStartMatch(fragments2);
    }

    public static boolean isStartMatch(@NotNull Iterable<TextRange> fragments2) {
        if (fragments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "isStartMatch"));
        }
        Iterator<TextRange> iterator2 = fragments2.iterator();
        return !iterator2.hasNext() || iterator2.next().getStartOffset() == 0;
    }

    @Override
    public boolean matches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matches"));
        }
        return this.matchingFragments(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchingFragments"));
        }
        if (name.length() < this.myMinNameLength) {
            return null;
        }
        int length = name.length();
        int patternIndex = 0;
        boolean isAscii = true;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0080') {
                isAscii = false;
            }
            if (patternIndex >= this.myMeaningfulCharacters.length || c != this.myMeaningfulCharacters[patternIndex] && c != this.myMeaningfulCharacters[patternIndex + 1]) continue;
            patternIndex += 2;
        }
        if (patternIndex < this.myMinNameLength) {
            return null;
        }
        MatchingState state2 = this.myMatchingState.get();
        state2.initializeState(isAscii, length);
        try {
            FList<TextRange> fList = this.matchWildcards(name, 0, 0, state2);
            return fList;
        }
        finally {
            state2.releaseState();
        }
    }

    @Nullable
    private FList<TextRange> matchWildcards(@NotNull String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchWildcards"));
        }
        if (nameIndex < 0) {
            return null;
        }
        if (!this.isWildcard(patternIndex)) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            return this.matchFragment(name, patternIndex, nameIndex, matchingState);
        }
        while (this.isWildcard(++patternIndex)) {
        }
        if (patternIndex == this.myPattern.length) {
            boolean space = this.isPatternChar(patternIndex - 1, ' ');
            if (space && nameIndex != name.length() && (patternIndex < 2 || !NameUtil.isWordStart(this.myPattern[patternIndex - 2]))) {
                int spaceIndex = name.indexOf(32, nameIndex);
                if (spaceIndex >= 0) {
                    return FList.emptyList().prepend(TextRange.from(spaceIndex, 1));
                }
                return null;
            }
            return FList.emptyList();
        }
        FList<TextRange> ranges2 = this.matchFragment(name, patternIndex, nameIndex, matchingState);
        if (ranges2 != null) {
            return ranges2;
        }
        return this.matchSkippingWords(name, patternIndex, nameIndex, true, matchingState);
    }

    @Nullable
    private FList<TextRange> matchSkippingWords(@NotNull String name, int patternIndex, int nameIndex, boolean allowSpecialChars, MatchingState matchingState) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchSkippingWords"));
        }
        boolean star = this.isPatternChar(patternIndex - 1, '*');
        char p = this.myPattern[patternIndex];
        while (true) {
            FList<TextRange> ranges2;
            int nextOccurrence;
            int n = nextOccurrence = star ? this.indexOfIgnoreCase(name, nameIndex + 1, p, patternIndex, matchingState.isAsciiName) : this.indexOfWordStart(name, patternIndex, nameIndex);
            if (nextOccurrence < 0) {
                return null;
            }
            if (!allowSpecialChars && !this.myHasSeparators && !this.myHasHumps && StringUtil.containsAnyChar(name, this.myHardSeparators, nameIndex, nextOccurrence)) {
                return null;
            }
            if (!allowSpecialChars && this.myHasDots && !this.isPatternChar(patternIndex - 1, '.') && StringUtil.contains(name, nameIndex, nextOccurrence, '.')) {
                return null;
            }
            if ((!this.isUpperCase[patternIndex] || Character.isUpperCase(name.charAt(nextOccurrence)) || MinusculeMatcher.isWordStart(name, nextOccurrence) || !this.myHasHumps && this.myOptions != NameUtil.MatchingCaseSensitivity.ALL) && (ranges2 = this.matchFragment(name, patternIndex, nextOccurrence, matchingState)) != null) {
                return ranges2;
            }
            nameIndex = nextOccurrence;
        }
    }

    private boolean charEquals(char patternChar, int patternIndex, char c, boolean isIgnoreCase) {
        return patternChar == c || isIgnoreCase && (this.toLowerCase[patternIndex] == c || this.toUpperCase[patternIndex] == c);
    }

    @Nullable
    private FList<TextRange> matchFragment(@NotNull String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "matchFragment"));
        }
        if (matchingState.hasFailed(patternIndex, nameIndex)) {
            return null;
        }
        FList<TextRange> result2 = this.doMatchFragments(name, patternIndex, nameIndex, matchingState);
        if (result2 == null) {
            matchingState.registerFailure(patternIndex, nameIndex);
        }
        return result2;
    }

    private FList<TextRange> doMatchFragments(String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        boolean ignoreCase;
        if (!this.isFirstCharMatching(name, nameIndex, patternIndex)) {
            return null;
        }
        int minFragment = this.isPatternChar(patternIndex - 1, '*') && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(name.charAt(nameIndex)) && !MinusculeMatcher.isWordStart(name, nameIndex) ? 3 : 1;
        int i = 1;
        boolean bl = ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        while (nameIndex + i < name.length() && patternIndex + i < this.myPattern.length && this.charEquals(this.myPattern[patternIndex + i], patternIndex + i, name.charAt(nameIndex + i), ignoreCase)) {
            if (this.isUpperCase[patternIndex + i] && this.myHasHumps && this.myPattern[patternIndex + i] != name.charAt(nameIndex + i)) {
                if (i < minFragment) {
                    return null;
                }
                int nextWordStart = this.indexOfWordStart(name, patternIndex + i, nameIndex + i);
                FList<TextRange> ranges2 = this.matchWildcards(name, patternIndex + i, nextWordStart, matchingState);
                if (ranges2 != null) {
                    return MinusculeMatcher.prependRange(ranges2, nameIndex, i);
                }
                if (i > 1 && this.isUpperCase[patternIndex + i - 1] && this.isUpperCase[patternIndex + i - 2] && (nameIndex + i + 1 == name.length() || patternIndex + i + 1 < this.myPattern.length && !this.isLowerCase[patternIndex + i + 1])) {
                    return null;
                }
            }
            ++i;
        }
        if (patternIndex + i >= this.myPattern.length) {
            return FList.emptyList().prepend(TextRange.from(nameIndex, i));
        }
        while (i >= minFragment || this.isWildcard(patternIndex + i)) {
            FList<TextRange> ranges3;
            FList<TextRange> fList = ranges3 = this.isWildcard(patternIndex + i) ? this.matchWildcards(name, patternIndex + i, nameIndex + i, matchingState) : this.matchSkippingWords(name, patternIndex + i, nameIndex + i, false, matchingState);
            if (ranges3 != null) {
                return MinusculeMatcher.prependRange(ranges3, nameIndex, i);
            }
            --i;
        }
        return null;
    }

    private boolean isFirstCharMatching(@NotNull String name, int nameIndex, int patternIndex) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "isFirstCharMatching"));
        }
        if (nameIndex >= name.length()) {
            return false;
        }
        boolean ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        char patternChar = this.myPattern[patternIndex];
        if (!this.charEquals(patternChar, patternIndex, name.charAt(nameIndex), ignoreCase)) {
            return false;
        }
        return this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !this.isWildcard(0)) || !MinusculeMatcher.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasCase(char patternChar) {
        return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    private boolean isPatternChar(int patternIndex, char c) {
        return patternIndex >= 0 && patternIndex < this.myPattern.length && this.myPattern[patternIndex] == c;
    }

    private int indexOfWordStart(@NotNull String name, int patternIndex, int startFrom) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher", "indexOfWordStart"));
        }
        char p = this.myPattern[patternIndex];
        if (startFrom >= name.length() || this.myHasHumps && this.isLowerCase[patternIndex] && (patternIndex <= 0 || !this.isWordSeparator[patternIndex - 1])) {
            return -1;
        }
        int nextWordStart = startFrom;
        do {
            if ((nextWordStart = MinusculeMatcher.nextWord(name, nextWordStart)) < name.length()) continue;
            return -1;
        } while (!this.charEquals(p, patternIndex, name.charAt(nextWordStart), true));
        return nextWordStart;
    }

    private int indexOfIgnoreCase(String name, int fromIndex, char p, int patternIndex, boolean isAsciiName) {
        if (isAsciiName && IOUtil.isAscii(p)) {
            char pUpper = this.toUpperCase[patternIndex];
            char pLower = this.toLowerCase[patternIndex];
            for (int i = fromIndex; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != p && MinusculeMatcher.toUpperAscii(c) != pUpper && MinusculeMatcher.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }
        return StringUtil.indexOfIgnoreCase(name, p, fromIndex);
    }

    private static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    private static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    @NonNls
    public String toString() {
        return "MinusculeMatcher{myPattern=" + new String(this.myPattern) + ", myOptions=" + (Object)((Object)this.myOptions) + '}';
    }

    private static class MatchingState {
        private boolean myBusy;
        private int myNameLength;
        private boolean isAsciiName;
        private final BitSet myTable = new BitSet();

        private MatchingState() {
        }

        void initializeState(boolean isAscii, int length) {
            assert (!this.myBusy);
            this.myBusy = true;
            this.myNameLength = length;
            this.isAsciiName = isAscii;
            this.myTable.clear();
        }

        void releaseState() {
            assert (this.myBusy);
            this.myBusy = false;
        }

        void registerFailure(int patternIndex, int nameIndex) {
            this.myTable.set(patternIndex * this.myNameLength + nameIndex);
        }

        boolean hasFailed(int patternIndex, int nameIndex) {
            return this.myTable.get(patternIndex * this.myNameLength + nameIndex);
        }
    }
}

