/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0000J\u0016\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\fJ\u0013\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000-J\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u001c0/J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\f0+J\b\u00101\u001a\u00020\fH\u0016J\u0006\u00102\u001a\u00020\u0010J\u0006\u00103\u001a\u00020\u0010J\u0006\u00104\u001a\u00020\u001eJ\u000e\u00105\u001a\u00020\u00102\u0006\u0010(\u001a\u000206R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u001c0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "boxedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxingInsn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "progressionIterator", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "(Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;)V", "associatedInsns", "Ljava/util/HashSet;", "associatedVariables", "", "getBoxingInsn", "()Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "<set-?>", "", "isSafeToRemove", "()Z", "setSafeToRemove", "(Z)V", "mergedWith", "primitiveType", "getPrimitiveType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getProgressionIterator", "()Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "unboxingWithCastInsns", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Pair;", "addInsn", "", "insnNode", "addMergedWith", "value", "addUnboxingWithCastTo", "insn", "type", "addVariableIndex", "index", "equals", "other", "", "getAssociatedInsns", "", "getMergedWith", "", "getUnboxingWithCastInsns", "", "getVariablesIndexes", "hashCode", "isDoubleSize", "isFromProgressionIterator", "markAsUnsafeToRemove", "typeEquals", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "Companion", "kotlin-compiler"})
public final class BoxedBasicValue
extends StrictBasicValue {
    private final HashSet<AbstractInsnNode> associatedInsns;
    private final HashSet<Pair<AbstractInsnNode, Type>> unboxingWithCastInsns;
    private final HashSet<Integer> associatedVariables;
    private final HashSet<BoxedBasicValue> mergedWith;
    @NotNull
    private final Type primitiveType;
    private boolean isSafeToRemove;
    @NotNull
    private final AbstractInsnNode boxingInsn;
    @Nullable
    private final ProgressionIteratorBasicValue progressionIterator;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Type getPrimitiveType() {
        return this.primitiveType;
    }

    public final boolean isSafeToRemove() {
        return this.isSafeToRemove;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other;
    }

    public final boolean typeEquals(@NotNull BasicValue other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return other instanceof BoxedBasicValue && Intrinsics.areEqual(this.getType(), ((BoxedBasicValue)other).getType());
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @NotNull
    public final List<AbstractInsnNode> getAssociatedInsns() {
        return new ArrayList(this.associatedInsns);
    }

    public final void addInsn(@NotNull AbstractInsnNode insnNode) {
        Intrinsics.checkParameterIsNotNull(insnNode, "insnNode");
        this.associatedInsns.add(insnNode);
    }

    public final void addVariableIndex(int index2) {
        this.associatedVariables.add(index2);
    }

    @NotNull
    public final List<Integer> getVariablesIndexes() {
        return new ArrayList(this.associatedVariables);
    }

    public final void addMergedWith(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.mergedWith.add(value);
    }

    @NotNull
    public final Iterable<BoxedBasicValue> getMergedWith() {
        return this.mergedWith;
    }

    public final void markAsUnsafeToRemove() {
        this.isSafeToRemove = false;
    }

    public final boolean isDoubleSize() {
        return this.primitiveType.getSize() == 2;
    }

    public final boolean isFromProgressionIterator() {
        return this.progressionIterator != null;
    }

    public final void addUnboxingWithCastTo(@NotNull AbstractInsnNode insn, @NotNull Type type2) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        this.unboxingWithCastInsns.add(Pair.create(insn, type2));
    }

    @NotNull
    public final Set<Pair<AbstractInsnNode, Type>> getUnboxingWithCastInsns() {
        return this.unboxingWithCastInsns;
    }

    @NotNull
    public final AbstractInsnNode getBoxingInsn() {
        return this.boxingInsn;
    }

    @Nullable
    public final ProgressionIteratorBasicValue getProgressionIterator() {
        return this.progressionIterator;
    }

    public BoxedBasicValue(@NotNull Type boxedType, @NotNull AbstractInsnNode boxingInsn, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Intrinsics.checkParameterIsNotNull(boxedType, "boxedType");
        Intrinsics.checkParameterIsNotNull(boxingInsn, "boxingInsn");
        super(boxedType);
        this.boxingInsn = boxingInsn;
        this.progressionIterator = progressionIterator;
        this.associatedInsns = new HashSet();
        this.unboxingWithCastInsns = new HashSet();
        this.associatedVariables = new HashSet();
        this.mergedWith = new HashSet();
        this.primitiveType = BoxedBasicValue.Companion.unboxType(boxedType);
        this.isSafeToRemove = true;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue$Companion;", "", "()V", "unboxType", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "kotlin-compiler"})
    public static final class Companion {
        private final Type unboxType(Type boxedType) {
            Type primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
            if (primitiveType != null) {
                return primitiveType;
            }
            if (Intrinsics.areEqual(boxedType, AsmTypes.K_CLASS_TYPE)) {
                Type type2 = AsmTypes.JAVA_CLASS_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(type2, "AsmTypes.JAVA_CLASS_TYPE");
                return type2;
            }
            throw (Throwable)new IllegalArgumentException("Expected primitive type wrapper or KClass, got: " + boxedType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

