/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.DeprecatedBySinceKotlinInfo;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.SinceKotlinInfo;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0007\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u0007\u001a\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011*\u00020\u00122\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011*\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00122\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\u0016\u001a\u00020\u0015*\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"JAVA_DEPRECATED", "Lorg/jetbrains/kotlin/name/FqName;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/Deprecation;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationByOverridden", "root", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "deprecatedByAnnotationReplaceWithExpression", "", "deprecatedByOverriddenMessage", "getDeprecations", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getOwnDeprecations", "isDeprecatedHidden", "", "isHiddenInResolution", "kotlin-compiler"})
public final class DeprecationUtilKt {
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");

    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull Deprecation $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Deprecation deprecation = $receiver;
        if (!(deprecation instanceof DeprecatedByOverridden)) {
            deprecation = null;
        }
        DeprecatedByOverridden deprecatedByOverridden = (DeprecatedByOverridden)deprecation;
        return deprecatedByOverridden != null ? deprecatedByOverridden.additionalMessage$kotlin_compiler() : null;
    }

    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull Deprecation $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Deprecation deprecation = $receiver;
        if (!(deprecation instanceof DeprecatedByAnnotation)) {
            deprecation = null;
        }
        if ((object = (DeprecatedByAnnotation)deprecation) == null || (object = ((DeprecatedByAnnotation)object).getAnnotation()) == null) {
            return null;
        }
        Object annotation2 = object;
        Object object2 = AnnotationUtilKt.argumentValue((AnnotationDescriptor)annotation2, "replaceWith");
        if (!(object2 instanceof AnnotationDescriptor)) {
            object2 = null;
        }
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)object2;
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor replaceWithAnnotation = annotationDescriptor;
        Object object3 = AnnotationUtilKt.argumentValue(replaceWithAnnotation, "expression");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return (String)object3;
    }

    @NotNull
    public static final List<Deprecation> getDeprecations(@NotNull DeclarationDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        List<Deprecation> deprecations = DeprecationUtilKt.getOwnDeprecations($receiver, languageVersionSettings);
        Collection collection = deprecations;
        if (!collection.isEmpty()) {
            return deprecations;
        }
        if ($receiver instanceof CallableMemberDescriptor) {
            return CollectionsKt.listOfNotNull(DeprecationUtilKt.deprecationByOverridden((CallableMemberDescriptor)$receiver, languageVersionSettings));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static final Deprecation deprecationByOverridden(CallableMemberDescriptor root, LanguageVersionSettings languageVersionSettings) {
        void hasUndeprecatedOverridden;
        HashSet visited2 = new HashSet();
        LinkedHashSet deprecations = new LinkedHashSet();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Function1<CallableMemberDescriptor, Unit> traverse$ = new Function1<CallableMemberDescriptor, Unit>(visited2, languageVersionSettings, deprecations, (Ref.BooleanRef)hasUndeprecatedOverridden){
            final /* synthetic */ HashSet $visited;
            final /* synthetic */ LanguageVersionSettings $languageVersionSettings;
            final /* synthetic */ LinkedHashSet $deprecations;
            final /* synthetic */ Ref.BooleanRef $hasUndeprecatedOverridden;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CallableMemberDescriptor node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                if (this.$visited.contains(node)) {
                    return;
                }
                this.$visited.add(node);
                List deprecationsByAnnotation = DeprecationUtilKt.access$getOwnDeprecations(node, this.$languageVersionSettings);
                Collection<? extends CallableMemberDescriptor> overriddenDescriptors = node.getOriginal().getOverriddenDescriptors();
                Iterable<E> iterable = deprecationsByAnnotation;
                if (!iterable.isEmpty()) {
                    this.$deprecations.addAll(deprecationsByAnnotation);
                } else {
                    void $receiver$iv;
                    if (overriddenDescriptors.isEmpty()) {
                        this.$hasUndeprecatedOverridden.element = true;
                        return;
                    }
                    iterable = overriddenDescriptors;
                    for (T element$iv : $receiver$iv) {
                        CallableMemberDescriptor p1 = (CallableMemberDescriptor)element$iv;
                        this.invoke(p1);
                    }
                }
            }
            {
                this.$visited = hashSet;
                this.$languageVersionSettings = languageVersionSettings;
                this.$deprecations = linkedHashSet;
                this.$hasUndeprecatedOverridden = booleanRef;
                super(1);
            }
        };
        traverse$.invoke(root);
        if (hasUndeprecatedOverridden.element || deprecations.isEmpty()) {
            return null;
        }
        return new DeprecatedByOverridden(deprecations);
    }

    private static final List<Deprecation> getOwnDeprecations(@NotNull DeclarationDescriptor $receiver, LanguageVersionSettings languageVersionSettings) {
        SmartList result2 = new SmartList();
        Function1<DeclarationDescriptor, Unit> addDeprecationIfPresent$ = new Function1<DeclarationDescriptor, Unit>(result2, languageVersionSettings){
            final /* synthetic */ SmartList $result;
            final /* synthetic */ LanguageVersionSettings $languageVersionSettings;

            public final void invoke(@NotNull DeclarationDescriptor target) {
                Object sinceKotlinInfo;
                Object object;
                DeclarationDescriptor declarationDescriptor;
                AnnotationDescriptor annotation2;
                Intrinsics.checkParameterIsNotNull(target, "target");
                Annotations annotations2 = target.getAnnotations();
                FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
                Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
                AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
                if (annotationDescriptor == null) {
                    annotationDescriptor = annotation2 = target.getAnnotations().findAnnotation(DeprecationUtilKt.access$getJAVA_DEPRECATED$p());
                }
                if (annotation2 != null) {
                    this.$result.add(new DeprecatedByAnnotation(annotation2, target));
                }
                if (!((declarationDescriptor = target) instanceof DeserializedCallableMemberDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((object = (DeserializedCallableMemberDescriptor)declarationDescriptor) == null || (object = object.getSinceKotlinInfo()) == null) {
                    DeclarationDescriptor declarationDescriptor2 = target;
                    if (!(declarationDescriptor2 instanceof DeserializedClassDescriptor)) {
                        declarationDescriptor2 = null;
                    }
                    DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)declarationDescriptor2;
                    object = sinceKotlinInfo = deserializedClassDescriptor != null ? deserializedClassDescriptor.getSinceKotlinInfo() : null;
                }
                if (sinceKotlinInfo != null && ApiVersion.Companion.createBySinceKotlinInfo((SinceKotlinInfo)sinceKotlinInfo).compareTo(ApiVersion.Companion.createByLanguageVersion(this.$languageVersionSettings.getLanguageVersion())) > 0) {
                    this.$result.add(new DeprecatedBySinceKotlinInfo((SinceKotlinInfo)sinceKotlinInfo, target));
                }
            }
            {
                this.$result = smartList;
                this.$languageVersionSettings = languageVersionSettings;
                super(1);
            }
        };
        Function2<DeclarationDescriptor, AnnotationUseSiteTarget, Unit> addUseSiteTargetedDeprecationIfPresent$ = new Function2<DeclarationDescriptor, AnnotationUseSiteTarget, Unit>($receiver, result2){
            final /* synthetic */ DeclarationDescriptor receiver$0;
            final /* synthetic */ SmartList $result;

            public final void invoke(@NotNull DeclarationDescriptor annotatedDescriptor, @Nullable AnnotationUseSiteTarget useSiteTarget) {
                Intrinsics.checkParameterIsNotNull(annotatedDescriptor, "annotatedDescriptor");
                if (useSiteTarget != null) {
                    AnnotationDescriptor annotation2;
                    Annotations annotations2 = annotatedDescriptor.getAnnotations();
                    Intrinsics.checkExpressionValueIsNotNull(annotations2, "annotatedDescriptor.annotations");
                    FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
                    AnnotationDescriptor annotationDescriptor = Annotations.Companion.findUseSiteTargetedAnnotation(annotations2, useSiteTarget, fqName2);
                    if (annotationDescriptor == null) {
                        Annotations annotations3 = annotatedDescriptor.getAnnotations();
                        Intrinsics.checkExpressionValueIsNotNull(annotations3, "annotatedDescriptor.annotations");
                        annotationDescriptor = annotation2 = Annotations.Companion.findUseSiteTargetedAnnotation(annotations3, useSiteTarget, DeprecationUtilKt.access$getJAVA_DEPRECATED$p());
                    }
                    if (annotation2 != null) {
                        this.$result.add(new DeprecatedByAnnotation(annotation2, this.receiver$0));
                    }
                }
            }
            {
                this.receiver$0 = declarationDescriptor;
                this.$result = smartList;
                super(2);
            }
        };
        addDeprecationIfPresent$.invoke($receiver);
        addUseSiteTargetedDeprecationIfPresent$.invoke($receiver, AnnotationUseSiteTarget.Companion.getAssociatedUseSiteTarget($receiver));
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "containingDeclaration");
            addDeprecationIfPresent$.invoke(declarationDescriptor2);
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            DeclarationDescriptor declarationDescriptor3 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "correspondingProperty");
            addDeprecationIfPresent$.invoke(declarationDescriptor3);
            DeclarationDescriptor declarationDescriptor4 = ((PropertyAccessorDescriptor)$receiver).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor4, "correspondingProperty");
            addUseSiteTargetedDeprecationIfPresent$.invoke(declarationDescriptor4, $receiver instanceof PropertyGetterDescriptor ? AnnotationUseSiteTarget.PROPERTY_GETTER : AnnotationUseSiteTarget.PROPERTY_SETTER);
        }
        return CollectionsKt.distinct(result2);
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull Deprecation deprecation, @NotNull LanguageVersionSettings languageVersionSettings) {
        DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(deprecation, "deprecation");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        DeclarationDescriptor targetOriginal = deprecation.getTarget().getOriginal();
        if (deprecation instanceof DeprecatedBySinceKotlinInfo) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, SinceKotlinInfo.Version, Pair<LanguageVersion, String>> diagnosticFactory3;
            switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$0[deprecation.getDeprecationLevel().ordinal()]) {
                case 1: {
                    diagnosticFactory3 = Errors.SINCE_KOTLIN_INFO_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.SINCE_KOTLIN_INFO_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, SinceKotlinInfo.Version, Pair<LanguageVersion, String>> factory = diagnosticFactory3;
            Diagnostic diagnostic = factory.on(element, targetOriginal, ((DeprecatedBySinceKotlinInfo)deprecation).getSinceKotlinVersion(), TuplesKt.to(languageVersionSettings.getLanguageVersion(), deprecation.getMessage()));
            Intrinsics.checkExpressionValueIsNotNull(diagnostic, "factory.on(element, targ\u2026n to deprecation.message)");
            return diagnostic;
        }
        switch (DeprecationUtilKt$WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
            case 1: {
                diagnosticFactory2 = Errors.DEPRECATION;
                break;
            }
            case 2: 
            case 3: {
                diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory = diagnosticFactory2;
        String string = deprecation.getMessage();
        if (string == null) {
            string = "";
        }
        Diagnostic diagnostic = factory.on(element, targetOriginal, string);
        Intrinsics.checkExpressionValueIsNotNull(diagnostic, "factory.on(element, targ\u2026eprecation.message ?: \"\")");
        return diagnostic;
    }

    public static final boolean isDeprecatedHidden(@NotNull DeclarationDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
            Iterable $receiver$iv = DeprecationUtilKt.getDeprecations($receiver, languageVersionSettings);
            for (Object element$iv : $receiver$iv) {
                Deprecation it = (Deprecation)element$iv;
                if (!Intrinsics.areEqual((Object)it.getDeprecationLevel(), (Object)DeprecationLevelValue.HIDDEN)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isHiddenInResolution(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof FunctionDescriptor && ((FunctionDescriptor)$receiver).isHiddenToOvercomeSignatureClash()) {
            return true;
        }
        if (!SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility$default($receiver, LanguageVersionSettingsImpl.DEFAULT, null, 2, null)) {
            return true;
        }
        return DeprecationUtilKt.isDeprecatedHidden($receiver, LanguageVersionSettingsImpl.DEFAULT);
    }

    @NotNull
    public static final /* synthetic */ List access$getOwnDeprecations(@NotNull DeclarationDescriptor $receiver, @NotNull LanguageVersionSettings languageVersionSettings) {
        return DeprecationUtilKt.getOwnDeprecations($receiver, languageVersionSettings);
    }

    @NotNull
    public static final /* synthetic */ FqName access$getJAVA_DEPRECATED$p() {
        return JAVA_DEPRECATED;
    }
}

