/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightClassReferenceBase;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class LightClassReference
extends LightClassReferenceBase
implements PsiJavaCodeReferenceElement {
    private final String myClassName;
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    private final PsiClass myRefClass;
    private final PsiSubstitutor mySubstitutor;

    private LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @Nullable @NonNls String className2, @Nullable PsiSubstitutor substitutor2, @NotNull GlobalSearchScope resolveScope, @Nullable PsiElement context, @Nullable PsiClass refClass) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        super(manager, text);
        this.myClassName = className2;
        this.myResolveScope = resolveScope;
        this.myContext = context;
        this.myRefClass = refClass;
        this.mySubstitutor = substitutor2;
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className2, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, className2, null, resolveScope, null, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className2, PsiSubstitutor substitutor2, @NotNull PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, className2, substitutor2, context.getResolveScope(), context, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull PsiClass refClass) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, refClass, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull PsiClass refClass, PsiSubstitutor substitutor2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "<init>"));
        }
        this(manager, text, null, substitutor2, refClass.getResolveScope(), null, refClass);
    }

    @Override
    public PsiElement resolve() {
        if (this.myClassName != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
            if (this.myContext != null) {
                return facade.getResolveHelper().resolveReferencedClass(this.myClassName, this.myContext);
            }
            return facade.findClass(this.myClassName, this.myResolveScope);
        }
        return this.myRefClass;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        if (resolved == null) {
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "advancedResolve"));
            }
            return javaResolveResult;
        }
        PsiSubstitutor substitutor2 = this.mySubstitutor;
        if (substitutor2 == null) {
            substitutor2 = resolved instanceof PsiClass ? JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory().createRawSubstitutor((PsiClass)resolved) : PsiSubstitutor.EMPTY;
        }
        CandidateInfo candidateInfo = new CandidateInfo(resolved, substitutor2);
        if (candidateInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "advancedResolve"));
        }
        return candidateInfo;
    }

    @Override
    public String getQualifiedName() {
        if (this.myClassName != null) {
            PsiClass psiClass;
            if (this.myContext != null && (psiClass = (PsiClass)this.resolve()) != null) {
                return psiClass.getQualifiedName();
            }
            return this.myClassName;
        }
        return this.myRefClass.getQualifiedName();
    }

    @Override
    public String getReferenceName() {
        if (this.myClassName != null) {
            return PsiNameHelper.getShortClassName(this.myClassName);
        }
        if (this.myRefClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)this.myRefClass).getBaseClassReference().getReferenceName();
        }
        return this.myRefClass.getName();
    }

    @Override
    public PsiElement copy() {
        if (this.myClassName != null) {
            if (this.myContext != null) {
                return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myContext);
            }
            return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myResolveScope, null, null);
        }
        return new LightClassReference(this.myManager, this.myText, this.myRefClass, this.mySubstitutor);
    }

    @Override
    public boolean isValid() {
        return this.myRefClass == null || this.myRefClass.isValid();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myResolveScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightClassReference", "getResolveScope"));
        }
        return globalSearchScope;
    }
}

