/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.util.PsiNavigationSupport;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.pom.Navigatable;
import org.jetbrains.kotlin.com.intellij.psi.NavigatablePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.ResolveScopeManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class PsiElementBase
extends ElementBase
implements NavigatablePsiElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiElementBase");

    @Override
    public PsiElement getFirstChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[0];
    }

    @Override
    public PsiElement getLastChild() {
        PsiElement[] children = this.getChildren();
        if (children.length == 0) {
            return null;
        }
        return children[children.length - 1];
    }

    @Override
    public PsiElement getNextSibling() {
        return SharedPsiElementImplUtil.getNextSibling(this);
    }

    @Override
    public PsiElement getPrevSibling() {
        return SharedPsiElementImplUtil.getPrevSibling(this);
    }

    @Override
    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "acceptChildren"));
        }
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.accept(visitor2);
        }
    }

    @Override
    public PsiReference getReference() {
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = SharedPsiElementImplUtil.getReferences(this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public PsiReference findReferenceAt(int offset2) {
        return SharedPsiElementImplUtil.findReferenceAt(this, offset2);
    }

    @Override
    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "addRangeBefore"));
        }
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException("Operation not supported in: " + this.getClass());
    }

    @Override
    public PsiElement copy() {
        return (PsiElement)this.clone();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "add"));
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "addBefore"));
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "addAfter"));
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "checkAdd"));
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "replace"));
        }
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public boolean textContains(char c) {
        return this.getText().indexOf(c) >= 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "processDeclarations"));
        }
        return true;
    }

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElementBase psiElementBase = this;
        if (psiElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "getNavigationElement"));
        }
        return psiElementBase;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementResolveScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "getUseScope"));
        }
        return globalSearchScope;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = PsiNavigationSupport.getInstance().getDescriptor(this);
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this);
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    @NotNull
    public Project getProject() {
        PsiManager manager = this.getManager();
        if (manager == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        Project project = manager.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "getProject"));
        }
        return project;
    }

    public ItemPresentation getPresentation() {
        return null;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiElement parent2 = this.getParent();
        if (parent2 == null) {
            throw new PsiInvalidElementAccessException(this);
        }
        return parent2.getContainingFile();
    }

    @Override
    public boolean isPhysical() {
        PsiElement parent2 = this.getParent();
        return parent2 != null && parent2.isPhysical();
    }

    @Override
    public boolean isWritable() {
        PsiElement parent2 = this.getParent();
        return parent2 != null && parent2.isWritable();
    }

    @Override
    public boolean isValid() {
        PsiElement parent2;
        for (parent2 = this.getParent(); parent2 != null && parent2.getClass() == this.getClass(); parent2 = parent2.getParent()) {
        }
        return parent2 != null && parent2.isValid();
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "textMatches"));
        }
        return Comparing.equal((CharSequence)this.getText(), text, true);
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "textMatches"));
        }
        return this.getText().equals(element.getText());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "accept"));
        }
        visitor2.visitElement(this);
    }

    @Override
    public String getName() {
        return null;
    }

    @NotNull
    protected <T> T notNullChild(T child) {
        if (child == null) {
            LOG.error(this.getText() + "\n parent=" + this.getParent().getText());
        }
        T t = child;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "notNullChild"));
        }
        return t;
    }

    @NotNull
    protected <T> T[] findChildrenByClass(Class<T> aClass2) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass2.isInstance(cur)) continue;
            result2.add(cur);
        }
        Object[] objectArray = result2.toArray((Object[])Array.newInstance(aClass2, result2.size()));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "findChildrenByClass"));
        }
        return objectArray;
    }

    @Nullable
    protected <T> T findChildByClass(Class<T> aClass2) {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!aClass2.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @NotNull
    protected <T> T findNotNullChildByClass(Class<T> aClass2) {
        T t = this.notNullChild(this.findChildByClass(aClass2));
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiElementBase", "findNotNullChildByClass"));
        }
        return t;
    }

    @Override
    public PsiManager getManager() {
        return PsiManager.getInstance(this.getProject());
    }
}

