/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.com.google.common.base.Predicate;
import org.jetbrains.kotlin.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

public class RedundantBoxingMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode node) {
        if (internalClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalClassName", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "transform"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "transform"));
        }
        RedundantBoxingInterpreter interpreter = new RedundantBoxingInterpreter(node.instructions);
        Frame<BasicValue>[] frames2 = RedundantBoxingMethodTransformer.analyze(internalClassName, node, interpreter);
        RedundantBoxingMethodTransformer.interpretPopInstructionsForBoxedValues(interpreter, node, frames2);
        RedundantBoxedValuesCollection valuesToOptimize = interpreter.getCandidatesBoxedValues();
        if (!valuesToOptimize.isEmpty()) {
            RedundantBoxingMethodTransformer.removeValuesClashingWithVariables(valuesToOptimize, node, frames2);
            RedundantBoxingMethodTransformer.adaptLocalVariableTableForBoxedValues(node, frames2);
            RedundantBoxingMethodTransformer.applyVariablesRemapping(node, RedundantBoxingMethodTransformer.buildVariablesRemapping(valuesToOptimize, node));
            RedundantBoxingMethodTransformer.adaptInstructionsForBoxedValues(node, valuesToOptimize);
        }
    }

    private static void interpretPopInstructionsForBoxedValues(@NotNull RedundantBoxingInterpreter interpreter, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "interpretPopInstructionsForBoxedValues"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "interpretPopInstructionsForBoxedValues"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "interpretPopInstructionsForBoxedValues"));
        }
        for (int i = 0; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (insn.getOpcode() != 87 && insn.getOpcode() != 88 || frames2[i] == null) continue;
            BasicValue top = frames2[i].getStack(frames2[i].getStackSize() - 1);
            interpreter.processPopInstruction(insn, top);
            if (top.getSize() != 1 || insn.getOpcode() != 88) continue;
            interpreter.processPopInstruction(insn, frames2[i].getStack(frames2[i].getStackSize() - 2));
        }
    }

    private static void removeValuesClashingWithVariables(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariables"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariables"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariables"));
        }
        while (RedundantBoxingMethodTransformer.removeValuesClashingWithVariablesPass(values, node, frames2)) {
        }
    }

    private static boolean removeValuesClashingWithVariablesPass(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariablesPass"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariablesPass"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "removeValuesClashingWithVariablesPass"));
        }
        boolean needToRepeat = false;
        for (LocalVariableNode localVariableNode : node.localVariables) {
            BoxedBasicValue firstBoxed;
            List<BasicValue> usedValues;
            Collection<BasicValue> boxed;
            if (Type.getType(localVariableNode.desc).getSort() != 10 || (boxed = Collections2.filter(usedValues = RedundantBoxingMethodTransformer.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2), new Predicate<BasicValue>(){

                @Override
                public boolean apply(BasicValue input) {
                    return input instanceof BoxedBasicValue;
                }
            })).isEmpty() || !CollectionsKt.any(usedValues, new Function1<BasicValue, Boolean>(firstBoxed = (BoxedBasicValue)boxed.iterator().next()){
                final /* synthetic */ BoxedBasicValue val$firstBoxed;
                {
                    this.val$firstBoxed = boxedBasicValue;
                }

                @Override
                public Boolean invoke(BasicValue input) {
                    if (input == StrictBasicValue.UNINITIALIZED_VALUE) {
                        return false;
                    }
                    return input == null || !(input instanceof BoxedBasicValue) || !((BoxedBasicValue)input).isSafeToRemove() || !((BoxedBasicValue)input).getPrimitiveType().equals(this.val$firstBoxed.getPrimitiveType());
                }
            })) continue;
            for (BasicValue value : usedValues) {
                if (!(value instanceof BoxedBasicValue) || !((BoxedBasicValue)value).isSafeToRemove()) continue;
                values.remove((BoxedBasicValue)value);
                needToRepeat = true;
            }
        }
        return needToRepeat;
    }

    private static void adaptLocalVariableTableForBoxedValues(@NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptLocalVariableTableForBoxedValues"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptLocalVariableTableForBoxedValues"));
        }
        for (LocalVariableNode localVariableNode : node.localVariables) {
            if (Type.getType(localVariableNode.desc).getSort() != 10) continue;
            for (BasicValue value : RedundantBoxingMethodTransformer.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2)) {
                if (value == null || !(value instanceof BoxedBasicValue) || !((BoxedBasicValue)value).isSafeToRemove()) continue;
                localVariableNode.desc = ((BoxedBasicValue)value).getPrimitiveType().getDescriptor();
            }
        }
    }

    @NotNull
    private static List<BasicValue> getValuesStoredOrLoadedToVariable(@NotNull LocalVariableNode localVariableNode, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        BasicValue localVarValue;
        if (localVariableNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localVariableNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        if (frames2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        ArrayList<BasicValue> values = new ArrayList<BasicValue>();
        InsnList insnList = node.instructions;
        int from = insnList.indexOf(localVariableNode.start) + 1;
        int to = insnList.indexOf(localVariableNode.end) - 1;
        Frame<BasicValue> frameForFromInstr = frames2[from];
        if (frameForFromInstr != null && (localVarValue = frameForFromInstr.getLocal(localVariableNode.index)) != null) {
            values.add(localVarValue);
        }
        for (int i = from; i <= to; ++i) {
            AbstractInsnNode insn;
            if (i < 0 || i >= insnList.size() || (insn = insnList.get(i)).getOpcode() != 58 && insn.getOpcode() != 25 || ((VarInsnNode)insn).var != localVariableNode.index || frames2[i] == null) continue;
            if (insn.getOpcode() == 58) {
                values.add(frames2[i].getStack(frames2[i].getStackSize() - 1));
                continue;
            }
            values.add(frames2[i].getLocal(((VarInsnNode)insn).var));
        }
        ArrayList<BasicValue> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "getValuesStoredOrLoadedToVariable"));
        }
        return arrayList;
    }

    @NotNull
    private static int[] buildVariablesRemapping(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "buildVariablesRemapping"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "buildVariablesRemapping"));
        }
        HashSet<Integer> doubleSizedVars = new HashSet<Integer>();
        for (BoxedBasicValue value : values) {
            if (value.getPrimitiveType().getSize() != 2) continue;
            doubleSizedVars.addAll(value.getVariablesIndexes());
        }
        node.maxLocals += doubleSizedVars.size();
        int[] remapping = new int[node.maxLocals];
        for (int i = 0; i < remapping.length; ++i) {
            remapping[i] = i;
        }
        Iterator i$ = doubleSizedVars.iterator();
        while (i$.hasNext()) {
            int varIndex = (Integer)i$.next();
            int i = varIndex + 1;
            while (i < remapping.length) {
                int n = i++;
                remapping[n] = remapping[n] + 1;
            }
        }
        if (remapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "buildVariablesRemapping"));
        }
        return remapping;
    }

    private static void applyVariablesRemapping(@NotNull MethodNode node, @NotNull int[] remapping) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "applyVariablesRemapping"));
        }
        if (remapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapping", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "applyVariablesRemapping"));
        }
        for (AbstractInsnNode insn : node.instructions.toArray()) {
            if (insn instanceof VarInsnNode) {
                ((VarInsnNode)insn).var = remapping[((VarInsnNode)insn).var];
            }
            if (!(insn instanceof IincInsnNode)) continue;
            ((IincInsnNode)insn).var = remapping[((IincInsnNode)insn).var];
        }
        for (LocalVariableNode localVariableNode : node.localVariables) {
            localVariableNode.index = remapping[localVariableNode.index];
        }
    }

    private static void adaptInstructionsForBoxedValues(@NotNull MethodNode node, @NotNull RedundantBoxedValuesCollection values) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValues"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValues"));
        }
        for (BoxedBasicValue value : values) {
            RedundantBoxingMethodTransformer.adaptInstructionsForBoxedValue(node, value);
        }
    }

    private static void adaptInstructionsForBoxedValue(@NotNull MethodNode node, @NotNull BoxedBasicValue value) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstructionsForBoxedValue"));
        }
        RedundantBoxingMethodTransformer.adaptBoxingInstruction(node, value);
        for (Pair<AbstractInsnNode, Type> cast : value.getUnboxingWithCastInsns()) {
            RedundantBoxingMethodTransformer.adaptCastInstruction(node, value, cast);
        }
        for (AbstractInsnNode insn : value.getAssociatedInsns()) {
            RedundantBoxingMethodTransformer.adaptInstruction(node, insn, value);
        }
    }

    private static void adaptBoxingInstruction(@NotNull MethodNode node, @NotNull BoxedBasicValue value) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptBoxingInstruction"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptBoxingInstruction"));
        }
        if (!value.isFromProgressionIterator()) {
            node.instructions.remove(value.getBoxingInsn());
        } else {
            ProgressionIteratorBasicValue iterator2 = value.getProgressionIterator();
            assert (iterator2 != null) : "iterator should not be null because isFromProgressionIterator returns true";
            node.instructions.insertBefore(value.getBoxingInsn(), new TypeInsnNode(192, iterator2.getType().getInternalName()));
            node.instructions.set(value.getBoxingInsn(), new MethodInsnNode(182, iterator2.getType().getInternalName(), iterator2.getNextMethodName(), iterator2.getNextMethodDesc(), false));
        }
    }

    private static void adaptCastInstruction(@NotNull MethodNode node, @NotNull BoxedBasicValue value, @NotNull Pair<AbstractInsnNode, Type> castWithType) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptCastInstruction"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptCastInstruction"));
        }
        if (castWithType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castWithType", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptCastInstruction"));
        }
        AbstractInsnNode castInsn = castWithType.getFirst();
        MethodNode castInsnsListener = new MethodNode(327680);
        new InstructionAdapter(castInsnsListener).cast(value.getPrimitiveType(), castWithType.getSecond());
        for (AbstractInsnNode insn : castInsnsListener.instructions.toArray()) {
            node.instructions.insertBefore(castInsn, insn);
        }
        node.instructions.remove(castInsn);
    }

    private static void adaptInstruction(@NotNull MethodNode node, @NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstruction"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstruction"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer", "adaptInstruction"));
        }
        boolean isDoubleSize = value.isDoubleSize();
        switch (insn.getOpcode()) {
            case 87: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, new InsnNode(88));
                break;
            }
            case 89: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, new InsnNode(92));
                break;
            }
            case 25: 
            case 58: {
                int intVarOpcode = insn.getOpcode() == 58 ? 54 : 21;
                node.instructions.set(insn, new VarInsnNode(value.getPrimitiveType().getOpcode(intVarOpcode), ((VarInsnNode)insn).var));
                break;
            }
            case 193: {
                node.instructions.insertBefore(insn, new InsnNode(isDoubleSize ? 88 : 87));
                node.instructions.set(insn, new InsnNode(4));
                break;
            }
            default: {
                node.instructions.remove(insn);
            }
        }
    }
}

