/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.AnonymousObjectTransformationInfo;
import org.jetbrains.kotlin.codegen.inline.AsmTypeRemapper;
import org.jetbrains.kotlin.codegen.inline.CapturedParamDesc;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.InlineAdapter;
import org.jetbrains.kotlin.codegen.inline.InlineCallSiteInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.InlineException;
import org.jetbrains.kotlin.codegen.inline.InlineLambdaSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineOnlySmapSkipper;
import org.jetbrains.kotlin.codegen.inline.InlineResult;
import org.jetbrains.kotlin.codegen.inline.InlinedLambdaRemapper;
import org.jetbrains.kotlin.codegen.inline.InliningContext;
import org.jetbrains.kotlin.codegen.inline.InternalFinallyBlockInliner;
import org.jetbrains.kotlin.codegen.inline.InvokeCall;
import org.jetbrains.kotlin.codegen.inline.LabelOwner;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodBodyVisitor;
import org.jetbrains.kotlin.codegen.inline.MethodInlinerUtilKt;
import org.jetbrains.kotlin.codegen.inline.NestedSourceMapper;
import org.jetbrains.kotlin.codegen.inline.ObjectTransformer;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.RegeneratedClassContext;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.RemapVisitor;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.inline.TransformationInfo;
import org.jetbrains.kotlin.codegen.inline.TypeRemapper;
import org.jetbrains.kotlin.codegen.inline.WhenMappingTransformationInfo;
import org.jetbrains.kotlin.codegen.optimization.MandatoryMethodTransformer;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.commons.RemappingMethodAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SourceValue;
import org.jetbrains.org.objectweb.asm.util.Printer;

public class MethodInliner {
    private final MethodNode node;
    private final Parameters parameters;
    private final InliningContext inliningContext;
    private final FieldRemapper nodeRemapper;
    private final boolean isSameModule;
    private final String errorPrefix;
    private final SourceMapper sourceMapper;
    private final InlineCallSiteInfo inlineCallSiteInfo;
    private final KotlinTypeMapper typeMapper;
    private final List<InvokeCall> invokeCalls;
    private final List<TransformationInfo> transformations;
    private final Map<String, String> currentTypeMapping;
    private final InlineResult result;
    private int lambdasFinallyBlocks;
    private final InlineOnlySmapSkipper inlineOnlySmapSkipper;

    public MethodInliner(@NotNull MethodNode node, @NotNull Parameters parameters2, @NotNull InliningContext inliningContext, @NotNull FieldRemapper nodeRemapper, boolean isSameModule, @NotNull String errorPrefix, @NotNull SourceMapper sourceMapper, @NotNull InlineCallSiteInfo inlineCallSiteInfo, @Nullable InlineOnlySmapSkipper smapSkipper) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (inliningContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inliningContext", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (nodeRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeRemapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (errorPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPrefix", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (sourceMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        if (inlineCallSiteInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineCallSiteInfo", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "<init>"));
        }
        this.invokeCalls = new ArrayList<InvokeCall>();
        this.transformations = new ArrayList<TransformationInfo>();
        this.currentTypeMapping = new HashMap<String, String>();
        this.node = node;
        this.parameters = parameters2;
        this.inliningContext = inliningContext;
        this.nodeRemapper = nodeRemapper;
        this.isSameModule = isSameModule;
        this.errorPrefix = errorPrefix;
        this.sourceMapper = sourceMapper;
        this.inlineCallSiteInfo = inlineCallSiteInfo;
        this.typeMapper = inliningContext.state.getTypeMapper();
        this.result = InlineResult.create();
        this.inlineOnlySmapSkipper = smapSkipper;
    }

    @NotNull
    public InlineResult doInline(@NotNull MethodVisitor adapter, @NotNull LocalVarRemapper remapper, boolean remapReturn, @NotNull LabelOwner labelOwner) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        if (labelOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelOwner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        InlineResult inlineResult = this.doInline(adapter, remapper, remapReturn, labelOwner, 0);
        if (inlineResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        return inlineResult;
    }

    @NotNull
    private InlineResult doInline(@NotNull MethodVisitor adapter, @NotNull LocalVarRemapper remapper, boolean remapReturn, @NotNull LabelOwner labelOwner, int finallyDeepShift) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        if (labelOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelOwner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        MethodNode transformedNode = this.markPlacesForInlineAndRemoveInlinable(this.node, labelOwner, finallyDeepShift);
        Label end = new Label();
        transformedNode = this.doInline(transformedNode);
        MethodInliner.removeClosureAssertions(transformedNode);
        transformedNode.instructions.resetLabels();
        MethodNode resultNode = new MethodNode(327680, transformedNode.access, transformedNode.name, transformedNode.desc, transformedNode.signature, ArrayUtil.toStringArray(transformedNode.exceptions));
        RemapVisitor visitor2 = new RemapVisitor(resultNode, remapper, this.nodeRemapper);
        try {
            transformedNode.accept(visitor2);
        }
        catch (Exception e) {
            throw this.wrapException(e, transformedNode, "couldn't inline method call");
        }
        resultNode.visitLabel(end);
        if (this.inliningContext.isRoot()) {
            StackValue remapValue = remapper.remap((int)(this.parameters.getArgsSizeOnStack() + 1)).value;
            InternalFinallyBlockInliner.processInlineFunFinallyBlocks(resultNode, this.lambdasFinallyBlocks, ((StackValue.Local)remapValue).index);
        }
        MethodInliner.processReturns(resultNode, labelOwner, remapReturn, end);
        resultNode.accept(new MethodBodyVisitor(adapter));
        this.sourceMapper.endMapping();
        InlineResult inlineResult = this.result;
        if (inlineResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        return inlineResult;
    }

    @NotNull
    private MethodNode doInline(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        final LinkedList<InvokeCall> currentInvokes = new LinkedList<InvokeCall>(this.invokeCalls);
        final MethodNode resultNode = new MethodNode(node.access, node.name, node.desc, node.signature, null);
        final Iterator<TransformationInfo> iterator2 = this.transformations.iterator();
        final TypeRemapper remapper = TypeRemapper.createFrom(this.currentTypeMapping);
        final RemappingMethodAdapter remappingMethodAdapter = new RemappingMethodAdapter(resultNode.access, resultNode.desc, resultNode, new AsmTypeRemapper(remapper, this.inliningContext.getRoot().typeParameterMappings == null, this.result));
        final int markerShift = InlineCodegenUtil.calcMarkerShift(this.parameters, node);
        InlineAdapter lambdaInliner = new InlineAdapter(remappingMethodAdapter, this.parameters.getArgsSizeOnStack(), this.sourceMapper){
            private TransformationInfo transformationInfo;

            private void handleAnonymousObjectRegeneration() {
                this.transformationInfo = (TransformationInfo)iterator2.next();
                if (this.transformationInfo.shouldRegenerate(MethodInliner.this.isSameModule)) {
                    String oldClassName = this.transformationInfo.getOldClassName();
                    String newClassName = this.transformationInfo.getNewClassName();
                    remapper.addMapping(oldClassName, newClassName);
                    InliningContext childInliningContext = MethodInliner.this.inliningContext.subInlineWithClassRegeneration(((MethodInliner)MethodInliner.this).inliningContext.nameGenerator, MethodInliner.this.currentTypeMapping, MethodInliner.this.inlineCallSiteInfo);
                    ObjectTransformer<?> transformer = this.transformationInfo.createTransformer(childInliningContext, MethodInliner.this.isSameModule);
                    InlineResult transformResult = transformer.doTransform(MethodInliner.this.nodeRemapper);
                    MethodInliner.this.result.addAllClassesToRemove(transformResult);
                    MethodInliner.this.result.addChangedType(oldClassName, newClassName);
                    if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda && this.transformationInfo.canRemoveAfterTransformation()) {
                        MethodInliner.this.result.addClassToRemove(oldClassName);
                    }
                    if (transformResult.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
                        ReifiedTypeInliner.putNeedClassReificationMarker(this.mv);
                        MethodInliner.this.result.getReifiedTypeParametersUsages().mergeAll(transformResult.getReifiedTypeParametersUsages());
                    }
                }
            }

            @Override
            public void anew(@NotNull Type type2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "anew"));
                }
                if (InlineCodegenUtil.isAnonymousClass(type2.getInternalName())) {
                    this.handleAnonymousObjectRegeneration();
                }
                super.anew(type2);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                    assert (!currentInvokes.isEmpty());
                    InvokeCall invokeCall = (InvokeCall)currentInvokes.remove();
                    LambdaInfo info = invokeCall.lambdaInfo;
                    if (info == null) {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        return;
                    }
                    int valueParamShift = Math.max(this.getNextLocalIndex(), markerShift);
                    MethodInliner.putStackValuesIntoLocals(info.getInvokeParamsWithoutCaptured(), valueParamShift, this, desc);
                    if (invokeCall.lambdaInfo.getFunctionDescriptor().getValueParameters().isEmpty()) {
                        this.visitInsn(0);
                    }
                    InlineCodegenUtil.addInlineMarker(this, true);
                    Parameters lambdaParameters = info.addAllParameters(MethodInliner.this.nodeRemapper);
                    InlinedLambdaRemapper newCapturedRemapper = new InlinedLambdaRemapper(info.getLambdaClassType().getInternalName(), MethodInliner.this.nodeRemapper, lambdaParameters);
                    this.setLambdaInlining(true);
                    SMAP lambdaSMAP = info.getNode().getClassSMAP();
                    NestedSourceMapper mapper = ((MethodInliner)MethodInliner.this).inliningContext.classRegeneration && !((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda ? new NestedSourceMapper(MethodInliner.this.sourceMapper, lambdaSMAP.getIntervals(), lambdaSMAP.getSourceInfo()) : new InlineLambdaSourceMapper(MethodInliner.this.sourceMapper.getParent(), info.getNode());
                    MethodInliner inliner = new MethodInliner(info.getNode().getNode(), lambdaParameters, MethodInliner.this.inliningContext.subInlineLambda(info), newCapturedRemapper, true, "Lambda inlining " + info.getLambdaClassType().getInternalName(), mapper, MethodInliner.this.inlineCallSiteInfo, null);
                    LocalVarRemapper remapper2 = new LocalVarRemapper(lambdaParameters, valueParamShift);
                    InlineResult lambdaResult = inliner.doInline(this.mv, remapper2, true, info, invokeCall.finallyDepthShift);
                    MethodInliner.this.result.addAllClassesToRemove(lambdaResult);
                    Method bridge = MethodInliner.this.typeMapper.mapAsmMethod(ClosureCodegen.getErasedInvokeFunction(info.getFunctionDescriptor()));
                    Method delegate2 = MethodInliner.this.typeMapper.mapAsmMethod(info.getFunctionDescriptor());
                    StackValue.onStack(delegate2.getReturnType()).put(bridge.getReturnType(), this);
                    this.setLambdaInlining(false);
                    InlineCodegenUtil.addInlineMarker(this, false);
                    mapper.endMapping();
                    if (MethodInliner.this.inlineOnlySmapSkipper != null) {
                        MethodInliner.this.inlineOnlySmapSkipper.markCallSiteLineNumber(remappingMethodAdapter);
                    }
                } else if (InlineCodegenUtil.isAnonymousConstructorCall(owner, name)) {
                    assert (this.transformationInfo instanceof AnonymousObjectTransformationInfo) : "<init> call doesn't correspond to object transformation info: " + owner + "." + name + ", info " + this.transformationInfo;
                    if (this.transformationInfo.shouldRegenerate(MethodInliner.this.isSameModule)) {
                        AnonymousObjectTransformationInfo info = (AnonymousObjectTransformationInfo)this.transformationInfo;
                        for (CapturedParamDesc capturedParamDesc : info.getAllRecapturedParameters()) {
                            this.visitFieldInsn(178, capturedParamDesc.getContainingLambdaName(), "$$$" + capturedParamDesc.getFieldName(), capturedParamDesc.getType().getDescriptor());
                        }
                        super.visitMethodInsn(opcode, this.transformationInfo.getNewClassName(), name, info.getNewConstructorDescriptor(), itf);
                        if (MethodInliner.this.inliningContext.getParent() instanceof RegeneratedClassContext) {
                            ((MethodInliner)MethodInliner.this).inliningContext.getParent().typeRemapper.addAdditionalMappings(this.transformationInfo.getOldClassName(), this.transformationInfo.getNewClassName());
                        }
                        this.transformationInfo = null;
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                } else if (((MethodInliner)MethodInliner.this).inliningContext.isInliningLambda || !ReifiedTypeInliner.isNeedClassReificationMarker(new MethodInsnNode(opcode, owner, name, desc, false))) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            @Override
            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String desc) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "visitFieldInsn"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "visitFieldInsn"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MethodInliner$1", "visitFieldInsn"));
                }
                if (opcode == 178 && (InlineCodegenUtil.isAnonymousSingletonLoad(owner, name) || InlineCodegenUtil.isWhenMappingAccess(owner, name))) {
                    this.handleAnonymousObjectRegeneration();
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            @Override
            public void visitMaxs(int stack, int locals) {
                MethodInliner.this.lambdasFinallyBlocks = resultNode.tryCatchBlocks.size();
                super.visitMaxs(stack, locals);
            }
        };
        node.accept(lambdaInliner);
        MethodNode methodNode = resultNode;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "doInline"));
        }
        return methodNode;
    }

    @NotNull
    public static CapturedParamInfo findCapturedField(@NotNull FieldInsnNode node, @NotNull FieldRemapper fieldRemapper) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "findCapturedField"));
        }
        if (fieldRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldRemapper", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "findCapturedField"));
        }
        assert (node.name.startsWith("$$$")) : "Captured field template should start with $$$ prefix";
        FieldInsnNode fin = new FieldInsnNode(node.getOpcode(), node.owner, node.name.substring(3), node.desc);
        CapturedParamInfo field = fieldRemapper.findField(fin);
        if (field == null) {
            throw new IllegalStateException("Couldn't find captured field " + node.owner + "." + node.name + " in " + fieldRemapper.getLambdaInternalName());
        }
        CapturedParamInfo capturedParamInfo = field;
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "findCapturedField"));
        }
        return capturedParamInfo;
    }

    @NotNull
    private MethodNode prepareNode(@NotNull MethodNode node, int finallyDeepShift) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "prepareNode"));
        }
        final int capturedParamsSize = this.parameters.getCapturedArgsSizeOnStack();
        final int realParametersSize = this.parameters.getRealArgsSizeOnStack();
        Type[] types = Type.getArgumentTypes(node.desc);
        Type returnType2 = Type.getReturnType(node.desc);
        List<Type> capturedTypes = this.parameters.getCapturedTypes();
        Type[] allTypes = ArrayUtil.mergeArrays(types, capturedTypes.toArray(new Type[capturedTypes.size()]));
        node.instructions.resetLabels();
        MethodNode transformedNode = new MethodNode(327680, node.access, node.name, Type.getMethodDescriptor(returnType2, allTypes), node.signature, null){
            private final boolean GENERATE_DEBUG_INFO;
            private final boolean isInliningLambda;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.GENERATE_DEBUG_INFO = MethodInliner.this.inlineOnlySmapSkipper == null;
                this.isInliningLambda = MethodInliner.this.nodeRemapper.isInsideInliningLambda();
            }

            private int getNewIndex(int var) {
                return var + (var < realParametersSize ? 0 : capturedParamsSize);
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, this.getNewIndex(var));
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                super.visitIincInsn(this.getNewIndex(var), increment);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack, maxLocals + capturedParamsSize);
            }

            @Override
            public void visitLineNumber(int line, @NotNull Label start) {
                if (start == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLineNumber"));
                }
                if (this.isInliningLambda || this.GENERATE_DEBUG_INFO) {
                    super.visitLineNumber(line, start);
                }
            }

            @Override
            public void visitLocalVariable(@NotNull String name, @NotNull String desc, String signature2, @NotNull Label start, @NotNull Label end, int index2) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (start == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (end == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/MethodInliner$2", "visitLocalVariable"));
                }
                if (this.isInliningLambda || this.GENERATE_DEBUG_INFO) {
                    String varSuffix = MethodInliner.this.inliningContext.isRoot() && !InlineCodegenUtil.isFakeLocalVariableForInline(name) ? "$iv" : "";
                    String varName = !varSuffix.isEmpty() && name.equals("this") ? name + "_" : name;
                    super.visitLocalVariable(varName + varSuffix, desc, signature2, start, end, this.getNewIndex(index2));
                }
            }
        };
        node.accept(transformedNode);
        this.transformCaptured(transformedNode);
        MethodInliner.transformFinallyDeepIndex(transformedNode, finallyDeepShift);
        MethodNode methodNode = transformedNode;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "prepareNode"));
        }
        return methodNode;
    }

    @NotNull
    private MethodNode markPlacesForInlineAndRemoveInlinable(@NotNull MethodNode node, @NotNull LabelOwner labelOwner, int finallyDeepShift) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        if (labelOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelOwner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        node = this.prepareNode(node, finallyDeepShift);
        Frame<SourceValue>[] sources = this.analyzeMethodNodeBeforeInline(node);
        LocalReturnsNormalizer localReturnsNormalizer = LocalReturnsNormalizer.createFor(node, labelOwner, sources);
        SmartSet<AbstractInsnNode> toDelete = SmartSet.create();
        InsnList instructions = node.instructions;
        boolean awaitClassReification = false;
        int currentFinallyDeep = 0;
        for (AbstractInsnNode cur = instructions.getFirst(); cur != null; cur = cur.getNext()) {
            Frame<SourceValue> frame = sources[instructions.indexOf(cur)];
            if (frame != null) {
                if (ReifiedTypeInliner.isNeedClassReificationMarker(cur)) {
                    awaitClassReification = true;
                } else if (cur.getType() == 5) {
                    if (InlineCodegenUtil.isFinallyStart(cur)) {
                        currentFinallyDeep = InlineCodegenUtil.getConstant(cur.getPrevious());
                    }
                    MethodInsnNode methodInsnNode = (MethodInsnNode)cur;
                    String owner = methodInsnNode.owner;
                    String desc = methodInsnNode.desc;
                    String name = methodInsnNode.name;
                    Type[] argTypes = Type.getArgumentTypes(desc);
                    int paramCount = argTypes.length + 1;
                    int firstParameterIndex = frame.getStackSize() - paramCount;
                    if (InlineCodegenUtil.isInvokeOnLambda(owner, name)) {
                        SourceValue sourceValue = frame.getStack(firstParameterIndex);
                        LambdaInfo lambdaInfo = MethodInlinerUtilKt.getLambdaIfExistsAndMarkInstructions(this, MethodInlinerUtilKt.singleOrNullInsn(sourceValue), true, instructions, sources, toDelete);
                        this.invokeCalls.add(new InvokeCall(lambdaInfo, currentFinallyDeep));
                    } else if (InlineCodegenUtil.isAnonymousConstructorCall(owner, name)) {
                        HashMap<Integer, LambdaInfo> lambdaMapping = new HashMap<Integer, LambdaInfo>();
                        int offset2 = 0;
                        for (int i = 0; i < paramCount; ++i) {
                            SourceValue sourceValue = frame.getStack(firstParameterIndex + i);
                            LambdaInfo lambdaInfo = MethodInlinerUtilKt.getLambdaIfExistsAndMarkInstructions(this, MethodInlinerUtilKt.singleOrNullInsn(sourceValue), false, instructions, sources, toDelete);
                            if (lambdaInfo != null) {
                                lambdaMapping.put(offset2, lambdaInfo);
                            }
                            offset2 += i == 0 ? 1 : argTypes[i - 1].getSize();
                        }
                        this.transformations.add(this.buildConstructorInvocation(owner, desc, lambdaMapping, awaitClassReification));
                        awaitClassReification = false;
                    }
                } else if (cur.getOpcode() == 178) {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)cur;
                    String className2 = fieldInsnNode.owner;
                    if (InlineCodegenUtil.isAnonymousSingletonLoad(className2, fieldInsnNode.name)) {
                        this.transformations.add(new AnonymousObjectTransformationInfo(className2, awaitClassReification, this.isAlreadyRegenerated(className2), true, this.inliningContext.nameGenerator));
                        awaitClassReification = false;
                    } else if (InlineCodegenUtil.isWhenMappingAccess(className2, fieldInsnNode.name)) {
                        this.transformations.add(new WhenMappingTransformationInfo(className2, this.inliningContext.nameGenerator, this.isAlreadyRegenerated(className2), fieldInsnNode));
                    }
                }
            }
            AbstractInsnNode prevNode = cur;
            if (frame != null || prevNode.getType() == 8) continue;
            toDelete.add(prevNode);
        }
        for (AbstractInsnNode insnNode : toDelete) {
            instructions.remove(insnNode);
        }
        List<TryCatchBlockNode> blocks = node.tryCatchBlocks;
        Iterator<TryCatchBlockNode> iterator2 = blocks.iterator();
        while (iterator2.hasNext()) {
            TryCatchBlockNode block = iterator2.next();
            if (!MethodInliner.isEmptyTryInterval(block)) continue;
            iterator2.remove();
        }
        localReturnsNormalizer.transform(node);
        MethodNode methodNode = node;
        if (methodNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "markPlacesForInlineAndRemoveInlinable"));
        }
        return methodNode;
    }

    @NotNull
    private Frame<SourceValue>[] analyzeMethodNodeBeforeInline(@NotNull MethodNode node) {
        Frame<V>[] frameArray;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "analyzeMethodNodeBeforeInline"));
        }
        try {
            new MandatoryMethodTransformer().transform("fake", node);
        }
        catch (Throwable e) {
            throw this.wrapException(e, node, "couldn't inline method call");
        }
        Analyzer<SourceValue> analyzer = new Analyzer<SourceValue>((Interpreter)new SourceInterpreter()){

            @Override
            @NotNull
            protected Frame<SourceValue> newFrame(int nLocals, int nStack) {
                Frame<SourceValue> frame = new Frame<SourceValue>(nLocals, nStack){

                    @Override
                    public void execute(@NotNull AbstractInsnNode insn, Interpreter<SourceValue> interpreter) throws AnalyzerException {
                        if (insn == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$3$1", "execute"));
                        }
                        if (insn.getOpcode() == 177) {
                            return;
                        }
                        super.execute(insn, interpreter);
                    }
                };
                if (frame == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner$3", "newFrame"));
                }
                return frame;
            }
        };
        try {
            frameArray = analyzer.analyze("fake", node);
        }
        catch (AnalyzerException e) {
            throw this.wrapException(e, node, "couldn't inline method call");
        }
        if (frameArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "analyzeMethodNodeBeforeInline"));
        }
        return frameArray;
    }

    private static boolean isEmptyTryInterval(@NotNull TryCatchBlockNode tryCatchBlockNode) {
        AbstractInsnNode end;
        if (tryCatchBlockNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchBlockNode", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "isEmptyTryInterval"));
        }
        LabelNode start = tryCatchBlockNode.start;
        for (end = tryCatchBlockNode.end; end != start && end instanceof LabelNode; end = end.getPrevious()) {
        }
        return start == end;
    }

    @NotNull
    private AnonymousObjectTransformationInfo buildConstructorInvocation(@NotNull String anonymousType, @NotNull String desc, @NotNull Map<Integer, LambdaInfo> lambdaMapping, boolean needReification) {
        if (anonymousType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousType", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        if (lambdaMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaMapping", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        AnonymousObjectTransformationInfo anonymousObjectTransformationInfo = new AnonymousObjectTransformationInfo(anonymousType, needReification, lambdaMapping, this.inliningContext.classRegeneration, this.isAlreadyRegenerated(anonymousType), desc, false, this.inliningContext.nameGenerator);
        if (anonymousObjectTransformationInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "buildConstructorInvocation"));
        }
        return anonymousObjectTransformationInfo;
    }

    private boolean isAlreadyRegenerated(@NotNull String owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "isAlreadyRegenerated"));
        }
        return this.inliningContext.typeRemapper.hasNoAdditionalMapping(owner);
    }

    @Nullable
    LambdaInfo getLambdaIfExists(@Nullable AbstractInsnNode insnNode) {
        if (insnNode == null) {
            return null;
        }
        if (insnNode.getOpcode() == 25) {
            int varIndex = ((VarInsnNode)insnNode).var;
            return this.getLambdaIfExists(varIndex);
        }
        if (insnNode instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
            if (fieldInsnNode.name.startsWith("$$$")) {
                return MethodInliner.findCapturedField(fieldInsnNode, this.nodeRemapper).getLambda();
            }
        }
        return null;
    }

    @Nullable
    private LambdaInfo getLambdaIfExists(int varIndex) {
        if (varIndex < this.parameters.getArgsSizeOnStack()) {
            return this.parameters.getParameterByDeclarationSlot(varIndex).getLambda();
        }
        return null;
    }

    private static void removeClosureAssertions(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "removeClosureAssertions"));
        }
        AbstractInsnNode cur = node.instructions.getFirst();
        while (cur != null && cur.getNext() != null) {
            AbstractInsnNode next = cur.getNext();
            if (next.getType() == 5) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (methodInsnNode.name.equals("checkParameterIsNotNull") && methodInsnNode.owner.equals("kotlin/jvm/internal/Intrinsics")) {
                    AbstractInsnNode prev = cur.getPrevious();
                    assert (cur.getOpcode() == 18) : "checkParameterIsNotNull should go after LDC but " + cur;
                    assert (prev.getOpcode() == 25) : "checkParameterIsNotNull should be invoked on local var but " + prev;
                    node.instructions.remove(prev);
                    node.instructions.remove(cur);
                    cur = next.getNext();
                    node.instructions.remove(next);
                    next = cur;
                }
            }
            cur = next;
        }
    }

    private void transformCaptured(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "transformCaptured"));
        }
        if (this.nodeRemapper.isRoot()) {
            return;
        }
        for (AbstractInsnNode cur = node.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            List<AbstractInsnNode> accessChain;
            AbstractInsnNode insnNode;
            int varIndex;
            if (!(cur instanceof VarInsnNode) || cur.getOpcode() != 25 || (varIndex = ((VarInsnNode)cur).var) != 0 && !this.nodeRemapper.processNonAload0FieldAccessChains(this.getLambdaIfExists(varIndex) != null) || (insnNode = this.nodeRemapper.foldFieldAccessChainIfNeeded(accessChain = MethodInliner.getCapturedFieldAccessChain((VarInsnNode)cur), node)) == null) continue;
            cur = insnNode;
        }
    }

    private static void transformFinallyDeepIndex(@NotNull MethodNode node, int finallyDeepShift) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "transformFinallyDeepIndex"));
        }
        if (finallyDeepShift == 0) {
            return;
        }
        for (AbstractInsnNode cur = node.instructions.getFirst(); cur != null; cur = cur.getNext()) {
            if (!(cur instanceof MethodInsnNode) || !InlineCodegenUtil.isFinallyMarker(cur)) continue;
            AbstractInsnNode constant = cur.getPrevious();
            int curDeep = InlineCodegenUtil.getConstant(constant);
            node.instructions.insert(constant, new LdcInsnNode((Object)(curDeep + finallyDeepShift)));
            node.instructions.remove(constant);
        }
    }

    @NotNull
    private static List<AbstractInsnNode> getCapturedFieldAccessChain(@NotNull VarInsnNode aload0) {
        if (aload0 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aload0", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "getCapturedFieldAccessChain"));
        }
        ArrayList<AbstractInsnNode> fieldAccessChain = new ArrayList<AbstractInsnNode>();
        fieldAccessChain.add(aload0);
        AbstractInsnNode next = aload0.getNext();
        while (next != null && next instanceof FieldInsnNode || next instanceof LabelNode) {
            if (next instanceof LabelNode) {
                next = next.getNext();
                continue;
            }
            fieldAccessChain.add(next);
            if (!"this$0".equals(((FieldInsnNode)next).name)) break;
            next = next.getNext();
        }
        ArrayList<AbstractInsnNode> arrayList = fieldAccessChain;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "getCapturedFieldAccessChain"));
        }
        return arrayList;
    }

    private static void putStackValuesIntoLocals(@NotNull List<Type> directOrder, int shift, @NotNull InstructionAdapter iv, @NotNull String descriptor2) {
        if (directOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directOrder", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "putStackValuesIntoLocals"));
        }
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "putStackValuesIntoLocals"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "putStackValuesIntoLocals"));
        }
        Type[] actualParams = Type.getArgumentTypes(descriptor2);
        assert (actualParams.length == directOrder.size()) : "Number of expected and actual params should be equals!";
        int size = 0;
        for (Type next : directOrder) {
            size += next.getSize();
        }
        shift += size;
        int index2 = directOrder.size();
        for (Type next : Lists.reverse(directOrder)) {
            Type typeOnStack;
            shift -= next.getSize();
            if (!(typeOnStack = actualParams[--index2]).equals(next)) {
                StackValue.onStack(typeOnStack).put(next, iv);
            }
            iv.store(shift, next);
        }
    }

    @NotNull
    private RuntimeException wrapException(@NotNull Throwable originalException, @NotNull MethodNode node, @NotNull String errorSuffix) {
        if (originalException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalException", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        if (errorSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorSuffix", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        if (originalException instanceof InlineException) {
            InlineException inlineException = new InlineException(this.errorPrefix + ": " + errorSuffix, originalException);
            if (inlineException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
            }
            return inlineException;
        }
        InlineException inlineException = new InlineException(this.errorPrefix + ": " + errorSuffix + "\nCause: " + InlineCodegenUtil.getNodeText(node), originalException);
        if (inlineException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "wrapException"));
        }
        return inlineException;
    }

    @NotNull
    public static List<PointForExternalFinallyBlocks> processReturns(@NotNull MethodNode node, @NotNull LabelOwner labelOwner, boolean remapReturn, @Nullable Label endLabel) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
        }
        if (labelOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelOwner", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
        }
        if (!remapReturn) {
            List<PointForExternalFinallyBlocks> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
            }
            return list2;
        }
        ArrayList<PointForExternalFinallyBlocks> result2 = new ArrayList<PointForExternalFinallyBlocks>();
        InsnList instructions = node.instructions;
        for (AbstractInsnNode insnNode = instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (!InlineCodegenUtil.isReturnOpcode(insnNode.getOpcode())) continue;
            boolean isLocalReturn = true;
            String labelName = InlineCodegenUtil.getMarkedReturnLabelOrNull(insnNode);
            if (labelName != null && (isLocalReturn = labelOwner.isMyLabel(labelName))) {
                instructions.remove(insnNode.getPrevious());
            }
            if (isLocalReturn && endLabel != null) {
                LabelNode labelNode = (LabelNode)endLabel.info;
                JumpInsnNode jumpInsnNode = new JumpInsnNode(167, labelNode);
                instructions.insert(insnNode, jumpInsnNode);
                instructions.remove(insnNode);
                insnNode = jumpInsnNode;
            }
            LabelNode label = new LabelNode();
            instructions.insert(insnNode, label);
            result2.add(new PointForExternalFinallyBlocks(MethodInliner.getInstructionToInsertFinallyBefore(insnNode, isLocalReturn), InlineCodegenUtil.getReturnType(insnNode.getOpcode()), label));
        }
        ArrayList<PointForExternalFinallyBlocks> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "processReturns"));
        }
        return arrayList;
    }

    @NotNull
    private static AbstractInsnNode getInstructionToInsertFinallyBefore(@NotNull AbstractInsnNode nonLocalReturnOrJump, boolean isLocal) {
        if (nonLocalReturnOrJump == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonLocalReturnOrJump", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "getInstructionToInsertFinallyBefore"));
        }
        AbstractInsnNode abstractInsnNode = isLocal ? nonLocalReturnOrJump : nonLocalReturnOrJump.getPrevious();
        if (abstractInsnNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner", "getInstructionToInsertFinallyBefore"));
        }
        return abstractInsnNode;
    }

    public static class PointForExternalFinallyBlocks {
        public final AbstractInsnNode beforeIns;
        public final Type returnType;
        public final LabelNode finallyIntervalEnd;

        public PointForExternalFinallyBlocks(@NotNull AbstractInsnNode beforeIns, @NotNull Type returnType2, @NotNull LabelNode finallyIntervalEnd) {
            if (beforeIns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeIns", "org/jetbrains/kotlin/codegen/inline/MethodInliner$PointForExternalFinallyBlocks", "<init>"));
            }
            if (returnType2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/inline/MethodInliner$PointForExternalFinallyBlocks", "<init>"));
            }
            if (finallyIntervalEnd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyIntervalEnd", "org/jetbrains/kotlin/codegen/inline/MethodInliner$PointForExternalFinallyBlocks", "<init>"));
            }
            this.beforeIns = beforeIns;
            this.returnType = returnType2;
            this.finallyIntervalEnd = finallyIntervalEnd;
        }
    }

    private static class LocalReturnsNormalizer {
        private final List<LocalReturn> localReturns = new SmartList<LocalReturn>();
        private boolean needsReturnVariable = false;
        private int returnOpcode = -1;

        private LocalReturnsNormalizer() {
        }

        private void addLocalReturnToTransform(@NotNull AbstractInsnNode returnInsn, @NotNull AbstractInsnNode insertBeforeInsn, @NotNull Frame<SourceValue> sourceValueFrame) {
            if (returnInsn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnInsn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "addLocalReturnToTransform"));
            }
            if (insertBeforeInsn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertBeforeInsn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "addLocalReturnToTransform"));
            }
            if (sourceValueFrame == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceValueFrame", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "addLocalReturnToTransform"));
            }
            assert (InlineCodegenUtil.isReturnOpcode(returnInsn.getOpcode())) : "return instruction expected";
            assert (this.returnOpcode < 0 || this.returnOpcode == returnInsn.getOpcode()) : "Return op should be " + Printer.OPCODES[this.returnOpcode] + ", got " + Printer.OPCODES[returnInsn.getOpcode()];
            this.returnOpcode = returnInsn.getOpcode();
            this.localReturns.add(new LocalReturn(returnInsn, insertBeforeInsn, sourceValueFrame));
            if (returnInsn.getOpcode() != 177 && sourceValueFrame.getStackSize() > 1) {
                this.needsReturnVariable = true;
            }
        }

        public void transform(@NotNull MethodNode methodNode) {
            if (methodNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "transform"));
            }
            int returnVariableIndex = -1;
            if (this.needsReturnVariable) {
                returnVariableIndex = methodNode.maxLocals++;
            }
            for (LocalReturn localReturn : this.localReturns) {
                localReturn.transform(methodNode.instructions, returnVariableIndex);
            }
        }

        @NotNull
        public static LocalReturnsNormalizer createFor(@NotNull MethodNode methodNode, @NotNull LabelOwner owner, @NotNull Frame<SourceValue>[] frames2) {
            if (methodNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "createFor"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "createFor"));
            }
            if (frames2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "createFor"));
            }
            LocalReturnsNormalizer result2 = new LocalReturnsNormalizer();
            AbstractInsnNode[] instructions = methodNode.instructions.toArray();
            for (int i = 0; i < instructions.length; ++i) {
                AbstractInsnNode insnNode;
                Frame<SourceValue> frame = frames2[i];
                if (frame == null || !InlineCodegenUtil.isReturnOpcode((insnNode = instructions[i]).getOpcode())) continue;
                AbstractInsnNode insertBeforeInsn = insnNode;
                String labelName = InlineCodegenUtil.getMarkedReturnLabelOrNull(insnNode);
                if (labelName != null) {
                    if (!owner.isMyLabel(labelName)) continue;
                    insertBeforeInsn = insnNode.getPrevious();
                }
                result2.addLocalReturnToTransform(insnNode, insertBeforeInsn, frame);
            }
            LocalReturnsNormalizer localReturnsNormalizer = result2;
            if (localReturnsNormalizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer", "createFor"));
            }
            return localReturnsNormalizer;
        }

        private static class LocalReturn {
            private final AbstractInsnNode returnInsn;
            private final AbstractInsnNode insertBeforeInsn;
            private final Frame<SourceValue> frame;

            public LocalReturn(@NotNull AbstractInsnNode returnInsn, @NotNull AbstractInsnNode insertBeforeInsn, @NotNull Frame<SourceValue> frame) {
                if (returnInsn == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnInsn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer$LocalReturn", "<init>"));
                }
                if (insertBeforeInsn == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertBeforeInsn", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer$LocalReturn", "<init>"));
                }
                if (frame == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer$LocalReturn", "<init>"));
                }
                this.returnInsn = returnInsn;
                this.insertBeforeInsn = insertBeforeInsn;
                this.frame = frame;
            }

            public void transform(@NotNull InsnList insnList, int returnVariableIndex) {
                int actualStackSize;
                if (insnList == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insnList", "org/jetbrains/kotlin/codegen/inline/MethodInliner$LocalReturnsNormalizer$LocalReturn", "transform"));
                }
                boolean isReturnWithValue = this.returnInsn.getOpcode() != 177;
                int expectedStackSize = isReturnWithValue ? 1 : 0;
                if (expectedStackSize == (actualStackSize = this.frame.getStackSize())) {
                    return;
                }
                int stackSize = actualStackSize;
                if (isReturnWithValue) {
                    int storeOpcode = 54 + this.returnInsn.getOpcode() - 172;
                    insnList.insertBefore(this.insertBeforeInsn, new VarInsnNode(storeOpcode, returnVariableIndex));
                    --stackSize;
                }
                while (stackSize > 0) {
                    int stackElementSize = this.frame.getStack(stackSize - 1).getSize();
                    int popOpcode = stackElementSize == 1 ? 87 : 88;
                    insnList.insertBefore(this.insertBeforeInsn, new InsnNode(popOpcode));
                    --stackSize;
                }
                if (isReturnWithValue) {
                    int loadOpcode = 21 + this.returnInsn.getOpcode() - 172;
                    insnList.insertBefore(this.insertBeforeInsn, new VarInsnNode(loadOpcode, returnVariableIndex));
                }
            }
        }
    }
}

