/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;

public class VisibilityUtil {
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    @PsiModifier.ModifierConstant
    public static String getVisibilityModifier(PsiModifierList list2) {
        if (list2 == null) {
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list2.hasModifierProperty(modifier)) continue;
            return modifier;
        }
        return "packageLocal";
    }

    @NotNull
    public static String toPresentableText(@PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/com/intellij/util/VisibilityUtil", "toPresentableText"));
        }
        String string = PsiBundle.visibilityPresentation(modifier);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/VisibilityUtil", "toPresentableText"));
        }
        return string;
    }
}

